/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyleRange;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;

public class VhdlNonRuleBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument fDocument;
    private IToken fToken;
    protected VhdlStyle fColorManager;

    public VhdlNonRuleBasedDamagerRepairer(IToken token) {
        this.fToken = token;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    private int endOfLineOf(int offset) throws BadLocationException {
        try {
            IRegion info = this.fDocument.getLineInformationOfOffset(offset);
            if (offset <= info.getOffset() + info.getLength()) {
                return info.getOffset() + info.getLength();
            }
            int line = this.fDocument.getLineOfOffset(offset);
            info = this.fDocument.getLineInformation(line + 1);
            return info.getOffset() + info.getLength();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.fDocument.getLength();
        }
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            try {
                IRegion info = this.fDocument.getLineInformationOfOffset(e.getOffset());
                int start = Math.max(partition.getOffset(), info.getOffset());
                int end = e.getOffset() + (e.getText() == null ? e.getLength() : e.getText().length());
                end = info.getOffset() <= end && end <= info.getOffset() + info.getLength() ? info.getOffset() + info.getLength() : this.endOfLineOf(end);
                end = Math.min(partition.getOffset() + partition.getLength(), end);
                return new Region(start, end - start);
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return partition;
            }
        }
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        try {
            this.removeFoldingDelimiters(region.getOffset(), region.getOffset() + region.getLength());
            this.addRange(presentation, region.getOffset(), region.getLength(), (TextAttribute)this.fToken.getData());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            presentation.addStyleRange(styleRange);
        }
    }

    private void removeFoldingDelimiters(int start, int end) {
        try {
            if (!this.fDocument.containsPositionCategory("__dvt_folding_position")) {
                return;
            }
            Position[] positions = this.fDocument.getPositions("__dvt_folding_position");
            int i = positions.length - 1;
            while (i >= 0) {
                Position position = positions[i];
                if (position.getOffset() >= start && position.getOffset() < end) {
                    this.fDocument.removePosition("__dvt_folding_position", position);
                }
                --i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setToken(IToken token) {
        this.fToken = token;
    }
}

