/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class VhdlPartitionScanner
extends BufferedRuleBasedScanner
implements IPartitionTokenScanner {
    private STATE fState = STATE.CODE;
    private int fTokenLength = 0;
    private int fPrefixLength = 0;
    private boolean fBackslash = false;
    private boolean fIgnoreNextNL = false;
    private int fChar = 97;
    private int fPrevNonWhiteChar = 97;
    private boolean fLimitPartitionLength;

    public VhdlPartitionScanner() {
        this.fLimitPartitionLength = true;
    }

    public VhdlPartitionScanner(boolean limitPartitionLength) {
        this.fLimitPartitionLength = limitPartitionLength;
    }

    public IToken nextToken() {
        if (this.fTokenOffset >= 0) {
            this.fTokenOffset += this.fTokenLength;
            this.fTokenLength = this.fPrefixLength;
            this.fPrefixLength = 0;
        } else {
            this.fTokenOffset += this.fTokenLength + this.fPrefixLength;
            this.fTokenLength = 0;
            this.fPrefixLength = 0;
        }
        int nested = 0;
        while ((this.fChar = this.read()) != -1) {
            ++this.fTokenLength;
            switch (this.fState) {
                case CODE: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 > 0) {
                            this.fBackslash = false;
                            --this.fTokenLength;
                            this.fPrefixLength = 1;
                            return new Token((Object)"__dftl_partition_content_type");
                        }
                    } else if (this.fChar == 45) {
                        this.fState = STATE.CODE_MINUS;
                    } else if (this.fChar == 47) {
                        this.fState = STATE.CODE_SLASH;
                    } else if (!this.fBackslash) {
                        if (this.fChar == 34) {
                            this.fState = STATE.LITERAL;
                            if (this.fTokenLength - 1 > 0) {
                                --this.fTokenLength;
                                this.fPrefixLength = 1;
                                return new Token((Object)"__dftl_partition_content_type");
                            }
                        } else if (this.fChar == 39) {
                            int la1 = this.read();
                            if (la1 != 40 || !Character.isJavaIdentifierPart(this.fPrevNonWhiteChar)) {
                                int la2 = this.read();
                                if (la2 == 39) {
                                    this.fState = STATE.LITERAL_CHAR;
                                    if (this.fTokenLength - 1 > 0) {
                                        this.unread();
                                        this.unread();
                                        --this.fTokenLength;
                                        this.fPrefixLength = 1;
                                        return new Token((Object)"__dftl_partition_content_type");
                                    }
                                }
                                this.unread();
                            }
                            this.unread();
                        }
                    }
                    if (this.fState != STATE.CODE || Character.isWhitespace(this.fChar)) break;
                    this.fPrevNonWhiteChar = this.fChar;
                    break;
                }
                case CODE_SLASH: {
                    if (this.fChar == 42) {
                        this.fState = STATE.ML_COMMENT;
                        if (this.fTokenLength - 2 <= 0) break;
                        this.fTokenLength -= 2;
                        this.fPrefixLength = 2;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 47) {
                        this.fState = STATE.CODE_SLASH;
                        break;
                    }
                    if (this.fChar == 45) {
                        this.fState = STATE.CODE_MINUS;
                        break;
                    }
                    this.fState = STATE.CODE;
                    break;
                }
                case CODE_MINUS: {
                    if (this.fChar == 45) {
                        this.fState = STATE.SL_COMMENT_OR_PSL;
                        if (this.fTokenLength - 2 <= 0) break;
                        this.fTokenLength -= 2;
                        this.fPrefixLength = 2;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    this.fState = STATE.CODE;
                    break;
                }
                case LITERAL: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 <= 0) break;
                        --this.fTokenLength;
                        this.fPrefixLength = 1;
                        return new Token((Object)"__vhdl_literal");
                    }
                    if (this.fBackslash) break;
                    if (this.fChar == 13 || !this.fIgnoreNextNL && this.fChar == 10) {
                        this.fState = STATE.CODE;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vhdl_literal");
                    }
                    if (this.fChar != 34) break;
                    this.fState = STATE.CODE;
                    if (this.fTokenLength <= 0) break;
                    return new Token((Object)"__vhdl_literal");
                }
                case LITERAL_CHAR: {
                    if (this.fChar == 13 || this.fChar == 10) {
                        this.fState = STATE.CODE;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vhdl_literal");
                    }
                    if (this.fChar != 39) break;
                    this.fState = STATE.CODE;
                    if (this.fTokenLength <= 0) break;
                    return new Token((Object)"__vhdl_literal");
                }
                case ML_COMMENT: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 <= 0) break;
                        --this.fTokenLength;
                        this.fPrefixLength = 1;
                        return new Token((Object)"__vhdl_ml_comment");
                    }
                    if (this.fChar != 42) break;
                    this.fState = STATE.ML_COMMENT_STAR;
                    break;
                }
                case ML_COMMENT_STAR: {
                    if (this.fChar == 42) break;
                    if (this.fChar == 47) {
                        this.fState = STATE.CODE;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vhdl_ml_comment");
                    }
                    this.fState = STATE.ML_COMMENT;
                    break;
                }
                case SL_COMMENT: {
                    if (this.fChar != 13 && this.fChar != 10) break;
                    if (this.fChar == 13) {
                        if (this.read() == 10) {
                            ++this.fTokenLength;
                        } else {
                            this.unread();
                        }
                    }
                    this.fState = STATE.CODE;
                    if (this.fTokenLength <= 0) break;
                    return new Token((Object)"__vhdl_sl_comment");
                }
                case SL_COMMENT_OR_PSL: {
                    if (this.fChar == 13 || this.fChar == 10) {
                        this.unread();
                        --this.fTokenLength;
                        this.fState = STATE.SL_COMMENT;
                        break;
                    }
                    if (this.fChar == 112) {
                        int ch = this.read();
                        ++this.fTokenLength;
                        if (ch == 115) {
                            ch = this.read();
                            ++this.fTokenLength;
                            if (ch == 108) {
                                ch = this.read();
                                ++this.fTokenLength;
                                if (Character.isWhitespace(ch)) {
                                    nested = 0;
                                    this.fState = STATE.SL_COMMENT_PSL;
                                    break;
                                }
                                this.unread();
                                --this.fTokenLength;
                                this.fState = STATE.SL_COMMENT;
                                break;
                            }
                            this.unread();
                            --this.fTokenLength;
                            this.fState = STATE.SL_COMMENT;
                            break;
                        }
                        this.unread();
                        --this.fTokenLength;
                        this.fState = STATE.SL_COMMENT;
                        break;
                    }
                    if (Character.isWhitespace(this.fChar)) break;
                    this.fState = STATE.SL_COMMENT;
                    break;
                }
                case SL_COMMENT_PSL: {
                    if (this.fChar == 40 || this.fChar == 91 || this.fChar == 123) {
                        ++nested;
                        break;
                    }
                    if (this.fChar == 41 || this.fChar == 93 || this.fChar == 125) {
                        --nested;
                        break;
                    }
                    if ((this.fChar == 13 || this.fChar == 10) && nested == 0) {
                        this.fState = STATE.CODE;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vhdl_psl_code");
                    }
                    if (this.fTokenLength + this.fTokenOffset >= this.fRangeEnd) {
                        this.fState = STATE.CODE;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vhdl_psl_code");
                    }
                    if (this.fBackslash || this.fChar != 34) break;
                    this.fState = STATE.LITERAL_PSL;
                    break;
                }
                case LITERAL_PSL: {
                    if (this.fBackslash) break;
                    if (this.fChar == 13 || !this.fIgnoreNextNL && this.fChar == 10) {
                        this.fState = STATE.SL_COMMENT_PSL;
                        break;
                    }
                    if (this.fChar != 34) break;
                    this.fState = STATE.SL_COMMENT_PSL;
                }
            }
            this.fBackslash = !this.fBackslash && this.fChar == 92;
            boolean bl = this.fIgnoreNextNL = this.fChar == 13;
        }
        if (this.fTokenLength > 0) {
            switch (this.fState) {
                case CODE: 
                case CODE_MINUS: 
                case CODE_SLASH: {
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case SL_COMMENT_PSL: {
                    return new Token((Object)"__vhdl_psl_code");
                }
                case LITERAL: {
                    return new Token((Object)"__vhdl_literal");
                }
                case ML_COMMENT: 
                case ML_COMMENT_STAR: {
                    return new Token((Object)"__vhdl_ml_comment");
                }
            }
            return new Token((Object)"__vhdl_sl_comment");
        }
        return Token.EOF;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        if (contentType != null && contentType.equals("__vhdl_psl_code")) {
            try {
                ITypedRegion partition = ((IDocumentExtension3)this.fDocument).getPartition("__vhdl_partitioning", offset, true);
                super.setRange(document, partition.getOffset(), partition.getLength());
                this.fTokenOffset = partitionOffset;
                this.fTokenLength = 0;
                this.fPrefixLength = 0;
                this.fState = STATE.CODE;
            }
            catch (Exception exception) {
                this.setPartialRange(document, offset, length, "__dftl_partition_content_type", partitionOffset);
            }
        } else {
            super.setRange(document, offset, length);
            this.fTokenOffset = partitionOffset;
            this.fTokenLength = 0;
            this.fPrefixLength = offset - partitionOffset;
            this.fState = contentType == null ? STATE.CODE : (contentType.equals("__dftl_partition_content_type") ? STATE.CODE : (contentType.equals("__vhdl_literal") ? STATE.LITERAL : (contentType.equals("__vhdl_sl_comment") ? STATE.SL_COMMENT : STATE.ML_COMMENT)));
        }
    }

    public int read() {
        return super.read();
    }

    public void unread() {
        super.unread();
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fPrefixLength = 0;
        this.fTokenLength = 0;
        this.fState = STATE.CODE;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }

    public static enum STATE {
        ML_COMMENT,
        SL_COMMENT,
        LITERAL,
        LITERAL_CHAR,
        CODE,
        CODE_MINUS,
        ML_COMMENT_STAR,
        CODE_SLASH,
        SL_COMMENT_PSL,
        SL_COMMENT_OR_PSL,
        LITERAL_PSL;

    }
}

