/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.editor.rules.PslLiteralRule;
import ro.amiq.vhdldt.ui.editor.rules.PslMlCommentRule;
import ro.amiq.vhdldt.ui.editor.rules.PslSlCommentRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlAttributesRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlFoldingZoneMarker;
import ro.amiq.vhdldt.ui.editor.rules.VhdlKeyWordRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlNumericRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlPreprocessRule;
import ro.amiq.vhdldt.ui.editor.rules.VhdlWhitespaceDetector;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlPslCodeScanner
extends VhdlCodeScanner {
    public VhdlPslCodeScanner(VhdlStyle style, int nofLinesFolding) {
        super(style, nofLinesFolding);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new VhdlWhitespaceDetector()));
        rules.add(new PslSlCommentRule(style.getToken("highlight.comment")));
        rules.add(new PslMlCommentRule(style.getToken("highlight.comment")));
        rules.add(new PslLiteralRule(style.getToken("highlight.string")));
        rules.add(new VhdlAttributesRule(PrefConst.getVHDLLowercaseAttributes(), style.getToken("highlight.attributes")));
        rules.add(new VhdlKeyWordRule(PrefConst.getVHDLLowercaseKeywords(), PrefConst.getVHDLLowercaseTypes(), style, nofLinesFolding));
        rules.add(new VhdlPreprocessRule(style.getToken("highlight.preproc")));
        rules.add(new VhdlFoldingZoneMarker(nofLinesFolding));
        rules.add(new VhdlNumericRule(style.getToken("highlight.number")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

