/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.ui.actions.MacroTraceHoverSingleClickListener;
import ro.amiq.dvt.ui.editor.DVTMultipleHyperlinkPresenter;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.ExternalToolsAnnotationClickListener;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.ui.editor.hover.AnnotationExpandHover;
import ro.amiq.dvt.ui.editor.hover.DVTDefaultAnnotationHover;
import ro.amiq.dvt.ui.editor.hover.ISingleClickListener;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.spelling.WordQuickFixProcessor;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.debug.ui.editor.hover.VhdlDebugTextHoverParticipant;
import ro.amiq.vhdldt.ui.editor.VhdlDoubleClickStrategy;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlNonRuleBasedDamagerRepairer;
import ro.amiq.vhdldt.ui.editor.VhdlReconcilingStrategy;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfigurationCommon;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlAutoInstanceContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlKeywordContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlTemplateContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.edit.strategy.VhdlCodeAutoEditStrategy;
import ro.amiq.vhdldt.ui.editor.edit.strategy.VhdlCommentAutoEditStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCodeFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlContentFormatter;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlFormattingPreferences;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlLiteralFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlMLCommentFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlSLCommentFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.hover.VhdlTextHover;
import ro.amiq.vhdldt.ui.editor.hover.VhdlTextHoverParticipant;
import ro.amiq.vhdldt.ui.editor.hyperlink.CommentHyperlinkDetector;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.vhdldt.ui.editor.quickfix.VhdlEditorQuickFixProcessor;

public class VhdlSourceViewerConfiguration
extends VhdlSourceViewerConfigurationCommon {
    protected ITextDoubleClickStrategy fDoubleClickStrategy;
    protected ITextHover fTextHover;
    protected AnnotationExpandHover fAnnotationHover;
    protected VhdlReconcilingStrategy fReconcilingStrategy;
    protected VhdlCodeAutoEditStrategy fCodeAutoEditStrategy = null;
    protected IDialogSettings fDialogSettings;

    public VhdlSourceViewerConfiguration(VhdlEditor editor) {
        super(editor);
    }

    public VhdlSourceViewerConfiguration() {
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        this.fReconcilingStrategy = new VhdlReconcilingStrategy(sourceViewer, EditorsUI.getSpellingService());
        IDocument document = sourceViewer.getDocument();
        this.fReconcilingStrategy.setDocument(document);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)this.fReconcilingStrategy, false);
        reconciler.setDelay(500);
        this.setReconciler(reconciler);
        return reconciler;
    }

    public static void updatePresentationReconciler(IPresentationReconciler reconciler) {
        IToken token = VhdlStyle.getInstance().getToken("highlight.string");
        ((VhdlNonRuleBasedDamagerRepairer)((DVTPresentationReconciler)reconciler).getDamager("__vhdl_literal")).setToken(token);
        ((VhdlNonRuleBasedDamagerRepairer)((DVTPresentationReconciler)reconciler).getRepairer("__vhdl_literal")).setToken(token);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fAnnotationHover == null) {
            this.fAnnotationHover = new AnnotationExpandHover(new CompositeRuler(), (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), null, (ISingleClickListener)new MacroTraceHoverSingleClickListener());
            ExternalToolsAnnotationClickListener externalToolsListener = new ExternalToolsAnnotationClickListener();
            this.fAnnotationHover.addCustomClickListener(DVTProblemCategories.EXTERNALTOOLS.getMarkerId(), (ISingleClickListener)externalToolsListener);
        }
        return this.fAnnotationHover;
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new DVTDefaultAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor == null) {
            return null;
        }
        if (this.fTextHover == null) {
            this.fTextHover = new VhdlTextHover((ITextEditor)this.fEditor);
            ((VhdlTextHover)this.fTextHover).addTextHoverParticipant(new VhdlTextHoverParticipant());
            ((VhdlTextHover)this.fTextHover).addTextHoverParticipant(new VhdlDebugTextHoverParticipant());
        }
        return this.fTextHover;
    }

    protected void setProjectionAnnotationModel(ProjectionAnnotationModel model) {
        this.fPresentationReconciler.setProjectionAnnotationModel(model);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return this.fConfiguredContentType;
    }

    public VhdlEditor getEditor() {
        return this.fEditor;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        IInformationPresenter presenter = super.getInformationPresenter(sourceViewer);
        ITextHover textHover = this.getTextHover(sourceViewer, null);
        InformationProvider provider = new InformationProvider(textHover);
        ((InformationPresenter)presenter).setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        ((InformationPresenter)presenter).setInformationProvider((IInformationProvider)provider, "__vhdl_psl_code");
        Point location = sourceViewer.getTextWidget().getSelectionRange();
        ((InformationPresenter)presenter).setMargins(location.x, location.y);
        return presenter;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new VhdlDoubleClickStrategy(this.fBracketMatcher);
        }
        return this.fDoubleClickStrategy;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor == null) {
            return null;
        }
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        final WordQuickFixProcessor spellingQuickFix = new WordQuickFixProcessor((ITextEditor)this.fEditor);
        IQuickAssistProcessor processor = new IQuickAssistProcessor(){

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return false;
            }

            public boolean canFix(Annotation annotation) {
                if (annotation == null) {
                    return false;
                }
                String annotationType = annotation.getType();
                boolean spellingAssist = "org.eclipse.ui.workbench.texteditor.spelling".equals(annotationType);
                if (spellingAssist) {
                    return true;
                }
                if (annotation instanceof MarkerAnnotation) {
                    int quickFixKind;
                    block9: {
                        IMarker marker;
                        block8: {
                            marker = ((MarkerAnnotation)annotation).getMarker();
                            try {
                                if ("ro.amiq.vhdldt.SemanticProblemMarker".equals(marker.getType())) break block8;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        String elementName = marker.getAttribute("QUICKFIX_ELEMENT_NAME", "");
                        int scopeOffset = marker.getAttribute("charStart", -1);
                        quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
                        if (elementName != null && scopeOffset != -1 && quickFixKind != -1) break block9;
                        return false;
                    }
                    if (QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind)) {
                        return true;
                    }
                }
                return false;
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                ICompletionProposal[] result = new VhdlEditorQuickFixProcessor((ITextEditor)VhdlSourceViewerConfiguration.this.fEditor).computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                result = spellingQuickFix.computeCompletionProposals((ITextViewer)invocationContext.getSourceViewer(), invocationContext.getOffset());
                if (result != null && result.length > 0) {
                    return result;
                }
                return new ICompletionProposal[]{DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE};
            }

            public String getErrorMessage() {
                return null;
            }
        };
        assistant.setQuickAssistProcessor(processor);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant != null) {
            return this.fContentAssistant;
        }
        if (this.fEditor == null) {
            return null;
        }
        this.fContentAssistant = new ContentAssistant();
        this.fContentAssistant.enableColoredLabels(true);
        this.fContentAssistant.setRepeatedInvocationMode(true);
        this.fContentAssistant.setStatusLineVisible(true);
        this.fContentAssistant.setStatusMessage("Press 'Ctrl+Space' to show Template proposals");
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fSourceProcessorManager = new VhdlContentAssistProcessorManager(this.fEditor, this.fContentAssistant);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fSourceProcessorManager);
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor != null) {
            this.fSourceProcessorManager.addContentAssistProcessor((IContentAssistProcessor)aiHostContributor.getCodeCompletionProcessorAndListener());
            this.fContentAssistant.addCompletionListener((ICompletionListener)aiHostContributor.getCodeCompletionProcessorAndListener());
        }
        this.fSourceProcessorManager.addContentAssistProcessor(new RfContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor(new VhdlAutoInstanceContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor(new VhdlKeywordContentAssistProcessor(this.fSourceProcessorManager));
        this.fSourceProcessorManager.addContentAssistProcessor((IContentAssistProcessor)new VhdlTemplateContentAssistProcessor(this.fEditor, this.fSourceProcessorManager));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__dftl_partition_content_type");
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__vhdl_psl_code");
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.fDialogSettings = new DialogSettings("dvt.contentAssist");
        this.fContentAssistant.setRestoreCompletionProposalSize(this.fDialogSettings);
        return this.fContentAssistant;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 2];
        detectors[0] = new RfHyperlinkDetector((ITextEditor)this.fEditor);
        detectors[1] = new CommentHyperlinkDetector(this.fEditor);
        if (inheritedDetectors != null) {
            int i = 0;
            while (i < inheritedDetectorsLength) {
                detectors[i + 2] = inheritedDetectors[i];
                ++i;
            }
        }
        return detectors;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] result = new IAutoEditStrategy[1];
        if (this.fCodeAutoEditStrategy == null) {
            this.fCodeAutoEditStrategy = new VhdlCodeAutoEditStrategy(sourceViewer, this);
        }
        result[0] = "__dftl_partition_content_type".equals(contentType) ? this.fCodeAutoEditStrategy : ("__vhdl_literal".equals(contentType) ? this.fCodeAutoEditStrategy : ("__vhdl_ml_comment".equals(contentType) ? new VhdlCommentAutoEditStrategy(this.fEditor) : new DefaultIndentLineAutoEditStrategy()));
        return result;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"--", ""};
    }

    public IInformationPresenter getQuickViewerPresenter(ISourceViewer sourceViewer, IInformationControlCreator controlCreator) {
        QuickViewInfoProvider provider = new QuickViewInfoProvider();
        InformationPresenter presenter = new InformationPresenter(controlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__vhdl_psl_code");
        presenter.setInformationProvider((IInformationProvider)provider, "__vhdl_literal");
        presenter.setInformationProvider((IInformationProvider)provider, "__vhdl_sl_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__vhdl_ml_comment");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return new DVTMultipleHyperlinkPresenter(new RGB(0, 0, 255));
        }
        return new DVTMultipleHyperlinkPresenter(this.fPreferenceStore);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
        }
        this.fFormatter = new VhdlContentFormatter(this);
        this.fFormatter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        VhdlFormattingPreferences formatPreferences = VhdlFormattingPreferences.getInstance();
        this.fCodeStrategy = new VhdlCodeFormattingStrategy(this, formatPreferences);
        this.fSLCommentStrategy = new VhdlSLCommentFormattingStrategy(this, formatPreferences);
        this.fMLCommentStrategy = new VhdlMLCommentFormattingStrategy(this, formatPreferences);
        this.fLiteralStrategy = new VhdlLiteralFormattingStrategy(this, formatPreferences);
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fCodeStrategy, "__dftl_partition_content_type");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__vhdl_psl_code");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__vhdl_sl_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__vhdl_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fLiteralStrategy, "__vhdl_literal");
        return this.fFormatter;
    }

    public void dispose() {
        super.dispose();
        if (this.fReconcilingStrategy != null) {
            this.fReconcilingStrategy.setDocument(null);
            this.fReconcilingStrategy = null;
        }
        if (this.fPrefListener != null) {
            VhdlPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPrefListener);
        }
        this.fPrefListener = null;
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.setDamager(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer(null, "__dftl_partition_content_type");
            this.fPresentationReconciler.setDamager(null, "__vhdl_psl_code");
            this.fPresentationReconciler.setRepairer(null, "__vhdl_psl_code");
            this.fPresentationReconciler.setDamager(null, "__vhdl_sl_comment");
            this.fPresentationReconciler.setRepairer(null, "__vhdl_sl_comment");
            this.fPresentationReconciler.setDamager(null, "__vhdl_ml_comment");
            this.fPresentationReconciler.setRepairer(null, "__vhdl_ml_comment");
            this.fPresentationReconciler.setDamager(null, "__vhdl_literal");
            this.fPresentationReconciler.setRepairer(null, "__vhdl_literal");
            this.fPresentationReconciler = null;
        }
        if (this.fCodeScanner != null) {
            this.fCodeScanner.dispose();
            this.fCodeScanner = null;
        }
        if (this.fPslCodeScanner != null) {
            this.fPslCodeScanner.dispose();
            this.fPslCodeScanner = null;
        }
        if (this.fCommentScanner != null) {
            this.fCommentScanner.dispose();
            this.fCommentScanner = null;
        }
        this.fTextHover = null;
        if (this.fLiteralStrategy != null) {
            this.fLiteralStrategy.dispose();
            this.fLiteralStrategy = null;
        }
        if (this.fCodeStrategy != null) {
            this.fCodeStrategy.dispose();
            this.fCodeStrategy = null;
        }
        if (this.fSLCommentStrategy != null) {
            this.fSLCommentStrategy.dispose();
            this.fSLCommentStrategy = null;
        }
        this.fCodeAutoEditStrategy = null;
        this.fEditor = null;
        if (this.fContentAssistant != null) {
            if (this.fSourceProcessorManager != null) {
                this.fContentAssistant.removeCompletionListener((ICompletionListener)this.fSourceProcessorManager);
                this.fSourceProcessorManager = null;
            }
            this.fContentAssistant = null;
        }
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
            this.fFormatter = null;
        }
    }

    @Override
    protected VhdlLiteralFormattingStrategy getVhdlLiteralFormattingStrategy(VhdlFormattingPreferences formatPreferences) {
        return new VhdlLiteralFormattingStrategy(this, formatPreferences);
    }

    @Override
    protected VhdlMLCommentFormattingStrategy getVhdlMLCommentFormattingStrategy(VhdlFormattingPreferences formatPreferences) {
        return new VhdlMLCommentFormattingStrategy(this, formatPreferences);
    }

    @Override
    protected VhdlSLCommentFormattingStrategy getVhdlSLCommentFormattingStrategy(VhdlFormattingPreferences formatPreferences) {
        return new VhdlSLCommentFormattingStrategy(this, formatPreferences);
    }

    @Override
    protected VhdlCodeFormattingStrategy getVhdlCodeFormattingStrategy(VhdlFormattingPreferences formatPreferences) {
        return new VhdlCodeFormattingStrategy(this, formatPreferences);
    }

    private static final class InformationProvider
    implements IInformationProviderExtension,
    IInformationProviderExtension2,
    IInformationProvider {
        private final ITextHover textHover;

        private InformationProvider(ITextHover textHover) {
            this.textHover = textHover;
        }

        public IRegion getSubject(ITextViewer textViewer, final int offset) {
            return new IRegion(){

                public int getOffset() {
                    return offset;
                }

                public int getLength() {
                    return 1;
                }
            };
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.textHover.getHoverInfo(textViewer, subject);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion hoverRegion) {
            return this.textHover instanceof VhdlTextHover ? ((VhdlTextHover)this.textHover).getHoverInfo2(textViewer, hoverRegion) : this.textHover.getHoverInfo(textViewer, hoverRegion);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.textHover instanceof VhdlTextHover ? ((VhdlTextHover)this.textHover).getHoverControlCreator() : null;
        }
    }

    static class QuickViewInfoProvider
    implements IInformationProvider,
    IInformationProviderExtension {
        private Object fData;

        QuickViewInfoProvider() {
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return null;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(0, 1);
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fData;
        }

        public void setDataToShow(Object data) {
            this.fData = data;
        }
    }
}

