/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlCommentScanner;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlNonRuleBasedDamagerRepairer;
import ro.amiq.vhdldt.ui.editor.VhdlPartitionScanner;
import ro.amiq.vhdldt.ui.editor.VhdlPslCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlReconciler;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCodeFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlContentFormatter;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlFormattingPreferences;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlLiteralFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlMLCommentFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlSLCommentFormattingStrategy;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public abstract class VhdlSourceViewerConfigurationCommon
extends DVTSourceViewerConfiguration {
    protected VhdlCodeScanner fCodeScanner;
    protected VhdlPslCodeScanner fPslCodeScanner;
    protected VhdlCommentScanner fCommentScanner;
    protected VhdlEditor fEditor;
    protected IPropertyChangeListener fPrefListener;
    protected String[] fConfiguredContentType = new String[]{"__dftl_partition_content_type", "__vhdl_psl_code", "__vhdl_literal", "__vhdl_sl_comment", "__vhdl_ml_comment"};
    protected DVTPresentationReconciler fPresentationReconciler;
    protected VhdlCodeFormattingStrategy fCodeStrategy;
    protected VhdlSLCommentFormattingStrategy fSLCommentStrategy;
    protected VhdlMLCommentFormattingStrategy fMLCommentStrategy;
    protected VhdlLiteralFormattingStrategy fLiteralStrategy;
    protected VhdlContentAssistProcessorManager fSourceProcessorManager;
    protected ContentAssistant fContentAssistant;
    protected DVTContentFormatter fFormatter;

    protected VhdlSourceViewerConfigurationCommon(VhdlEditor editor) {
        super(VhdlPlugin.getDefault().getCombinedPreferenceStore());
        this.fEditor = editor;
    }

    protected VhdlSourceViewerConfigurationCommon() {
        super(VhdlPlugin.getDefault().getCombinedPreferenceStore());
    }

    public IContentFormatter getContentFormatter() {
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
        }
        this.fFormatter = new VhdlContentFormatter(this);
        this.fFormatter.setDocumentPartitioning("__vhdl_partitioning");
        VhdlFormattingPreferences formatPreferences = VhdlFormattingPreferences.getInstance();
        this.fCodeStrategy = this.getVhdlCodeFormattingStrategy(formatPreferences);
        this.fSLCommentStrategy = this.getVhdlSLCommentFormattingStrategy(formatPreferences);
        this.fMLCommentStrategy = this.getVhdlMLCommentFormattingStrategy(formatPreferences);
        this.fLiteralStrategy = this.getVhdlLiteralFormattingStrategy(formatPreferences);
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fCodeStrategy, "__dftl_partition_content_type");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__vhdl_psl_code");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__vhdl_sl_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__vhdl_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fLiteralStrategy, "__vhdl_literal");
        return this.fFormatter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fPresentationReconciler == null) {
            int foldingEnabled;
            this.fPresentationReconciler = new DVTPresentationReconciler();
            this.fPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            int nofLines = PrefConst.getCodeFoldingNofLines();
            boolean enable = PrefConst.isCodeFoldingEnabled();
            boolean manualEnable = PrefConst.isManualCodeFoldingEnabled();
            int n = foldingEnabled = !enable ? 0 : nofLines;
            int manualFoldingEnabled = !manualEnable ? 0 : (!enable ? 0 : nofLines);
            this.fPresentationReconciler.setNofLinesFolding(foldingEnabled);
            VhdlReconciler dr1 = new VhdlReconciler((ITokenScanner)this.getVhdlCodeScanner(foldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
            VhdlReconciler dr2 = new VhdlReconciler((ITokenScanner)this.getVhdlCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr2, "__vhdl_sl_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr2, "__vhdl_sl_comment");
            VhdlReconciler dr3 = new VhdlReconciler((ITokenScanner)this.getVhdlCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__vhdl_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__vhdl_ml_comment");
            VhdlReconciler dr4 = new VhdlReconciler((ITokenScanner)this.getVhdlPslCodeScanner(foldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr4, "__vhdl_psl_code");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr4, "__vhdl_psl_code");
            IToken token1 = VhdlStyle.getInstance().getToken("highlight.string");
            VhdlNonRuleBasedDamagerRepairer ndr = new VhdlNonRuleBasedDamagerRepairer(token1);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr, "__vhdl_literal");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr, "__vhdl_literal");
            this.fPrefListener = Utils.setUpFoldingPreferencesListener((IPreferenceStore)VhdlPlugin.getDefault().getPreferenceStore(), (String)"editor.codeFolding", (String)"editor.manualCodeFolding", (String)"editor.numberOfLines", (DVTPresentationReconciler)this.fPresentationReconciler, (DVTBaseScanner)this.fCodeScanner, (DVTBaseScanner)this.fCommentScanner, null);
        }
        return this.fPresentationReconciler;
    }

    public void refreshLineDelimiter() {
        this.fLineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor);
    }

    public void setConfiguredContentTypes(String[] configuredContentType) {
        this.fConfiguredContentType = configuredContentType;
    }

    protected VhdlCodeScanner getVhdlCodeScanner(int nofLinesFolding) {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new VhdlCodeScanner(VhdlStyle.getInstance(), nofLinesFolding);
            this.fCodeScanner.setDefaultReturnToken(VhdlStyle.getInstance().getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected VhdlPslCodeScanner getVhdlPslCodeScanner(int nofLinesFolding) {
        if (this.fPslCodeScanner == null) {
            this.fPslCodeScanner = new VhdlPslCodeScanner(VhdlStyle.getInstance(), nofLinesFolding);
            this.fPslCodeScanner.setDefaultReturnToken(VhdlStyle.getInstance().getToken("highlight.default"));
        }
        return this.fPslCodeScanner;
    }

    protected VhdlCommentScanner getVhdlCommentScanner(int nofLinesFolding) {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new VhdlCommentScanner(VhdlStyle.getInstance(), true, nofLinesFolding, this.isInspectView(), this.fEditor != null ? this.fEditor.getProject() : null);
            this.fCommentScanner.setDefaultReturnToken(VhdlStyle.getInstance().getToken("highlight.comment"));
        }
        return this.fCommentScanner;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__vhdl_partitioning";
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        VhdlStyle.getInstance().adaptToPreferenceChange(event);
    }

    public DVTBaseCodeFormattingStrategy getCodeFormattingStrategy() {
        return this.fCodeStrategy;
    }

    public DVTBaseFormattingStrategy getSLCommentFormattingStrategy() {
        return this.fSLCommentStrategy;
    }

    public void setupDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VhdlPartitionScanner(), new String[]{"__vhdl_sl_comment", "__vhdl_ml_comment", "__vhdl_literal", "__vhdl_psl_code", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__vhdl_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void connectCFDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VhdlPartitionScanner(false), new String[]{"__vhdl_sl_comment", "__vhdl_ml_comment", "__vhdl_literal", "__vhdl_psl_code", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__cf_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void disconnectCFDocumentPartitioner(IDocument document) {
        IDocumentExtension3 extension;
        IDocumentPartitioner partitioner;
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3 && (partitioner = (extension = (IDocumentExtension3)document).getDocumentPartitioner("__cf_partitioning")) != null) {
            partitioner.disconnect();
        }
    }

    public DVTContentAssistProcessorManager getSourceProcessorManager() {
        return this.fSourceProcessorManager;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VHDL;
    }

    protected abstract VhdlLiteralFormattingStrategy getVhdlLiteralFormattingStrategy(VhdlFormattingPreferences var1);

    protected abstract VhdlMLCommentFormattingStrategy getVhdlMLCommentFormattingStrategy(VhdlFormattingPreferences var1);

    protected abstract VhdlSLCommentFormattingStrategy getVhdlSLCommentFormattingStrategy(VhdlFormattingPreferences var1);

    protected abstract VhdlCodeFormattingStrategy getVhdlCodeFormattingStrategy(VhdlFormattingPreferences var1);
}

