/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;

public class VhdlStyle {
    private static HashMap<String, Token> fTokenMap = new HashMap();
    private static Boolean fSemanticHighlight = null;
    private static volatile VhdlStyle fInstance;
    private HighlightPreferenceListener fPreferenceListener = new HighlightPreferenceListener();
    private IPreferenceStore fStore = VhdlPlugin.getDefault().getPreferenceStore();
    private static Boolean fXTemplateIdentifierHighlight;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlStyle getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VhdlStyle();
            }
        }
        return fInstance;
    }

    public VhdlStyle() {
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fPreferenceListener = null;
    }

    public boolean isSemanticHighlightEnabled() {
        if (fSemanticHighlight != null) {
            return fSemanticHighlight;
        }
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        fSemanticHighlight = store.getBoolean("highlight.semantic.value");
        return fSemanticHighlight;
    }

    public boolean isXTemplateIdentifierHighlightEnabled() {
        if (fXTemplateIdentifierHighlight != null) {
            return fXTemplateIdentifierHighlight;
        }
        fXTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.x_template_id.value");
        return fXTemplateIdentifierHighlight;
    }

    public void updateTokens() {
        Iterator<Map.Entry<String, Token>> it = fTokenMap.entrySet().iterator();
        while (it.hasNext()) {
            IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
            Map.Entry<String, Token> pair = it.next();
            String key = pair.getKey();
            pair.getValue().setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        }
    }

    public IToken getToken(String key) {
        Token res = fTokenMap.get(key);
        if (res != null) {
            return res;
        }
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        res = new Token((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        fTokenMap.put(key, res);
        return res;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        String pp = p.replaceFirst(".((color)|(bold)|(italic))", "");
        if (p.endsWith(".color")) {
            this.adaptColorChange(fTokenMap.get(pp), event);
        } else if (p.endsWith(".bold")) {
            this.adaptToStyleChange(fTokenMap.get(pp), event, 1);
        } else if (p.endsWith(".italic")) {
            this.adaptToStyleChange(fTokenMap.get(pp), event, 2);
        } else if (p.endsWith(".semantic.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            fSemanticHighlight = eventValue;
        } else if (p.endsWith(".x_template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            fXTemplateIdentifierHighlight = eventValue;
        }
    }

    private void adaptColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        if (token == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute oldAttr = (TextAttribute)data;
            token.setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private class HighlightPreferenceListener
    implements IPropertyChangeListener {
        private HighlightPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                return;
            }
            VhdlStyle.this.adaptToPreferenceChange(event);
        }
    }
}

