/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfGUIReferencesUtils;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspaceAction;

public class ShowReadersUsagesAction
extends ReferencesInWorkspaceAction
implements IReferencesAction {
    public ShowReadersUsagesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setText("Readers");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a variable or port to use Show Readers.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    @Override
    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowReadersUsages(project, textEditor, document, offset);
    }

    private ISearchQuery findNamedElementAndShowReadersUsages(IProject project, ITextEditor textEditor, IDocument document, int offset) {
        IRfNamedElement namedElement = null;
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(textEditor, document, offset);
        if (namedElementAndScope != null) {
            namedElement = namedElementAndScope.getIRfNamedElement();
        }
        if (namedElement == null) {
            this.informationDialog();
            return null;
        }
        if (!RfReferencesUtils.canBeReadOrWritten((IRfNamedElement)namedElement)) {
            this.informationDialog();
            return null;
        }
        IRfScopeElement scope = null;
        if (namedElementAndScope != null) {
            scope = namedElementAndScope.getScope();
        }
        return VHDLRfGUIReferencesUtils.showReadersUsages(namedElement, project, textEditor, offset, scope);
    }

    @Override
    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset, boolean includeDeclarations) {
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return null;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return null;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return this.findNamedElementAndShowReadersUsages(project, textEditor, document, offset);
    }
}

