/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.ui.editor.actions.VhdlAbstractRefactorAddActionCommon;

public abstract class VhdlAbstractRefactorAddAction
extends VhdlAbstractRefactorAddActionCommon {
    protected VhdlAbstractRefactorAddAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    private void popUnsupportedElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The operation is unavailable on the current selection (the scope could not be determined). Please select another VHDL element name or the same element from another location.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    public void run() {
        try {
            this.initDefaultValues();
            this.computeInfo();
            this.wizardInput = this.getInfo();
            if (this.wizardInput != null) {
                this.showWizard();
            } else {
                this.popUnsupportedElement();
            }
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                this.popUnsupportedElement();
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected int getOffset(ITextEditor textEditor) {
        return ((DVTEditor)textEditor).getCursor();
    }

    @Override
    protected RfWNamedElementAndScope getElementAndScope(ITextEditor textEditor, RfProject rfProject, int offset, IFile file, IDocument document) {
        return RfUtils.getRfElement(file, document, offset);
    }
}

