/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfAssociatedType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;

public abstract class VhdlAbstractRefactorAddActionCommon
extends TextEditorAction {
    protected VhdlRefactorAddWizardInput wizardInput;
    protected String name;
    protected String type;
    protected String width;
    protected RfNamedElement entity;

    protected VhdlAbstractRefactorAddActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void computeInfo() throws CoreException, BadLocationException {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof DVTEditor)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IProject project = resouce.getProject();
        if (project == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = ((DVTEditor)textEditor).getDocument();
        if (document == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        int offset = this.getOffset(textEditor);
        RfWNamedElementAndScope elemAndScope = this.getElementAndScope(textEditor, rfProject, offset, file, document);
        if (elemAndScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfNamedElement elemAtOffset = elemAndScope.getNamedElement();
        IRfScope rfScope = elemAndScope.getScope();
        this.entity = rfScope instanceof RfDefElement ? ((RfDefElement)rfScope).getNamedElement() : (RfNamedElement)rfScope;
        while (this.entity != null && !(this.entity instanceof RfEntity)) {
            this.entity = this.entity.getEnclosingScope();
        }
        if (!(this.entity instanceof RfEntity)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if ((elemAtOffset instanceof RfPort || elemAtOffset instanceof RfVariable) && !elemAtOffset.equals(rfScope)) {
            this.type = ((RfAssociatedType)elemAtOffset).getAssociatedTypeName();
            this.name = ((RfAssociatedType)elemAtOffset).getName();
            this.width = ((RfAssociatedType)elemAtOffset).getRange();
        } else {
            String candidateName;
            IRegion wordRegion = VhdlWordFinder.getDefault().getWordAtOffset(document, offset);
            if (wordRegion != null && (candidateName = document.get(wordRegion.getOffset(), wordRegion.getLength()).trim()) != null && !candidateName.equals(this.entity.getName()) && !candidateName.trim().isEmpty()) {
                this.name = candidateName;
            }
        }
    }

    protected void clean() {
        this.name = null;
        this.type = null;
        this.width = null;
        this.entity = null;
    }

    protected abstract VhdlRefactorAddWizardInput getInfo();

    public abstract void showWizard();

    protected abstract void initDefaultValues();

    protected abstract int getOffset(ITextEditor var1);

    protected abstract RfWNamedElementAndScope getElementAndScope(ITextEditor var1, RfProject var2, int var3, IFile var4, IDocument var5);
}

