/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.actions;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameAcrossDesignHierarchyPreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.ui.editor.actions.VhdlRenameRefactorAction;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameADHRefactorInfo;
import ro.amiq.vhdldt.ui.refactor.rename.VhdlRenameAcrossDesignHierarchyDelegate;

public class VhdlRenameAcrossDesignHierarchyRefactorAction
extends VhdlRenameRefactorAction {
    public VhdlRenameAcrossDesignHierarchyRefactorAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, editor);
        this.setText("Rename Port Across the Design Hierarchy");
    }

    @Override
    protected DVTRenameDelegate getRefactorDelegate(DVTRenameRefactorInfo refactorInfo) {
        return new VhdlRenameAcrossDesignHierarchyDelegate(refactorInfo);
    }

    public DVTRenamePreferencesPage getPage(DVTRenameRefactorInfo refactorInfo) {
        return new DVTRenameAcrossDesignHierarchyPreferencesPage("Rename Refactoring Across Design Hierarchy Preferences Page", refactorInfo);
    }

    public PortSignalEnum getPortSignalEnum(DVTRenameRefactorInfo refactorInfo) {
        return RfSearchUtils.getPortOrSignalEnum((IRfNamedElement)refactorInfo.getElement(), (IProject)refactorInfo.getProject());
    }

    public void popNoPortOrSignalElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation((String)"The operation is not allowed on the current selection. Please select a port or a signal.");
    }

    public boolean hasPortConnections(DVTRenameRefactorInfo refactorInfo) {
        return RfSearchUtils.hasPortConnections((IRfNamedElement)refactorInfo.getElement(), (IProject)refactorInfo.getProject());
    }

    public boolean popUnconnectedPortSignalWarning(PortSignalEnum portSignalEnum) {
        if (TestHelper.isTestMode()) {
            return false;
        }
        return RfGUIReferencesUtils.continueRenameAcrossHierarchyOperation((String)"Signal not connected", (String)"The selected {0} is not connected outside this module.\nDo you want to proceed with a local rename?", (String)portSignalEnum.toString());
    }

    @Override
    protected DVTRenameRefactorInfo getRefactorinfo(ITextEditor textEditor, IDocument document, int offset) {
        RfWNamedElementAndScope namedElementAndScope;
        IProject project;
        block7: {
            block6: {
                IResource resouce;
                block5: {
                    try {
                        resouce = (IResource)textEditor.getAdapter(IResource.class);
                        if (resouce != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                project = resouce.getProject();
                if (project != null) break block6;
                return null;
            }
            namedElementAndScope = RfUtils.getRfElement(textEditor, document, offset);
            if (namedElementAndScope != null) break block7;
            return null;
        }
        return new VhdlRenameADHRefactorInfo(project, namedElementAndScope, textEditor);
    }

    public boolean isValidElementForRefactoringOperation(DVTRenameRefactorInfo refactorInfo) {
        PortSignalEnum portOrSignalEnum = this.getPortSignalEnum(refactorInfo);
        boolean isPortOrSignal = portOrSignalEnum.matches();
        if (!isPortOrSignal) {
            this.popNoPortOrSignalElement();
            return false;
        }
        boolean hasPortConnections = this.hasPortConnections(refactorInfo);
        boolean shouldContinue = true;
        if (!hasPortConnections) {
            shouldContinue = this.popUnconnectedPortSignalWarning(portOrSignalEnum);
        }
        return shouldContinue;
    }

    public boolean alreadyAnExistingRefactoringSessionInProgress(DVTRenameWizard wizard) {
        wizard.setWindowTitle("Rename Port Across the Design Hierarchy");
        return !RfGUIReferencesUtils.checkAndCancelActiveRADHSession();
    }

    public void testSetInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
        List testGetDesignInstances = RfGUIReferencesUtils.testGetDesignInstances((DVTEditor)dvtEditor, (DVTRenameRefactorInfo)this.getRefactoringInfo());
        if (testGetDesignInstances == null) {
            return;
        }
        refactorInfo.setRenameADHInfo(new RenameAcrossHierarchyInfo(testGetDesignInstances, refactorInfo.getNewName(), refactorInfo.getElement()));
    }

    public void setInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
        refactorInfo.setRenameADHInfo(new RenameAcrossHierarchyInfo(RfGUIReferencesUtils.getDesignInstances((DVTEditor)dvtEditor, (IRfScopeElement)refactorInfo.getScope(), (IRfNamedElement)refactorInfo.getElement()), refactorInfo.getNewName(), refactorInfo.getElement()));
    }
}

