/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;

public class CustomTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4,
ICompletionProposalExtension6 {
    public boolean firstLetterOfPrefixIsUppercase;

    public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        super(template, context, region, image);
    }

    public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            boolean usePrefixCapitalization;
            DVTFileModificationValidator.validateEdit((ITextViewer)viewer);
            DVTProjectionViewer viewer2 = (DVTProjectionViewer)viewer;
            int capitalizationKeyworks = VhdlPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.keywords");
            int capitalizationDataTypes = VhdlPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.data_types");
            boolean bl = usePrefixCapitalization = capitalizationKeyworks == 1 && capitalizationDataTypes == 1;
            if (usePrefixCapitalization) {
                if (this.firstLetterOfPrefixIsUppercase) {
                    VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 2);
                    VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 2);
                } else {
                    VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 3);
                    VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 3);
                }
            }
            String formattedPattern = TemplatesViewUtils.formatReplacementString(() -> new VhdlSourceViewerConfiguration(null), (Template)this.getTemplate(), (DVTEditor)viewer2.getEditor(), (int)offset);
            this.getTemplate().setPattern(formattedPattern);
            if (usePrefixCapitalization) {
                VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.keywords", 1);
                VhdlPlugin.getDefault().getPreferenceStore().setValue("format.capitalization.data_types", 1);
            }
            super.apply(viewer, trigger, stateMask, offset);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public StyledString getStyledDisplayString() {
        StyledString displayString = new StyledString(this.getTemplateName());
        String description = this.getTemplate().getDescription();
        if (description != null && !description.isEmpty()) {
            displayString.append(" - " + description, StyledString.QUALIFIER_STYLER);
        }
        return displayString;
    }

    public String getAdditionalProposalInfo() {
        String additionalProposalInfo = super.getAdditionalProposalInfo();
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return additionalProposalInfo.replace("\n", this.getNewLineReplacement());
        }
        if (additionalProposalInfo.trim().isEmpty()) {
            return "";
        }
        return this.getConvertedAdditionalInfo(additionalProposalInfo.replace("<", "&lt;").replace(">", "&gt;"));
    }

    public boolean isAutoInsertable() {
        return this.getTemplate().isAutoInsertable();
    }

    public String getTemplateName() {
        return this.getTemplate().getName();
    }

    private String getConvertedAdditionalInfo(String additionalProposalInfo) {
        return "<pre class=\"template\">" + additionalProposalInfo + "</pre>";
    }

    private String getNewLineReplacement() {
        return "<br>";
    }
}

