/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyAutoInstanceProposalCommon;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlTemplateProposal;

public class RfLazyAutoInstanceProposal
extends RfLazyAutoInstanceProposalCommon {
    private StyledString fStyledDisplayString;

    public RfLazyAutoInstanceProposal(LinkedHashMap<String, IRegion> templates, ITextViewer viewer, TemplateContext context, IRfDesignElement candidate, boolean showLibrary, Image image, IContextInformation contextInformation, String currentWord) {
        super(templates, viewer, context, candidate, showLibrary, image, contextInformation, currentWord);
        this.fStyledDisplayString = new StyledString(this.fDisplayString);
        if (showLibrary) {
            String enclosingLibraryName = this.fCandidate.getEnclosingLibrary().getName();
            if ("non-top-files".equalsIgnoreCase(enclosingLibraryName)) {
                enclosingLibraryName = "work";
            }
            this.fStyledDisplayString.append(new StyledString(" - " + enclosingLibraryName, StyledString.QUALIFIER_STYLER));
        }
    }

    public void apply(IDocument document) {
        try {
            this.fTemplateProposal = null;
            LinkedHashMap<Template, IRegion> templates = new LinkedHashMap<Template, IRegion>();
            boolean mainTemplate = true;
            IEditorPart editor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            for (Map.Entry e : this.fTemplates.entrySet()) {
                IRegion region = (IRegion)e.getValue();
                String replacementString = RfLazyAutoInstanceProposal.formatReplacementString((String)e.getKey(), region, this.fTextViewer, mainTemplate, null, this.fPrefix);
                templates.put(new Template("", this.fDisplayString, "ro.amiq.vhdldt.templates.contextType.unknown", replacementString, true), region);
                mainTemplate = false;
            }
            this.fTemplateProposal = new VhdlTemplateProposal(templates, this.fContext, this.fImage, 1, DVTDocumentCommon.getLineDelimiter((IEditorPart)editor));
            this.fTemplateProposal.apply(this.fTextViewer, '\u0000', 0, this.fRegion.getOffset());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public StyledString getStyledDisplayString() {
        return this.fStyledDisplayString;
    }

    @Override
    protected String getNewLineReplacement() {
        return "<br>";
    }
}

