/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.contentasisst.IAutoinstanceProposal;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlTemplateProposal;

public abstract class RfLazyAutoInstanceProposalCommon
implements IAutoinstanceProposal,
ICompletionProposal,
ICompletionProposalExtension6 {
    protected String fReplacementString;
    protected String fDisplayString;
    protected Image fImage;
    protected int fCursorPosition;
    protected IContextInformation fContextInformation;
    protected ITextViewer fTextViewer;
    protected IRfDesignElement fCandidate;
    protected TemplateContext fContext;
    protected IRegion fRegion;
    protected LinkedHashMap<String, IRegion> fTemplates = new LinkedHashMap();
    protected String fPrefix;
    protected VhdlTemplateProposal fTemplateProposal;

    protected RfLazyAutoInstanceProposalCommon(LinkedHashMap<String, IRegion> templates, ITextViewer viewer, TemplateContext context, IRfDesignElement candidate, boolean showLibrary, Image image, IContextInformation contextInformation, String currentWord) {
        this.fTextViewer = viewer;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fContextInformation = contextInformation;
        this.fDisplayString = this.fCandidate.getName();
        if (showLibrary) {
            String enclosingLibraryName = this.fCandidate.getEnclosingLibrary().getName();
            if ("non-top-files".equalsIgnoreCase(enclosingLibraryName)) {
                enclosingLibraryName = "work";
            }
            this.fDisplayString = String.valueOf(this.fDisplayString) + " - " + enclosingLibraryName;
        }
        this.fImage = image;
        this.fCursorPosition = 0;
        this.fContext = context;
        this.fTemplates = templates;
        Iterator<Map.Entry<String, IRegion>> iterator = templates.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, IRegion> e = iterator.next();
            this.fRegion = e.getValue();
            this.fReplacementString = e.getKey();
        }
    }

    protected static String formatReplacementString(String replacementString, IRegion region, ITextViewer textViewer, boolean isInstanceTemplate, String additionalIndent, String prefix) {
        boolean usePrefixCapitalization;
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        boolean prevPreserveSLCommentColumnZero = store.getBoolean("format.indent.preserve_sl_comment_column_zero");
        boolean prevVerticalAlignment = store.getBoolean("format.vertical_align");
        String prevVerticalAlignTokens = store.getString("format.vertical_align.tokens");
        int capitalizationKeyworks = store.getInt("format.capitalization.keywords");
        int capitalizationDataTypes = store.getInt("format.capitalization.data_types");
        boolean bl = usePrefixCapitalization = capitalizationKeyworks == 1 && capitalizationDataTypes == 1;
        if (usePrefixCapitalization) {
            if (prefix != null && !prefix.isEmpty() && Character.isUpperCase(prefix.charAt(0))) {
                store.setValue("format.capitalization.keywords", 2);
                store.setValue("format.capitalization.data_types", 2);
            } else if (prefix != null && !prefix.isEmpty() && Character.isLowerCase(prefix.charAt(0))) {
                store.setValue("format.capitalization.keywords", 3);
                store.setValue("format.capitalization.data_types", 3);
            } else {
                usePrefixCapitalization = false;
            }
        }
        store.setValue("format.indent.preserve_sl_comment_column_zero", false);
        store.setValue("format.vertical_align", true);
        store.setValue("format.vertical_align.tokens", "=>");
        try {
            String tmpReplacementString;
            IDocument d = textViewer.getDocument();
            int offset = region.getOffset();
            int regionLine = d.getLineOfOffset(offset);
            int indentLine = isInstanceTemplate ? regionLine : regionLine - 1;
            String indent = DVTDocumentCommon.getIndentOfLine((IDocument)d, (int)indentLine, (int)offset);
            if (additionalIndent != null) {
                indent = String.valueOf(indent) + additionalIndent;
            }
            if (indent == null) {
                indent = "";
            }
            if ((tmpReplacementString = Utils.formatString(() -> new VhdlSourceViewerConfiguration(null), (String)(replacementString = replacementString.trim()), (IDocument)d, (String)indent, (boolean)isInstanceTemplate)) != null) {
                replacementString = tmpReplacementString;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        store.setValue("format.indent.preserve_sl_comment_column_zero", prevPreserveSLCommentColumnZero);
        store.setValue("format.vertical_align", prevVerticalAlignment);
        store.setValue("format.vertical_align.tokens", prevVerticalAlignTokens);
        if (usePrefixCapitalization) {
            store.setValue("format.capitalization.keywords", 1);
            store.setValue("format.capitalization.data_types", 1);
        }
        return replacementString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getAdditionalProposalInfo() {
        if (this.fReplacementString.length() > 1000) {
            return String.valueOf(this.fReplacementString.substring(0, 600).replaceAll("\n", this.getNewLineReplacement())) + "...";
        }
        return this.fReplacementString.replaceAll("\n", this.getNewLineReplacement());
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public Point getSelection(IDocument document) {
        if (this.fTemplateProposal == null) {
            return new Point(this.fRegion.getOffset() + this.fCursorPosition, 0);
        }
        return this.fTemplateProposal.getSelection(document);
    }

    public IContextInformation getContextInformation() {
        if (this.fTemplateProposal == null) {
            return this.fContextInformation;
        }
        return this.fTemplateProposal.getContextInformation();
    }

    protected abstract String getNewLineReplacement();
}

