/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.r2lparser.R2LDummyElement;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyCompletionProposalCommon;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlParameterHintsUtils;

public class RfLazyCompletionProposal
extends RfLazyCompletionProposalCommon {
    protected DVTLinkedPositionProvider fLinkedPositionProvider;
    protected DVTEditor fEditor;

    protected RfLazyCompletionProposal(ITextViewer viewer, IDocument document, Object candidate, String currentWord, int offset, boolean isInstantiation, IRfScope scope, IContextInformation contextInformation, int capitalization, boolean insertOptionalArguments) {
        super(viewer, document, candidate, currentWord, offset, isInstantiation, scope, contextInformation, capitalization, insertOptionalArguments);
        this.fEditor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : (DVTEditor)DVTUiUtils.getActivePage().getActiveEditor();
        this.fLinkedPositionProvider = new DVTLinkedPositionProvider(this.fEditor, new LinkedModeModel(), "CONTENT_ASSIST_PROPOSAL" + this.toString(), false);
    }

    @Override
    protected IEditorPart getEditor() {
        return this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
    }

    public void apply(IDocument document) {
        try {
            int charOffset;
            Object[] charOffsetPair;
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            if (!this.fPrefix.isEmpty() && (charOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)this.fOffset, (boolean)false, (String)"__vhdl_partitioning")) != null && (charOffset = ((Integer)charOffsetPair[1]).intValue()) < this.fReplacementOffset + this.fPrefix.length()) {
                this.fReplacementOffset = charOffset - this.fPrefix.length();
            }
            this.fTemplateProposal = null;
            this.internalComputeProposal();
            if (this.fCandidate instanceof R2LDummyElement) {
                return;
            }
            if (this.fUseTemplate) {
                Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
                TemplateContext context = this.createContext(document, (IRegion)region);
                Template template = new Template("", this.fDisplayString, "ro.amiq.vhdldt.templates.contextType.unknown", this.fReplacementString, true);
                TemplateBuffer templateBuffer = context.evaluate(template);
                this.fReplacementString = templateBuffer.getString();
                List<IRegion> linkedPositionRegions = this.computeLinkedPositionRegionsFromTemplate(templateBuffer);
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
                this.fTemplateProposal = new TemplateProposal(template, context, (IRegion)region, this.fImage, 1);
                if (linkedPositionRegions == null || linkedPositionRegions.isEmpty() || this.fLinkedPositionProvider == null) {
                    return;
                }
                this.fLinkedPositionProvider.setHasPositions(true);
                IRegion firstRegion = null;
                for (IRegion linkedPosRegion : linkedPositionRegions) {
                    if (firstRegion == null) {
                        firstRegion = linkedPosRegion;
                    }
                    this.fLinkedPositionProvider.addSingleLinkedPosition(linkedPosRegion.getOffset(), linkedPosRegion.getLength(), document);
                }
                if (firstRegion != null) {
                    this.firstParameterOffset = firstRegion.getOffset();
                    this.firstParameterLength = firstRegion.getLength();
                }
                String functionName = "";
                if (this.fCandidate instanceof RfNamedElement) {
                    functionName = ((RfNamedElement)this.fCandidate).getName();
                }
                int contextInformationStartOffset = VhdlParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, false, true);
                int contextInformationEndOffset = VhdlParameterHintsUtils.getContextInformationOffset(document, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, true, true) - 1;
                if (contextInformationStartOffset >= 0 && contextInformationEndOffset >= 0 && this.fFunctionArguments != null) {
                    this.fContextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, this.fDisplayString, this.fFunctionArguments, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__vhdl_partitioning");
                }
                DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.fCandidateHasSemiColon ? (char)';' : ')', this.fReplacementOffset, "__vhdl_partitioning");
                this.fLinkedPositionProvider.enterLinkedMode(document, config);
                return;
            }
            if (this.fCandidate instanceof RfNamedElement && this.fPrefix.isEmpty() && Character.isJavaIdentifierPart(document.getChar(this.fOffset - 1))) {
                this.fReplacementString = " " + this.fReplacementString;
                ++this.fCursorPosition;
            }
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (Exception exception) {}
    }

    private List<IRegion> computeLinkedPositionRegionsFromTemplate(TemplateBuffer templateBuffer) {
        ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
        TemplateVariable[] templateVariables = templateBuffer.getVariables();
        if (templateVariables == null) {
            return linkedPositionRegions;
        }
        TemplateVariable[] templateVariableArray = templateVariables;
        int n = templateVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable templateVariable = templateVariableArray[n2];
            int[] templateOffsets = templateVariable.getOffsets();
            if (templateOffsets != null) {
                String templateVarName = templateVariable.getName();
                int[] nArray = templateOffsets;
                int n3 = templateOffsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    int offset = nArray[n4];
                    linkedPositionRegions.add((IRegion)new Region(this.fReplacementOffset + offset, templateVarName.length()));
                    ++n4;
                }
            }
            ++n2;
        }
        return linkedPositionRegions;
    }

    public Point getSelection(IDocument document) {
        this.internalComputeProposal();
        if (this.fTemplateProposal == null || !this.fLinkedPositionProvider.hasPositions()) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        return new Point(this.firstParameterOffset, this.firstParameterLength);
    }

    @Override
    protected String partiallyEscapeHTML(String signature) {
        return DVTStringUtil.partiallyEscapeHTML((String)signature);
    }

    @Override
    protected String trimResult(String result) {
        if (result.length() > 300) {
            return String.valueOf(result.substring(0, 300)) + "...";
        }
        return result;
    }
}

