/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfContext;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfPropertySequence;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.r2lparser.R2LAttribute;
import ro.amiq.vhdldt.r2lparser.R2LCaseForEnumElement;
import ro.amiq.vhdldt.r2lparser.R2LCaseWhenChoice;
import ro.amiq.vhdldt.r2lparser.R2LDummyElement;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyAutoInstanceProposal;
import ro.amiq.vhdldt.utils.Utils;

public abstract class RfLazyCompletionProposalCommon
implements IDVTCompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalExtension5 {
    protected Object fCandidate;
    protected String fPrefix;
    protected int fOffset;
    protected String fReplacementString;
    protected String fDisplayString;
    protected Image fImage;
    protected DVTTooltipContent fAdditionalProposalInfo;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected boolean fAlreadyComputed;
    protected IContextInformation fContextInformation;
    protected ITextViewer fTextViewer;
    protected IDocument fDocument;
    protected TemplateProposal fTemplateProposal;
    protected boolean fUseTemplate;
    protected boolean fIsInstantiation;
    protected int fCapitalization;
    protected boolean fInsertOptionalArguments;
    protected static final String CATEGORY = "CONTENT_ASSIST_PROPOSAL";
    protected int firstParameterOffset;
    protected int firstParameterLength;
    protected String fFunctionArguments;
    protected IRfScope fInitialScope;
    protected boolean fCandidateHasSemiColon;

    protected RfLazyCompletionProposalCommon(ITextViewer viewer, IDocument document, Object candidate, String currentWord, int offset, boolean isInstantiation, IRfScope scope, IContextInformation contextInformation, int capitalization, boolean insertOptionalArguments) {
        this.fTextViewer = viewer;
        this.fDocument = document;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fOffset = offset;
        this.fIsInstantiation = isInstantiation;
        this.fContextInformation = contextInformation;
        this.fCapitalization = capitalization;
        this.fInitialScope = scope;
        this.fInsertOptionalArguments = insertOptionalArguments;
    }

    protected TemplateContext createContext(IDocument document, IRegion region) {
        TemplateContextType contextType = new TemplateContextType("ro.amiq.vhdldt.templates.contextType.unknown", "dummy");
        return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
    }

    public IContextInformation getContextInformation() {
        this.internalComputeProposal();
        return this.fContextInformation;
    }

    public Image getImage() {
        this.internalComputeProposal();
        return this.fImage;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        String result = String.valueOf(this.fAdditionalProposalInfo.getSignature()) + this.fAdditionalProposalInfo.getShallow() + this.fAdditionalProposalInfo.getComment() + this.fAdditionalProposalInfo.getUPFSignature() + this.fAdditionalProposalInfo.getDebugInfo();
        return this.trimResult(result);
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return this.getAdditionalProposalInfo();
        }
        return this.fAdditionalProposalInfo;
    }

    public String getDisplayString() {
        this.internalComputeProposal();
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    protected void internalComputeProposal() {
        if (this.fAlreadyComputed) {
            return;
        }
        this.fUseTemplate = false;
        this.fAlreadyComputed = true;
        String candidateName = null;
        if (this.fCandidate == null) {
            return;
        }
        this.fReplacementString = this.fPrefix;
        this.fDisplayString = "";
        IEditorPart editor = this.getEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        if (this.fCandidate instanceof IRfNamedElement) {
            candidateName = ((IRfNamedElement)this.fCandidate).getName();
            this.fImage = ((IRfNamedElement)this.fCandidate).getImage();
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            this.fReplacementString = "";
            this.fDisplayString = candidateName;
            this.fReplacementOffset = this.fOffset;
            this.fReplacementLength = 0;
            this.fCursorPosition = 0;
            return;
        }
        this.fReplacementOffset = this.fOffset - this.fPrefix.length();
        this.fReplacementLength = this.fPrefix.length();
        Point selectedRange = this.fTextViewer.getSelectedRange();
        if (this.fReplacementLength == 0 && selectedRange != null && selectedRange.x == this.fReplacementOffset) {
            this.fReplacementLength = selectedRange.y;
        }
        if (this.fCandidate instanceof RfAlias && ((RfAlias)this.fCandidate).isSubprogramInstantiation()) {
            this.fCandidate = ((RfAlias)this.fCandidate).getAssociatedType();
        }
        if (this.fCandidate instanceof R2LCaseWhenChoice) {
            String indent = DVTFileUtils.computeIndent((IDocument)this.fTextViewer.getDocument(), (int)this.fOffset);
            this.fReplacementString = String.valueOf(candidateName) + "=>\n" + indent + "    ${}";
            this.fDisplayString = candidateName;
            this.fUseTemplate = true;
        } else {
            if (this.fCandidate instanceof R2LCaseForEnumElement) {
                String tab = this.getTabWidth();
                String lineOffset = "";
                try {
                    lineOffset = DVTDocumentCommon.getIndentOfLine((IDocument)this.fTextViewer.getDocument(), (int)this.fTextViewer.getDocument().getLineOfOffset(this.fOffset), (int)this.fOffset);
                    if (Character.isJavaIdentifierPart(this.fTextViewer.getDocument().getChar(this.fReplacementOffset - 1))) {
                        this.fReplacementString = " " + ((R2LCaseForEnumElement)this.fCandidate).getReplacementString(lineOffset, lineDelimiter, tab);
                        this.fCursorPosition = ((R2LCaseForEnumElement)this.fCandidate).getCursorPosition() + 1;
                    } else {
                        this.fReplacementString = ((R2LCaseForEnumElement)this.fCandidate).getReplacementString(lineOffset, lineDelimiter, tab);
                        this.fCursorPosition = ((R2LCaseForEnumElement)this.fCandidate).getCursorPosition();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                this.fDisplayString = candidateName;
                return;
            }
            if (this.fCandidate instanceof IRfPortElement) {
                this.fReplacementString = candidateName;
                String portRange = this.fCandidate instanceof RfPort ? ((RfPort)this.fCandidate).getRange() : null;
                String rangeString = portRange == null || portRange.isEmpty() ? "" : "(" + portRange + ")";
                this.fDisplayString = String.valueOf(candidateName) + ": " + ((IRfAssociatedTypeElement)this.fCandidate).getAssociatedTypeName() + rangeString;
            } else if (this.fCandidate instanceof RfFunction) {
                this.fDisplayString = candidateName;
                this.fReplacementString = candidateName;
                if (this.fIsInstantiation) {
                    this.fFunctionArguments = arguments = ((RfFunction)this.fCandidate).getArgs(false, true, false);
                    String typeName = ((RfFunction)this.fCandidate).getAssociatedTypeName();
                    String signature = "[";
                    signature = String.valueOf(signature) + arguments;
                    if (typeName != null && !typeName.isEmpty()) {
                        signature = String.valueOf(signature) + " return " + typeName;
                    }
                    signature = String.valueOf(signature) + "]";
                    this.fDisplayString = String.valueOf(this.fDisplayString) + signature;
                    this.fReplacementString = String.valueOf(this.fReplacementString) + signature;
                    this.addGenericMap(lineDelimiter);
                } else {
                    List<RfVariable> args;
                    arguments = "";
                    arguments = this.fInsertOptionalArguments ? ((RfFunction)this.fCandidate).getArgs(true, true, false) : ((args = ((RfFunction)this.fCandidate).getArguments()) == null || args.isEmpty() ? "" : this.computeFunctionArguments(args, false));
                    if (arguments != null && arguments.length() > 0) {
                        this.fDisplayString = String.valueOf(this.fDisplayString) + "(" + arguments + ")";
                    }
                    this.fFunctionArguments = arguments;
                    this.fUseTemplate = arguments != null && arguments.length() > 0;
                    this.fReplacementString = String.valueOf(this.fReplacementString) + this.getFunctionArgumentsReplacement(lineDelimiter);
                    if (((RfFunction)this.fCandidate).isTask()) {
                        this.fReplacementString = String.valueOf(this.fReplacementString) + ";";
                        this.fCandidateHasSemiColon = true;
                    }
                }
            } else if (this.fCandidate instanceof RfPackage && this.fIsInstantiation) {
                this.fReplacementString = candidateName;
                this.fDisplayString = candidateName;
                this.addGenericMap(lineDelimiter);
            } else if (this.fCandidate instanceof IRfBlockElement) {
                IRfBlockElement generateBlock = (IRfBlockElement)this.fCandidate;
                this.fReplacementString = generateBlock.getName();
                if (generateBlock.isLoopGenerate()) {
                    this.fReplacementString = String.valueOf(this.fReplacementString) + "(${i})";
                    this.fUseTemplate = true;
                }
                this.fDisplayString = candidateName;
            } else if (this.fCandidate instanceof RfLibrary) {
                this.fDisplayString = this.fReplacementString = ((RfLibrary)this.fCandidate).getCustomName();
            } else if (this.fCandidate instanceof RfVariable || this.fCandidate instanceof RfEntity || this.fCandidate instanceof RfType || this.fCandidate instanceof RfArchitecture || this.fCandidate instanceof RfProcess || this.fCandidate instanceof RfPackage || this.fCandidate instanceof RfComponent || this.fCandidate instanceof RfInstance || this.fCandidate instanceof RfContext || this.fCandidate instanceof RfConfiguration || this.fCandidate instanceof RfEnum || this.fCandidate instanceof RfVUnit || this.fCandidate instanceof RfPropertySequence || this.fCandidate instanceof R2LAttribute || !(this.fCandidate instanceof RfNamedElement)) {
                this.fReplacementString = candidateName;
                this.fDisplayString = candidateName;
            }
        }
        this.fCursorPosition = this.fUseTemplate ? this.fDisplayString.length() : this.fReplacementString.length();
        if (this.fCandidate instanceof RfType && ((RfType)this.fCandidate).isPredefined()) {
            switch (this.fCapitalization) {
                case 2: {
                    this.fReplacementString = this.fReplacementString == null ? null : this.fReplacementString.toUpperCase();
                    this.fDisplayString = this.fDisplayString == null ? null : this.fDisplayString.toUpperCase();
                    break;
                }
                case 3: {
                    this.fReplacementString = this.fReplacementString == null ? null : this.fReplacementString.toLowerCase();
                    this.fDisplayString = this.fDisplayString == null ? null : this.fDisplayString.toLowerCase();
                    break;
                }
                case 1: {
                    if (this.fPrefix.isEmpty()) break;
                    char firstChar = this.fPrefix.charAt(0);
                    if (Character.isLowerCase(firstChar)) {
                        this.fReplacementString = this.fReplacementString == null ? null : this.fReplacementString.toLowerCase();
                        this.fDisplayString = this.fDisplayString == null ? null : this.fDisplayString.toLowerCase();
                        break;
                    }
                    if (!Character.isUpperCase(firstChar)) break;
                    this.fReplacementString = this.fReplacementString == null ? null : this.fReplacementString.toUpperCase();
                    this.fDisplayString = this.fDisplayString == null ? null : this.fDisplayString.toUpperCase();
                    break;
                }
            }
        }
    }

    private void addGenericMap(String lineDelimiter) {
        List<RfNamedElement> generics = ((RfNamedElement)this.fCandidate).getLocalMembers(RfNamedElement.class);
        if (generics == null) {
            return;
        }
        Iterator<RfNamedElement> it = generics.iterator();
        while (it.hasNext()) {
            RfNamedElement element = it.next();
            if (element instanceof RfVariable && ((RfVariable)element).isParameter() || element instanceof RfType && ((RfType)element).isGeneric()) continue;
            it.remove();
        }
        if (generics.isEmpty()) {
            return;
        }
        this.fUseTemplate = true;
        StringBuilder displayStringGenericMap = new StringBuilder(" GENERIC MAP (");
        StringBuilder replacementStringGenericMap = new StringBuilder(String.valueOf(lineDelimiter) + "GENERIC MAP (");
        it = generics.iterator();
        while (it.hasNext()) {
            String elementName = it.next().getName();
            displayStringGenericMap = displayStringGenericMap.append(elementName).append(" => ").append(elementName);
            replacementStringGenericMap = replacementStringGenericMap.append(lineDelimiter).append(elementName).append(" => ${").append(elementName).append("}");
            if (!it.hasNext()) continue;
            displayStringGenericMap = displayStringGenericMap.append(", ");
            replacementStringGenericMap = replacementStringGenericMap.append(", ");
        }
        displayStringGenericMap = displayStringGenericMap.append(");");
        replacementStringGenericMap = replacementStringGenericMap.append(lineDelimiter).append(");");
        this.fDisplayString = String.valueOf(this.fDisplayString) + displayStringGenericMap.toString();
        this.fReplacementString = String.valueOf(this.fReplacementString) + replacementStringGenericMap.toString();
        this.fCandidateHasSemiColon = true;
        Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
        String tabOrSpace = this.getTabWidth();
        this.fReplacementString = RfLazyAutoInstanceProposal.formatReplacementString(this.fReplacementString, (IRegion)region, this.fTextViewer, true, tabOrSpace, this.fPrefix);
    }

    private String getFunctionArgumentsReplacement(String lineDelimiter) {
        StringBuilder replacementStringBuilder = new StringBuilder();
        if (!(this.fCandidate instanceof RfFunction)) {
            return replacementStringBuilder.toString();
        }
        List<RfVariable> arguments = ((RfFunction)this.fCandidate).getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return replacementStringBuilder.toString();
        }
        boolean insertNamedArgumentsAsMultiline = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.multi_line_named_arguments");
        boolean insertOrderedArgumentsAsMultiline = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.multi_line_ordered_arguments");
        if (!Utils.isContentAssistInsertNamedArguments()) {
            String argumentsReplacement = "";
            argumentsReplacement = this.fInsertOptionalArguments ? ((RfFunction)this.fCandidate).getArgs(true, false, true) : this.computeFunctionArguments(arguments, true);
            if (insertOrderedArgumentsAsMultiline) {
                argumentsReplacement = argumentsReplacement.replaceAll(", ", "," + lineDelimiter);
            }
            replacementStringBuilder = replacementStringBuilder.append(insertOrderedArgumentsAsMultiline ? "(" + lineDelimiter : "(");
            replacementStringBuilder = replacementStringBuilder.append(argumentsReplacement);
            replacementStringBuilder = replacementStringBuilder.append(insertOrderedArgumentsAsMultiline ? String.valueOf(lineDelimiter) + ")" : ")");
        } else {
            replacementStringBuilder = replacementStringBuilder.append("(");
            if (arguments.size() == 1) {
                RfVariable argument = arguments.get(0);
                replacementStringBuilder = argument.getInitialValue(false) != null && !this.fInsertOptionalArguments ? replacementStringBuilder.append("open)") : replacementStringBuilder.append(argument).append(" => ${").append(argument).append("})");
            } else {
                for (RfVariable element : arguments) {
                    String elementName;
                    if (element.getInitialValue(false) != null && !this.fInsertOptionalArguments || (elementName = element.getName()) == null) continue;
                    replacementStringBuilder = replacementStringBuilder.append(insertNamedArgumentsAsMultiline ? lineDelimiter : "");
                    replacementStringBuilder = replacementStringBuilder.append(elementName).append(" => ${").append(elementName).append("}, ");
                }
                if (replacementStringBuilder.length() > 2) {
                    replacementStringBuilder = new StringBuilder(replacementStringBuilder.substring(0, replacementStringBuilder.length() - 2));
                }
                replacementStringBuilder = replacementStringBuilder.append(insertNamedArgumentsAsMultiline ? String.valueOf(lineDelimiter) + ")" : ")");
            }
        }
        Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
        String replacementString = replacementStringBuilder.toString();
        replacementString = RfLazyAutoInstanceProposal.formatReplacementString(replacementString, (IRegion)region, this.fTextViewer, true, null, this.fPrefix);
        return replacementString;
    }

    private String computeFunctionArguments(List<RfVariable> args, boolean isReplacement) {
        if (args == null || args.isEmpty()) {
            return "";
        }
        StringBuilder arguments = new StringBuilder();
        boolean insertNamedArguments = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ca.insert_named_arguments");
        if (args.size() == 1) {
            RfVariable argument = args.get(0);
            if (argument.getName() == null) {
                return "";
            }
            String argumentReplacement = "";
            argumentReplacement = isReplacement ? String.valueOf(argumentReplacement) + "${" + argument.getName() + "}" : String.valueOf(argument.getName()) + " : " + argument.getAssociatedTypeName();
            arguments = arguments.append(argument.getInitialValue(false) != null && !this.fInsertOptionalArguments ? "open" : argumentReplacement);
        } else {
            int argumentsLength = 0;
            for (RfVariable argument : args) {
                String initialValue = argument.getInitialValue(false);
                if (initialValue != null && !this.fInsertOptionalArguments) {
                    if (insertNamedArguments) continue;
                    arguments = arguments.append(arguments.length() == 0 ? "open" : ", open");
                    continue;
                }
                if (argument.getName() == null) continue;
                String argumentReplacement = "";
                argumentReplacement = isReplacement ? String.valueOf(argumentReplacement) + "${" + argument.getName() + "}" : String.valueOf(argument.getName()) + " : " + argument.getAssociatedTypeName();
                arguments = arguments.append(arguments.length() == 0 ? argumentReplacement : ", " + argumentReplacement);
                argumentsLength = arguments.length();
            }
            if (argumentsLength >= 0) {
                arguments = new StringBuilder(arguments.substring(0, argumentsLength));
            }
        }
        return arguments.toString();
    }

    public boolean isNoProposal() {
        return this.fCandidate instanceof R2LDummyElement;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    private String getTabWidth() {
        boolean useSpacesNotTabs;
        String tabOrSpace;
        int tabWidth = 4;
        if (this.fTextViewer instanceof DVTProjectionViewer) {
            tabWidth = ((DVTProjectionViewer)this.fTextViewer).getEditor().getTabWidth();
        }
        if ((tabOrSpace = TextUtils.getIndentTab((boolean)(useSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)VhdlPlugin.getDefault().getCombinedPreferenceStore())), (int)tabWidth)) == null) {
            tabOrSpace = "    ";
        }
        return tabOrSpace;
    }

    protected void computeAdditionalProposalInfo() {
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        DVTTooltipContent tooltipContent = new DVTTooltipContent();
        if (this.fCandidate instanceof IRfNamedElement) {
            RfUtils.getTooltipFormattedText(new RfWNamedElementAndScope((IRfNamedElement)this.fCandidate, this.fInitialScope, null), (ITextEditor)this.getEditor(), tooltipContent);
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(tooltipContent.getSignature()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipContent.getComment());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltipContent.getPreference());
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(((R2LDummyElement)this.fCandidate).getSignature()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, "");
            return;
        }
    }

    protected abstract String partiallyEscapeHTML(String var1);

    protected abstract IEditorPart getEditor();

    protected abstract String trimResult(String var1);
}

