/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.MaxNofItemsReached;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.util.NullProtectedList;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.templates.TemplateEditorUI;
import ro.amiq.vhdldt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyAutoInstanceProposal;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public abstract class VhdlAutoInstanceContentAssistProcessorCommon
extends RfContentAssistProcessor {
    private static final int MAX_NOF_TOTAL_PROPOSALS = 100;
    private static final int STATE_SKIP = 0;
    private static final int STATE_FIELD = 1;
    private static final int STATE_INIT = 2;
    private static final int TAB_SIZE = 4;
    private int fMatchType;

    protected VhdlAutoInstanceContentAssistProcessorCommon(VhdlContentAssistProcessorManager assistant) {
        super(assistant);
        boolean ignoreCase = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
        boolean camelCase = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
        boolean prefixMatch = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
        this.fMatchType = (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        NullProtectedList<IRfDesignElement> candidates;
        String currentWord;
        RfProject rfProject;
        IDocument document;
        block16: {
            block15: {
                block14: {
                    block13: {
                        document = viewer.getDocument();
                        if (document != null) break block13;
                        return null;
                    }
                    rfProject = this.getProcessor().getProject();
                    if (rfProject != null) break block14;
                    return null;
                }
                currentWord = this.lastWord(document, offset);
                if (this.shouldDisplayAutoInstance(currentWord)) break block15;
                return null;
            }
            if (currentWord == null || currentWord.length() == 0) {
                currentWord = "";
            }
            candidates = new NullProtectedList<IRfDesignElement>();
            candidates.setMaxNofItems(100);
            try {
                candidates.addAll(rfProject.getInstanceHoldersWithPrefix(rfProject.getLibraries(), currentWord, this.fMatchType, 100));
                List designs = rfProject.getMixedLangProjectParent().getDesignsWithPrefix((IRfSingleLangProject)rfProject, currentWord, this.fMatchType);
                candidates.addAll(designs);
            }
            catch (MaxNofItemsReached maxNofItemsReached) {}
            if (!candidates.isEmpty()) break block16;
            return null;
        }
        try {
            Collections.sort(candidates, VhdlContentAssistProcessorManager.getContextSorter(currentWord));
            int instanceLineOffset = this.getInstanceLineOffset(document, offset);
            StringBuilder alignBuilder = new StringBuilder(instanceLineOffset + 4);
            int i = 0;
            while (i < instanceLineOffset + 4) {
                alignBuilder.append(" ");
                ++i;
            }
            alignBuilder = new StringBuilder(instanceLineOffset);
            i = 0;
            while (i < instanceLineOffset) {
                alignBuilder.append(" ");
                ++i;
            }
            ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
            boolean showLibrary = rfProject.getLibraries().size() != 3;
            for (IRfDesignElement candidate : candidates) {
                ICompletionProposal proposal = this.createProposal(viewer, offset, candidate, showLibrary, this.fProcessor.fRfScope, currentWord);
                if (proposal == null) {
                    return new ICompletionProposal[0];
                }
                result.add(proposal);
            }
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ICompletionProposal createProposal(ITextViewer viewer, int offset, IRfDesignElement candidate, boolean showEnclosingLibrary, IRfScopeElement scope, String prefix) {
        List localPorts;
        String libraryName;
        IDocument document = viewer.getDocument();
        IPreferenceStore store = VhdlPlugin.getDefault().getPreferenceStore();
        Image image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_ANY_DESIGN_INSTANCE);
        if (candidate instanceof RfEntity) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENTITY_INSTANCE);
        } else if (candidate instanceof RfComponent) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_COMPONENT_INSTANCE);
        }
        int instanceLineOffset = this.getInstanceLineOffset(document, offset);
        StringBuilder alignBuilder = new StringBuilder(instanceLineOffset + 4);
        String instanceAlignment = alignBuilder.toString();
        int instanceOffset = this.getInstanceDocumentOffset(document, offset);
        IEditorPart editor = viewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)viewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        String portAlignment = alignBuilder.toString();
        StringBuilder replacementString = new StringBuilder(" ${").append(store.getString("contentAssist.module_autoinstance_prefix")).append(candidate.getName()).append("} : ");
        StringBuilder headerWires = null;
        if (candidate instanceof RfEntity || !(candidate instanceof RfNamedElement)) {
            replacementString.append("ENTITY");
        } else if (candidate instanceof RfComponent) {
            replacementString.append("COMPONENT");
        } else if (candidate instanceof RfConfiguration) {
            replacementString.append("CONFIGURATION");
        }
        NullProtectedList<RfVariable> parameters = new NullProtectedList<RfVariable>();
        if (candidate instanceof RfNamedElement) {
            parameters.addAll(((RfNamedElement)candidate).getVariablesWithPrefix("", 2, true));
        }
        IRfLibraryElement library = candidate.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY || candidate.getKind() == IRfNamedElement.ElementKind.VHDL_CONFIGURATION ? candidate.getEnclosingLibrary() : null;
        String string = libraryName = library != null && library.getName() != null ? library.getName() : null;
        if ("non-top-files".equalsIgnoreCase(libraryName)) {
            libraryName = "work";
        }
        String string2 = libraryName = libraryName != null && !libraryName.isEmpty() ? "${" + libraryName + "}." : "";
        if (candidate instanceof RfNamedElement) {
            replacementString.append(" ").append(libraryName).append(candidate.getName());
        } else {
            replacementString.append(" ").append("${").append(candidate.getEnclosingScope().getName()).append("}.").append(candidate.getName());
        }
        boolean hasAny = false;
        if (!parameters.isEmpty()) {
            boolean first = true;
            for (RfVariable param : parameters) {
                if (!param.isParameter()) continue;
                hasAny = true;
                if (!first) {
                    replacementString.append(",").append(lineDelimiter);
                } else {
                    replacementString.append(instanceAlignment).append(lineDelimiter).append(" GENERIC MAP (").append(lineDelimiter);
                    first = false;
                }
                if (param.getInitialValue(false) != null) {
                    replacementString.append(portAlignment).append(param.getName()).append(" => ").append(this.removeUnitsOfMeasurement(param.getInitialValue(false)));
                    continue;
                }
                replacementString.append(portAlignment).append(param.getName()).append(" => ").append("${").append(param.getName()).append("}");
            }
            if (hasAny) {
                replacementString.append(lineDelimiter).append(instanceAlignment).append(" )");
            }
        }
        ArrayList ports = (localPorts = candidate.getLocalPortsNoAliases()) != null ? new ArrayList(localPorts) : new ArrayList();
        boolean hasUnknownsOrPortSelects = ports.stream().filter(port -> port.isNonANSIImplicitPort()).findFirst().isPresent();
        if (!ports.isEmpty()) {
            boolean preservePortOrderAndComments;
            replacementString.append(lineDelimiter);
            if (hasAny) {
                replacementString.append(lineDelimiter).append(instanceAlignment).append(" PORT MAP (");
            } else {
                replacementString.append(" PORT MAP (");
            }
            hasAny = true;
            headerWires = new StringBuilder();
            boolean bl = preservePortOrderAndComments = PrefConst.preservePortOrderAndComments(VhdlPlugin.getDefault().getPreferenceStore()) || hasUnknownsOrPortSelects;
            if (preservePortOrderAndComments) {
                headerWires.append(this.addSignals(ports, lineDelimiter, scope, new HashSet<String>()));
                replacementString.append(this.addPortsInOrderAndComments(ports, portAlignment, lineDelimiter));
                replacementString.append(lineDelimiter).append(instanceAlignment);
            } else {
                ArrayList<IRfPortElement> inputs = new ArrayList<IRfPortElement>();
                ArrayList<IRfPortElement> inouts = new ArrayList<IRfPortElement>();
                ArrayList<IRfPortElement> outputs = new ArrayList<IRfPortElement>();
                ArrayList<IRfPortElement> buffers = new ArrayList<IRfPortElement>();
                ArrayList<IRfPortElement> linkages = new ArrayList<IRfPortElement>();
                for (IRfPortElement port2 : ports) {
                    if (port2.isInput()) {
                        inputs.add(port2);
                        continue;
                    }
                    if (port2.isInout()) {
                        inouts.add(port2);
                        continue;
                    }
                    if (port2.isOutput()) {
                        outputs.add(port2);
                        continue;
                    }
                    if (port2.isBuffer()) {
                        buffers.add(port2);
                        continue;
                    }
                    if (!port2.isLinkage()) continue;
                    linkages.add(port2);
                }
                boolean first = true;
                HashSet<String> added = new HashSet<String>();
                if (!inputs.isEmpty()) {
                    replacementString.append(this.addPortsByCategory(inputs, first, "-- Inputs", portAlignment, lineDelimiter));
                    headerWires.append(this.addSignals(inputs, lineDelimiter, scope, added));
                    first = false;
                }
                if (!inouts.isEmpty()) {
                    replacementString.append(this.addPortsByCategory(inouts, first, "-- Inouts", portAlignment, lineDelimiter));
                    headerWires.append(this.addSignals(inouts, lineDelimiter, scope, added));
                    first = false;
                }
                if (!outputs.isEmpty()) {
                    replacementString.append(this.addPortsByCategory(outputs, first, "-- Outputs", portAlignment, lineDelimiter));
                    headerWires.append(this.addSignals(outputs, lineDelimiter, scope, added));
                    first = false;
                }
                if (!buffers.isEmpty()) {
                    replacementString.append(this.addPortsByCategory(buffers, first, "-- Buffer Ports", portAlignment, lineDelimiter));
                    headerWires.append(this.addSignals(buffers, lineDelimiter, scope, added));
                    first = false;
                }
                if (!linkages.isEmpty()) {
                    replacementString.append(this.addPortsByCategory(linkages, first, "-- Linkage Ports", portAlignment, lineDelimiter));
                    headerWires.append(this.addSignals(linkages, lineDelimiter, scope, added));
                    first = false;
                }
                inputs.clear();
                inouts.clear();
                outputs.clear();
                buffers.clear();
                linkages.clear();
                if (!first) {
                    replacementString.append(lineDelimiter).append(instanceAlignment);
                }
            }
            if (PrefConst.isGenerateSignalsEnabled(store) && !headerWires.toString().isEmpty()) {
                headerWires.insert(0, lineDelimiter).append(lineDelimiter).toString();
            } else {
                headerWires = null;
            }
            replacementString.append(" )");
        }
        if (!hasAny) {
            replacementString.append(instanceAlignment).append(";");
        } else {
            replacementString.append(";");
        }
        Region region = new Region(instanceOffset, offset - instanceOffset);
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return null;
        }
        LinkedHashMap<String, IRegion> templates = new LinkedHashMap<String, IRegion>();
        templates.put(replacementString.toString().trim(), (IRegion)region);
        int archInsertionPoint = this.getArchInsertionPoint(viewer, offset);
        if (archInsertionPoint >= 0 && headerWires != null) {
            templates.put(headerWires.toString(), (IRegion)new Region(archInsertionPoint, 0));
        }
        return new RfLazyAutoInstanceProposal(templates, viewer, context, candidate, showEnclosingLibrary, image, null, prefix);
    }

    private int getArchInsertionPoint(ITextViewer viewer, int offset) {
        int result = -1;
        try {
            IEditorPart editor = this.getEditor(viewer);
            if (editor instanceof DVTEditor) {
                IRfScope scope = RfUtils.getRfScope((ITextEditor)((DVTEditor)editor), viewer.getDocument(), offset);
                if (scope == null) {
                    return result;
                }
                if (scope.getNamedElement() instanceof RfArchitecture) {
                    RfArchitecture a = (RfArchitecture)scope.getNamedElement();
                    for (IRfNamedElement iRfNamedElement : a.getAllSignals()) {
                        int line = iRfNamedElement.getLine();
                        if (iRfNamedElement.getEnclosingScope() != a || line == 0) continue;
                        result = viewer.getDocument().getLineOffset(line);
                    }
                    int n = a.getLine();
                    if (result == -1 && n != 0) {
                        result = viewer.getDocument().getLineOffset(n);
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private String addPortsByCategory(List<IRfPortElement> categoryPorts, boolean first, String categoryComment, String portAlignment, String lineDelimiter) {
        StringBuilder replacementString = new StringBuilder();
        if (categoryPorts == null || categoryPorts.isEmpty()) {
            return replacementString.toString();
        }
        if (!first) {
            replacementString.append(",");
        }
        if (categoryComment != null) {
            replacementString.append(lineDelimiter).append(portAlignment).append(categoryComment);
        }
        int size = categoryPorts.size();
        int i = 0;
        while (i < size) {
            IRfPortElement port = categoryPorts.get(i);
            if (i > 0) {
                replacementString.append(",");
            }
            replacementString.append(lineDelimiter).append(portAlignment).append(this.getEscName(port)).append(" => ").append("${").append(this.getEscName(port)).append("}");
            ++i;
        }
        return replacementString.toString();
    }

    private String getEscName(IRfPortElement element) {
        boolean isEscapedId = element.isEscaped();
        String name = element.getName();
        if (element.isNonANSIImplicitPort()) {
            return name.substring(1, name.length() - 1);
        }
        return isEscapedId ? "\\" + name + " " : name;
    }

    private String addPortsInOrderAndComments(Collection<? extends IRfPortElement> ports, String portAlignment, String lineDelimiter) {
        StringBuilder replacementString = new StringBuilder();
        if (ports == null || ports.isEmpty()) {
            return replacementString.toString();
        }
        int i = 0;
        int size = ports.size();
        for (IRfPortElement iRfPortElement : ports) {
            String inlineComment;
            String aboveComment;
            CommentBlock commentBlock = iRfPortElement.getCommentBlock();
            if (commentBlock != null && (aboveComment = commentBlock.getAboveComment()) != null && !aboveComment.isEmpty()) {
                String[] tokens;
                String[] stringArray = tokens = aboveComment.split("(?:\\r\\n)|(?:[\\r\\n])");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    replacementString.append(lineDelimiter).append(portAlignment).append("--").append(tok);
                    ++n2;
                }
            }
            replacementString.append(lineDelimiter).append(portAlignment).append(this.getEscName(iRfPortElement)).append(" => ").append("${").append(this.getEscName(iRfPortElement)).append("}");
            if (i++ < size - 1) {
                replacementString.append(",");
            }
            if (commentBlock == null || (inlineComment = commentBlock.getInlineComment()) == null || inlineComment.isEmpty()) continue;
            replacementString.append(" --").append(inlineComment);
        }
        return replacementString.toString();
    }

    private String addSignals(Collection<? extends IRfPortElement> ports, String lineDelimiter, IRfScopeElement scope, Set<String> added) {
        StringBuilder result = new StringBuilder();
        for (IRfPortElement iRfPortElement : ports) {
            String portName = iRfPortElement.getName();
            if (scope != null && scope.getSignalWithPrefix(portName, 1) != null) {
                added.add(portName);
                continue;
            }
            portName = this.getEscName(iRfPortElement);
            if (added.contains(portName)) continue;
            added.add(portName);
            String portType = iRfPortElement.getAssociatedTypeName();
            String portDim = iRfPortElement.getRange();
            if (portDim == null) {
                portDim = "";
            }
            if (iRfPortElement instanceof RfPort) {
                if (!portDim.isEmpty()) {
                    portDim = "(" + portDim + ")";
                }
            } else if (portDim.isEmpty()) {
                portType = "STD_LOGIC";
            } else {
                portType = "STD_LOGIC_VECTOR";
                portDim = this.computePortDimensions(portDim);
            }
            result.append("SIGNAL").append(" ${").append(portName).append("} : ").append(portType).append(portDim).append(";").append(lineDelimiter);
        }
        return result.toString();
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = TemplateEditorUI.getDefault().getContextTypeRegistry().getContextType(this.fProcessor.getContextType());
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lastWord(IDocument doc, int offset) {
        int state = 2;
        int endPoz = offset;
        try {
            int n = offset - 1;
            while (true) {
                if (n < 0) {
                    return "";
                }
                char c = doc.getChar(n);
                switch (state) {
                    case 2: {
                        if (!Character.isJavaIdentifierPart(c)) return "";
                        endPoz = n;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) break;
                        return doc.get(n + 1, endPoz - n);
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    private int getInstanceLineOffset(IDocument doc, int offset) {
        int state = 2;
        int startPoz = offset;
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (c == '\n') {
                    return startPoz - n - 1;
                }
                switch (state) {
                    case 2: {
                        if (Character.isJavaIdentifierPart(c)) {
                            state = 1;
                            startPoz = n;
                            break;
                        }
                        if (c == '\t') {
                            startPoz += 4;
                        }
                        state = 0;
                        break;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) {
                            startPoz = n;
                            break;
                        }
                        if (c == '\t') {
                            startPoz += 4;
                        }
                        state = 0;
                        break;
                    }
                    case 0: {
                        if (c != '\t') break;
                        startPoz += 4;
                        break;
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return 0;
    }

    private int getInstanceDocumentOffset(IDocument doc, int offset) {
        int state = 2;
        int startPoz = offset;
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                switch (state) {
                    case 2: {
                        if (Character.isJavaIdentifierPart(c)) {
                            state = 1;
                            startPoz = n;
                            break;
                        }
                        return startPoz;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) {
                            startPoz = n;
                            break;
                        }
                        return startPoz;
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return startPoz;
    }

    private String removeUnitsOfMeasurement(String initialValue) {
        if (initialValue == null) {
            return initialValue;
        }
        int i = 0;
        while (i < initialValue.length()) {
            if (Character.isWhitespace(initialValue.charAt(i))) {
                return initialValue.substring(0, i);
            }
            ++i;
        }
        return initialValue;
    }

    private String computePortDimensions(String portDim) {
        if (portDim == null) {
            return "";
        }
        String dimensions = portDim.replace("[", "").replace("]", "").trim();
        int indexOfColon = dimensions.indexOf(":");
        String insertDownTo = " downto ";
        if (indexOfColon != -1) {
            int firstNumber = 0;
            int secondNumber = 0;
            try {
                firstNumber = Integer.parseInt(dimensions.substring(0, indexOfColon).trim());
                secondNumber = Integer.parseInt(dimensions.substring(indexOfColon + 1).trim());
            }
            catch (NumberFormatException numberFormatException) {}
            if (firstNumber < secondNumber) {
                insertDownTo = " to ";
            }
        }
        return portDim.replace("[", "(").replace("]", ")").replace(":", insertDownTo);
    }

    protected abstract boolean shouldDisplayAutoInstance(String var1);

    protected abstract IEditorPart getEditor(ITextViewer var1);
}

