/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.r2lparser.R2LBusy;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.editor.contentassist.InstancePositionalTooltipType;
import ro.amiq.vhdldt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vhdldt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlAutoInstanceContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManagerCommon;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlKeywordContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlParameterHintsUtils;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlTemplateContentAssistProcessor;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;

public class VhdlContentAssistProcessorManager
extends VhdlContentAssistProcessorManagerCommon {
    public VhdlContentAssistProcessorManager(VhdlEditor vEditor, ContentAssistant assistant) {
        super(vEditor, assistant);
    }

    @Override
    public IFile getFile() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        return file;
    }

    public int getNofProcessors() {
        return 4;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            block27: {
                block26: {
                    if (this.fEditor == null) {
                        return null;
                    }
                    if (!this.init(viewer, offset)) {
                        return null;
                    }
                    if (offset != this.getPrevOffset()) break block26;
                    int crtContentAssistPage = this.getCrtContentAssistPage();
                    switch (IDVTContentAssistConstants.ContentAssistProposalsPage.from((int)crtContentAssistPage)) {
                        case DEFAULT: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
                            break;
                        }
                        case TEMPLATES: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Instance proposals");
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (!(processor instanceof TemplateCompletionProcessor)) continue;
                                ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                            return null;
                        }
                        case AUTO_INSTANCE: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show AI Assistant proposals");
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (!(processor instanceof VhdlAutoInstanceContentAssistProcessor)) continue;
                                ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                            break block27;
                        }
                        case AI_ASSISTANT: {
                            this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Default proposals");
                            IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                            if (aiHostContributor == null) {
                                return null;
                            }
                            for (IContentAssistProcessor processor : this.fProcessors) {
                                if (!aiHostContributor.isAICodeCompletionProcessorAndListener(processor)) continue;
                                ICompletionProposal[] proposals = aiHostContributor.computeCompletionProposalsForAIAssistantPage(processor, viewer, offset);
                                if (proposals == null || proposals.length == 0) {
                                    proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                                }
                                return proposals;
                            }
                            return null;
                        }
                    }
                    break block27;
                }
                this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
            }
            RfFileDef file = this.getFileDef();
            RfProject project = this.getProject();
            if (file == null || project == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor processor : this.fProcessors) {
                    if (!(processor instanceof VhdlTemplateContentAssistProcessor) && !(processor instanceof VhdlKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                }
                if (proposals.isEmpty()) {
                    proposals.add(this.getNoProposal(viewer, offset));
                }
                return this.getProposalArray(proposals);
            }
            this.fRfScope = file.getScope(offset);
            if (this.fRfScope == null) {
                return null;
            }
            IRegion region = VhdlWordFinder.getDefault().getWordAtOffset(this.fDocument, offset);
            if (region.getLength() != 0) {
                this.fCurrentWord = this.fDocument.get(region.getOffset(), offset - region.getOffset());
                this.fIsPartial = true;
            } else {
                this.fCurrentWord = this.fDocument.get(region.getOffset(), region.getLength());
                this.fIsPartial = false;
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            boolean isNoProposal = false;
            for (IContentAssistProcessor processor : this.fProcessors) {
                if (processor instanceof VhdlAutoInstanceContentAssistProcessor || processor instanceof VhdlAutoInstanceContentAssistProcessor) continue;
                this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                if (!(processor instanceof RfContentAssistProcessor) || proposals.isEmpty() || !(proposals.get(0) instanceof RfLazyCompletionProposal) || !((RfLazyCompletionProposal)proposals.get(0)).isNoProposal()) continue;
                isNoProposal = true;
            }
            if (isNoProposal && proposals.size() > 1) {
                proposals.remove(0);
            }
            if (proposals.isEmpty()) {
                proposals.add(this.getNoProposal(viewer, offset));
            }
            return this.getProposalArray(proposals);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
        }
    }

    @Override
    protected boolean init(ITextViewer viewer, int offset) {
        if (this.fAlreadyComputed) {
            return true;
        }
        this.fDocument = viewer.getDocument();
        if (this.fDocument == null) {
            return false;
        }
        if (this.fEditor.getEditorInput() instanceof FileEditorInput) {
            IFile fFile = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
            if (fFile == null) {
                return false;
            }
            IProject project = fFile.getProject();
            if (project != null) {
                RfFileDef fileDef;
                if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                    return false;
                }
                this.fRfProject = RfManager.getInstance().getRfProject(project);
                if (this.fRfProject != null && (fileDef = this.fRfProject.getFile((IResource)fFile)) != null) {
                    this.fInitialScope = fileDef.getScope(offset);
                }
            }
        }
        return true;
    }

    @Override
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        PositionalTooltipsNamedElementAndOffsetWrapper namedElementAndOffset;
        if (!this.init(viewer, offset)) {
            return null;
        }
        IRfScope scope = this.fInitialScope;
        if (!(this.fInitialScope instanceof RfDefElement)) {
            if (this.fInitialScope instanceof RfNamedElement) {
                scope = ((RfNamedElement)this.fInitialScope).getDeclaration();
            }
            if (!(scope instanceof RfDefElement)) {
                return null;
            }
        }
        if ((namedElementAndOffset = VhdlParameterHintsUtils.getElementNamedElementAtOffset(this.getFile(), this.fEditor, offset, ((RfDefElement)this.fInitialScope).getStartOffset())) == null) {
            return null;
        }
        RfNamedElement element = namedElementAndOffset.getNamedElement();
        String elementName = "";
        String elementArguments = "";
        if (element instanceof RfFunction) {
            Collection<? extends RfDefElement> functionDeclarations = element.getDeclarations();
            if (functionDeclarations != null && functionDeclarations.contains(this.fInitialScope)) {
                return null;
            }
            elementArguments = ((RfFunction)element).getArgs(true, true, false);
            if (elementArguments.isEmpty()) {
                return null;
            }
            elementName = ((RfFunction)element).getName();
        } else if (element instanceof RfInstance) {
            InstancePositionalTooltipType tooltipType = null;
            int identifierOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, InstancePositionalTooltipType.PORTS.getIdentifierString(), element.getOffset(), namedElementAndOffset.getOffset(), false);
            if (identifierOffset >= 0) {
                tooltipType = InstancePositionalTooltipType.PORTS;
            } else {
                identifierOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, InstancePositionalTooltipType.GENERICS.getIdentifierString(), element.getOffset(), namedElementAndOffset.getOffset(), false);
                if (identifierOffset >= 0) {
                    tooltipType = InstancePositionalTooltipType.GENERICS;
                }
            }
            if (identifierOffset < 0 || tooltipType == null) {
                return null;
            }
            elementName = tooltipType.getIdentifierString();
            elementArguments = this.computeInstanceElementArguments((RfInstance)element, tooltipType);
            if (elementArguments == null) {
                return null;
            }
        }
        int contextInformationStartOffset = VhdlParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, false, false);
        if (contextInformationStartOffset < 0) {
            return null;
        }
        int contextInformationEndOffset = VhdlParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, true, false) - 1;
        if (contextInformationEndOffset < 0) {
            return null;
        }
        String wrapped = DVTStringUtil.textWrap((int)75, (String)elementArguments).toString();
        String tooltip = DVTStringUtil.breakLongNonWhitespaceSequences((String)wrapped, (int)75, (char)'\n');
        DVTProposalContextInformation contextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, tooltip, tooltip, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__vhdl_partitioning");
        IContextInformation[] contextInformations = new IContextInformation[]{contextInformation};
        return contextInformations;
    }

    @Override
    protected RfProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(project);
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public ICompletionProposal[] testHelperComputeTemplatesProposals(ITextViewer viewer, int offset, boolean autoInstance) {
        block10: {
            block9: {
                block8: {
                    if (DVTPlugin.getDefault().collect().c(this.getProject().getProject(), "F7668646C")) break block8;
                    return null;
                }
                this.setPrevOffset(offset);
                IDocument document = viewer.getDocument();
                if (document != null) break block9;
                return null;
            }
            RfFileDef file = this.getFileDef();
            RfProject project = this.getProject();
            if (file == null || project == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor icap : this.fProcessors) {
                    if (!(icap instanceof VhdlTemplateContentAssistProcessor) && !(icap instanceof VhdlKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(icap.computeCompletionProposals(viewer, offset), proposals);
                }
                return this.getProposalArray(proposals);
            }
            this.fRfScope = file.getScope(offset);
            if (this.fRfScope != null) break block10;
            return null;
        }
        try {
            for (IContentAssistProcessor icap : this.fProcessors) {
                if (!(autoInstance ? icap instanceof VhdlAutoInstanceContentAssistProcessor : icap instanceof VhdlTemplateContentAssistProcessor)) continue;
                return icap.computeCompletionProposals(viewer, offset);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    protected ICompletionProposal getBusyProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, viewer.getDocument(), new R2LBusy(), "", fOffset, false, null, null, -1, true);
    }
}

