/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFileDef;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.r2lparser.R2LNoProposalElement;
import ro.amiq.vhdldt.r2lparser.R2LUtils;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.contentassist.InstancePositionalTooltipType;
import ro.amiq.vhdldt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vhdldt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlParameterHintsUtils;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlParameterListValidator;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlPositionalTooltipUtils;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;

public abstract class VhdlContentAssistProcessorManagerCommon
extends DVTContentAssistProcessorManager {
    protected ArrayList<IContentAssistProcessor> fProcessors = new ArrayList();
    protected VhdlEditor fEditor;
    protected ContentAssistant fContentAssistant;
    protected IRfScope fRfScope;
    protected String fCurrentWord;
    protected boolean fIsPartial;
    protected RfProject fRfProject;
    protected IDocument fDocument;
    protected IRfScope fInitialScope;
    protected boolean fAlreadyComputed;
    public static final Comparator<ICompletionProposal> fLexicalSorter = (o1, o2) -> o1.getDisplayString().compareTo(o2.getDisplayString());

    protected VhdlContentAssistProcessorManagerCommon(VhdlEditor vEditor, ContentAssistant assistant) {
        this.fEditor = vEditor;
        this.fContentAssistant = assistant;
        this.fIsPartial = false;
    }

    public void addContentAssistProcessor(IContentAssistProcessor processor) {
        this.fProcessors.add(processor);
    }

    public RfFileDef getFileDef() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)file);
    }

    public IRfScope getInitialScope() {
        return this.fInitialScope;
    }

    public static Comparator<? super IRfNamedElement> getContextSorter(String prefix) {
        return R2LUtils.getContextSorter(prefix);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        PositionalTooltipsNamedElementAndOffsetWrapper namedElementAndOffset;
        if (!this.init(viewer, offset)) {
            return null;
        }
        IRfScope scope = this.fInitialScope;
        if (!(this.fInitialScope instanceof RfDefElement)) {
            if (this.fInitialScope instanceof RfNamedElement) {
                scope = ((RfNamedElement)this.fInitialScope).getDeclaration();
            }
            if (!(scope instanceof RfDefElement)) {
                return null;
            }
        }
        if ((namedElementAndOffset = VhdlParameterHintsUtils.getElementNamedElementAtOffset(this.getFile(), this.fEditor, offset, ((RfDefElement)this.fInitialScope).getStartOffset())) == null) {
            return null;
        }
        RfNamedElement element = namedElementAndOffset.getNamedElement();
        String elementName = "";
        String elementArguments = "";
        if (element instanceof RfFunction) {
            Collection<? extends RfDefElement> functionDeclarations = element.getDeclarations();
            if (functionDeclarations != null && functionDeclarations.contains(this.fInitialScope)) {
                return null;
            }
            elementArguments = ((RfFunction)element).getArgs(true, true, false);
            if (elementArguments.isEmpty()) {
                return null;
            }
            elementName = ((RfFunction)element).getName();
        } else if (element instanceof RfInstance) {
            InstancePositionalTooltipType tooltipType = null;
            int identifierOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, InstancePositionalTooltipType.PORTS.getIdentifierString(), element.getOffset(), namedElementAndOffset.getOffset(), false);
            if (identifierOffset >= 0) {
                tooltipType = InstancePositionalTooltipType.PORTS;
            } else {
                identifierOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, InstancePositionalTooltipType.GENERICS.getIdentifierString(), element.getOffset(), namedElementAndOffset.getOffset(), false);
                if (identifierOffset >= 0) {
                    tooltipType = InstancePositionalTooltipType.GENERICS;
                }
            }
            if (identifierOffset < 0 || tooltipType == null) {
                return null;
            }
            elementName = tooltipType.getIdentifierString();
            elementArguments = this.computeInstanceElementArguments((RfInstance)element, tooltipType);
            if (elementArguments == null) {
                return null;
            }
        }
        int contextInformationStartOffset = VhdlParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, false, false);
        if (contextInformationStartOffset < 0) {
            return null;
        }
        int contextInformationEndOffset = VhdlParameterHintsUtils.getContextInformationOffset(this.fDocument, offset, this.fInitialScope, elementName, this.fEditor, true, false) - 1;
        if (contextInformationEndOffset < 0) {
            return null;
        }
        String wrapped = DVTStringUtil.textWrap((int)75, (String)elementArguments).toString();
        String tooltip = DVTStringUtil.breakLongNonWhitespaceSequences((String)wrapped, (int)75, (char)'\n');
        DVTProposalContextInformation contextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, tooltip, tooltip, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__vhdl_partitioning");
        IContextInformation[] contextInformations = new IContextInformation[]{contextInformation};
        return contextInformations;
    }

    protected String computeInstanceElementArguments(RfInstance element, InstancePositionalTooltipType tooltipType) {
        IRfDesignElement designElement = null;
        IRfNamedElement genericDesign = element.getGenericDesign(null);
        if (!(genericDesign instanceof IRfDesignElement)) {
            return null;
        }
        designElement = (IRfDesignElement)genericDesign;
        ArrayList<String> names = new ArrayList<String>();
        switch (tooltipType) {
            case PORTS: {
                if (!element.hasOrderedConnections()) {
                    return null;
                }
                List ports = designElement.getLocalPorts();
                if (ports == null || ports.isEmpty()) {
                    return null;
                }
                for (IRfPortElement port : ports) {
                    names.add(port.getContextInformationSignature());
                }
                break;
            }
            case GENERICS: {
                if (!VhdlPositionalTooltipUtils.getOrderedGenericConnectionsInfo(element, false).hasOrderedGenericConnections()) {
                    return null;
                }
                List parameters = designElement.getLocalParameters();
                if (parameters == null || parameters.isEmpty()) {
                    return null;
                }
                List elabParamValues = VhdlPositionalTooltipUtils.computeElabParamValues((DVTEditor)this.fEditor, (ELManager)element.getRfProject().getELManager(), (IRfNamedElement)element, (List)parameters);
                int i = 0;
                while (i < parameters.size()) {
                    String signature;
                    String value = elabParamValues == null || i >= elabParamValues.size() ? null : (String)elabParamValues.get(i);
                    String string = signature = parameters.get(i) instanceof IRfFieldElement ? VhdlPositionalTooltipUtils.computeSignature((IRfFieldElement)((IRfFieldElement)parameters.get(i)), (String)value) : null;
                    if (signature == null) {
                        return null;
                    }
                    names.add(signature);
                    ++i;
                }
                break;
            }
            default: {
                return null;
            }
        }
        return DVTStringUtil.join(names, (String)", ");
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new VhdlParameterListValidator();
    }

    protected void addProposalsToList(ICompletionProposal[] props, List<ICompletionProposal> results) {
        if (props == null) {
            return;
        }
        Collections.addAll(results, props);
    }

    protected ICompletionProposal[] getProposalArray(List<ICompletionProposal> proposals) {
        ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
        int i = 0;
        while (i < proposals.size()) {
            result[i] = proposals.get(i);
            ++i;
        }
        return result;
    }

    public String getContextType() {
        if (this.fRfScope != null) {
            RfNamedElement namedElement = this.fRfScope.getNamedElement();
            if (namedElement == null) {
                return this.fRfScope.getContextType();
            }
            return namedElement.getContextType();
        }
        return "ro.amiq.vhdldt.templates.contextType.unit";
    }

    public ArrayList<IContentAssistProcessor> getProcessors() {
        return this.fProcessors;
    }

    public IPreferenceStore getPreferenceStore() {
        return VhdlPlugin.getDefault().getPreferenceStore();
    }

    public VhdlEditor getEditor() {
        return this.fEditor;
    }

    public ICompletionProposal getNoProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(viewer, viewer.getDocument(), new R2LNoProposalElement(), "", fOffset, false, null, null, -1, true);
    }

    protected abstract IFile getFile();

    protected abstract boolean init(ITextViewer var1, int var2);

    protected abstract RfProject getProject();
}

