/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlKeywordContentAssistProcessor
implements IContentAssistProcessor {
    private VhdlContentAssistProcessorManager fProcessor;
    private static final Comparator ORDER_COMPARATOR = (o1, o2) -> {
        String icp1 = ((ICompletionProposal)o1).getDisplayString();
        String icp2 = ((ICompletionProposal)o2).getDisplayString();
        return icp1.compareTo(icp2);
    };

    public VhdlKeywordContentAssistProcessor(VhdlContentAssistProcessorManager assistant) {
        this.fProcessor = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String currentWord;
        ArrayList<ICompletionProposal> proposals;
        block5: {
            if (this.fProcessor.getCrtContentAssistPage() == 0 && !this.fProcessor.fIsPartial) {
                return null;
            }
            IDocument document = viewer.getDocument();
            VhdlEditor vhdlEditor = this.fProcessor.getEditor();
            if (vhdlEditor == null) {
                return null;
            }
            try {
                proposals = new ArrayList<ICompletionProposal>();
                currentWord = this.lastWord(document, offset);
                if (currentWord != null && !currentWord.isEmpty()) break block5;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        this.fillProposals(offset, currentWord, proposals);
        ICompletionProposal[] complProposals = new ICompletionProposal[proposals.size()];
        proposals.toArray(complProposals);
        Arrays.sort(complProposals, ORDER_COMPARATOR);
        return complProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "No completions available.";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lastWord(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (true) {
                if (n < -1) {
                    return "";
                }
                if (n == -1) {
                    return doc.get(n + 1, offset - n - 1);
                }
                char ch = doc.getChar(n);
                if (ch == '.') {
                    return null;
                }
                if (!Character.isJavaIdentifierPart(ch)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    private void fillProposals(int offset, String currentWord, ArrayList<ICompletionProposal> list) {
        String[] keywords = PrefConst.getKeywordsPreference();
        HashSet keywordsSet = new HashSet();
        Collections.addAll(keywordsSet, keywords);
        int capitalization = VhdlPlugin.getDefault().getPreferenceStore().getInt("format.capitalization.keywords");
        for (String keyword : keywordsSet) {
            String lowerCaseKeyword = keyword.toLowerCase();
            String lowerCaseCurrentWord = currentWord.toLowerCase();
            if (currentWord.length() != 0 && (!lowerCaseKeyword.startsWith(lowerCaseCurrentWord) || lowerCaseKeyword.equals(lowerCaseCurrentWord))) continue;
            keyword = lowerCaseKeyword;
            switch (capitalization) {
                case 2: {
                    keyword = lowerCaseKeyword.toUpperCase();
                    break;
                }
                case 3: {
                    keyword = lowerCaseKeyword;
                    break;
                }
                case 1: {
                    if (currentWord.isEmpty()) break;
                    char firstChar = currentWord.charAt(0);
                    if (Character.isLowerCase(firstChar)) {
                        keyword = lowerCaseKeyword;
                        break;
                    }
                    if (!Character.isUpperCase(firstChar)) break;
                    keyword = lowerCaseKeyword.toUpperCase();
                    break;
                }
            }
            keyword = String.valueOf(keyword) + " ";
            list.add((ICompletionProposal)new CompletionProposal(keyword, offset - currentWord.length(), currentWord.length(), keyword.length(), DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ), keyword, null, "Keyword"));
        }
    }
}

