/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.contentassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.ui.editor.contentasisst.DVTTemplateContentAssistProcessorManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.templates.TemplateEditorUI;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.contentassist.CustomTemplateProposal;
import ro.amiq.vhdldt.ui.editor.contentassist.VhdlContentAssistProcessorManager;

public class VhdlTemplateContentAssistProcessor
extends DVTTemplateContentAssistProcessorManager {
    public static final String DEFAULT_TEMPLATE_FILE = "/templates/vhdl.xml";

    public VhdlTemplateContentAssistProcessor(VhdlEditor editor, VhdlContentAssistProcessorManager processor) {
        super((DVTContentAssistProcessorManager)processor, (DVTEditor)editor);
    }

    protected File getProjectTemplatesFile() {
        return this.getProjectTemplatesFile("ro.amiq.vhdldt.VhdlNature");
    }

    public Template[] getTemplates(String contextTypeId) {
        return TemplateEditorUI.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return TemplateEditorUI.getDefault().getContextTypeRegistry().getContextType(this.fProcessor.getContextType());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        ITextSelection selection;
        block14: {
            block13: {
                block12: {
                    if (!this.fCA || this.fOffset + 1 != offset) break block12;
                    this.fCA = false;
                    this.fOffset = offset;
                    char c = viewer.getDocument().getChar(Math.max(0, offset - 1));
                    if (Character.isJavaIdentifierPart(c) || c == '`') break block12;
                    return null;
                }
                this.fOffset = offset;
                this.fCA = false;
                selection = this.fProcessor.nonUiGetSelection(viewer);
                if (selection != null && selection.getOffset() == offset) {
                    offset = selection.getOffset() + selection.getLength();
                }
                if ((prefix = this.extractPrefix(viewer, offset)) != null) break block13;
                return null;
            }
            if (this.shouldDisplayTemplates(prefix)) break block14;
            return null;
        }
        try {
            Region region = new Region(offset - prefix.length(), prefix.length());
            TemplateContext context = this.createContext(viewer, (IRegion)region);
            if (context == null) {
                return new ICompletionProposal[0];
            }
            if (selection != null) {
                context.setVariable("selection", selection.getText());
            }
            Template[] templates = this.getTemplates(context.getContextType().getId());
            Template[] projectTemplates = this.getProjectTemplates();
            ArrayList<Template> allTemplates = new ArrayList<Template>();
            allTemplates.addAll(Arrays.asList(projectTemplates));
            allTemplates.addAll(Arrays.asList(templates));
            ArrayList<CustomTemplateProposal> matches = new ArrayList<CustomTemplateProposal>();
            for (Template template : allTemplates) {
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    continue;
                }
                if (!template.matches(prefix, context.getContextType().getId()) && !template.matches(prefix, "ro.amiq.vhdldt.templates.contextType.unknown")) continue;
                CustomTemplateProposal proposal = this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix));
                proposal.firstLetterOfPrefixIsUppercase = !prefix.isEmpty() && Character.isUpperCase(prefix.charAt(0));
                matches.add(proposal);
            }
            Collections.sort(matches, fgProposalComparator);
            boolean ignoreCase = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
            boolean camelCase = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
            boolean prefixMatch = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
            int matchType = 0x20 | (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
            ArrayList<CustomTemplateProposal> proposals = new ArrayList<CustomTemplateProposal>();
            for (CustomTemplateProposal match : matches) {
                String templateName = match.getTemplateName().toLowerCase();
                if (!DVTStringUtil.regionMatches((String)(templateName = templateName.replace(' ', '_')), (String)prefix.toLowerCase(), (int)matchType)) continue;
                proposals.add(match);
            }
            this.fCA = true;
            return proposals.toArray(new ICompletionProposal[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected CustomTemplateProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new CustomTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected IProject getProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return project;
    }
}

