/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.edit.strategy;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vhdldt.ui.editor.edit.strategy.VhdlCodeTokenProcessor;

public class DocumentLineAccessor
implements Cloneable {
    private IDocument document;
    private int startOffset;
    private int line;
    private Deque<VhdlCodeTokenProcessor.Token> buffer;
    private int maxNrLines;
    private int nrLines;
    private int nrIgnoredEmptyLines;

    public DocumentLineAccessor(IDocument document, int startOffset, int linesLookback) {
        this.document = document;
        this.startOffset = startOffset;
        this.line = -1;
        this.maxNrLines = linesLookback;
        this.nrLines = 0;
        this.nrIgnoredEmptyLines = 0;
    }

    private DocumentLineAccessor(IDocument document, int startOffset, int line, Deque<VhdlCodeTokenProcessor.Token> buffer, int maxNrLines, int nrLines, int nrIgnoredEmptyLines) {
        this.document = document;
        this.startOffset = startOffset;
        this.line = line;
        this.buffer = buffer;
        this.maxNrLines = maxNrLines;
        this.nrLines = nrLines;
        this.nrIgnoredEmptyLines = nrIgnoredEmptyLines;
    }

    public VhdlCodeTokenProcessor.Token nextToken() {
        block3: {
            try {
                if (this.fillBuffer()) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.buffer.pollLast();
    }

    private void initBuffer() {
        try {
            this.line = this.document.getLineOfOffset(this.startOffset);
            this.consumeLine(this.document.getLineOffset(this.line), this.startOffset);
        }
        catch (BadLocationException badLocationException) {}
    }

    private boolean fillBuffer() throws BadLocationException {
        if (this.buffer == null) {
            this.initBuffer();
        }
        while (this.buffer.isEmpty() && this.line >= 0) {
            if (this.nrLines == this.maxNrLines) {
                return false;
            }
            int start = this.document.getLineOffset(this.line);
            int end = start + this.document.getLineLength(this.line) - 1;
            this.consumeLine(start, end);
        }
        return true;
    }

    private void consumeLine(int start, int end) throws BadLocationException {
        String lineText = this.document.get(start, end - start);
        this.buffer = VhdlCodeTokenProcessor.getTokensFromString(this.document, start, lineText);
        --this.line;
        if (this.buffer.isEmpty() && this.nrIgnoredEmptyLines > 0) {
            --this.nrIgnoredEmptyLines;
            return;
        }
        ++this.nrLines;
    }

    public int getLine() {
        return this.line + 1;
    }

    private Deque<VhdlCodeTokenProcessor.Token> getBuffer() {
        return this.buffer;
    }

    private IDocument getDocument() {
        return this.document;
    }

    private int getStartOffset() {
        return this.startOffset;
    }

    public int getMaxNrLines() {
        return this.maxNrLines;
    }

    public void setMaxNrLines(int maxNrLines) {
        this.maxNrLines = maxNrLines;
    }

    public int getNrLines() {
        return this.nrLines;
    }

    public int getNrIgnoredEmptyLines() {
        return this.nrIgnoredEmptyLines;
    }

    public void setNrIgnoredEmptyLines(int nrIgnoredEmptyLines) {
        this.nrIgnoredEmptyLines = nrIgnoredEmptyLines;
    }

    public DocumentLineAccessor clone() {
        return new DocumentLineAccessor(this.document, this.startOffset, this.line, (Deque<VhdlCodeTokenProcessor.Token>)(this.buffer == null ? null : ((ArrayDeque)this.buffer).clone()), this.maxNrLines, this.nrLines, this.nrIgnoredEmptyLines);
    }

    public void resetTo(DocumentLineAccessor acc) {
        if (acc == null) {
            return;
        }
        this.document = acc.getDocument();
        this.startOffset = acc.getStartOffset();
        this.line = acc.getLine() - 1;
        this.buffer = acc.getBuffer();
        this.maxNrLines = acc.getMaxNrLines();
        this.nrLines = acc.getNrLines();
    }

    public void consumeRegion(IDocument document, int regionStartOffset) {
        this.document = document;
        this.startOffset = regionStartOffset;
        try {
            int regionNrLinesConsumed = this.getLine() - document.getLineOfOffset(regionStartOffset) - 1;
            this.nrLines += regionNrLinesConsumed;
        }
        catch (BadLocationException badLocationException) {
            this.nrLines = 0;
        }
        this.nrIgnoredEmptyLines = 0;
        this.initBuffer();
    }
}

