/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.edit.strategy;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.edit.strategy.VhdlCodeAutoEditStrategyCommon;

public class VhdlCodeAutoEditStrategy
extends VhdlCodeAutoEditStrategyCommon {
    public VhdlCodeAutoEditStrategy(ISourceViewer sourceViewer, VhdlSourceViewerConfiguration configuration) {
        super(sourceViewer, configuration);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.transformText(document, command);
        this.autoIndent(document, command);
        this.autoInsertAndEncloseBrackets(document, command);
    }

    private void autoIndent(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        if (CFUtils.getInstance().shouldFormatOnPaste(command.text)) {
            return;
        }
        if (VhdlPlugin.getDefault().getPreferenceStore().getBoolean("autoindent.disabled")) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        if (command.length != 0 || command.text == null) {
            return;
        }
        if (this.isLiteralPartition(document, command.offset) && command.offset > 0 && this.isLiteralPartition(document, command.offset - 1)) {
            return;
        }
        this.TAB_SIZE = this.fConfiguration.getTabWidth(this.fSourceViewer);
        this.fUseSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)VhdlPlugin.getDefault().getCombinedPreferenceStore());
        boolean insertTabChar = command.text.equals("\t");
        boolean commandModified = false;
        DVTDocumentCommon.RecoveryCommand rc = new DVTDocumentCommon.RecoveryCommand();
        rc.loadFrom(command);
        long start = System.currentTimeMillis();
        try {
            boolean precededByWhitespaces;
            int offset = command.offset;
            if (offset < 0 || offset > document.getLength()) {
                return;
            }
            if (document.getLineInformation(document.getLineOfOffset(offset)).getLength() == 0 && !insertTabChar) {
                return;
            }
            String delimiter = this.getEndDelimiter(document, command);
            if ((this.typeOfDelimiter(AMBIGUOUS_KEYWORDS, delimiter) || this.typeOfDelimiter(END_KEYWORD, delimiter)) && this.whitespacesBeforeDelimiter(document, command, delimiter) && TextUtils.isFollowedByWhitespaces((IDocument)document, (int)offset)) {
                commandModified = this.smartIndentAfterEnd(document, command, delimiter);
            }
            if (this.endsWithNewLine(document, command.text)) {
                this.smartIndentAfterNewLine(document, command, commandModified, offset);
            } else if (insertTabChar && !commandModified && (precededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset)) && Character.isWhitespace(TextUtils.getChar((IDocument)document, (int)offset))) {
                this.smartIndentAfterTab(document, command);
            }
            TestHelper.getInstance().fAutoIndentTime = (double)System.currentTimeMillis() - (double)start;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            rc.saveIn(command);
        }
    }

    private String encloseWithQuote(IDocument d, DocumentCommand command) {
        String enclosedTextResult = "";
        int escapeNumber = 0;
        if (this.isLiteralPartition(d, command.offset) && TextUtils.getChar((IDocument)d, (int)command.offset) != '\"') {
            enclosedTextResult = String.valueOf(enclosedTextResult) + "\"";
        }
        int i = 0;
        while (i < command.length) {
            enclosedTextResult = TextUtils.getChar((IDocument)d, (int)(command.offset + i)) == '\"' ? ((escapeNumber = this.countEscapeNumber(d, command, i)) == 0 || escapeNumber % 2 == 0 ? String.valueOf(enclosedTextResult) + "\\\"" : String.valueOf(enclosedTextResult) + TextUtils.getChar((IDocument)d, (int)(command.offset + i))) : String.valueOf(enclosedTextResult) + TextUtils.getChar((IDocument)d, (int)(command.offset + i));
            ++i;
        }
        if (this.isLiteralPartition(d, command.offset + command.length - 1) && TextUtils.getChar((IDocument)d, (int)(command.offset + command.length - 1)) != '\"') {
            enclosedTextResult = String.valueOf(enclosedTextResult) + "\"";
        }
        return enclosedTextResult;
    }

    private String computeEnclosedText(String bracket, IDocument d, DocumentCommand command) {
        String enclosedTextResult = bracket;
        if (bracket.equals("\"")) {
            enclosedTextResult = String.valueOf(enclosedTextResult) + this.encloseWithQuote(d, command);
        } else {
            int i = 0;
            while (i < command.length) {
                enclosedTextResult = String.valueOf(enclosedTextResult) + TextUtils.getChar((IDocument)d, (int)(command.offset + i));
                ++i;
            }
        }
        return this.encloseWithBracket(bracket, enclosedTextResult);
    }

    private String encloseWithBracket(String bracket, String text) {
        if ("(".equals(bracket)) {
            text = String.valueOf(text) + ")";
        } else if ("[".equals(bracket)) {
            text = String.valueOf(text) + "]";
        } else if ("{".equals(bracket)) {
            text = String.valueOf(text) + "}";
        } else if ("\"".equals(bracket)) {
            text = String.valueOf(text) + "\"";
        }
        return text;
    }

    private boolean autoEncloseWithBrackets(IDocument document, DocumentCommand command) {
        boolean isEnabledEncloseText = this.getPreferenceForAutoEnclose(command.text);
        if (!isEnabledEncloseText || "".equals(this.encloseWithBracket(command.text, ""))) {
            return false;
        }
        command.text = this.computeEnclosedText(command.text, document, command);
        return true;
    }

    private void autoAddNewLine(char ch, char beforeCh, char afterCh, IDocument document, DocumentCommand command) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(command.text);
        if (!isEnabledAutoInsert) {
            return;
        }
        if (ch == '}' && beforeCh == '{' && this.getPreferenceForAutoInsert("{") && afterCh != '}') {
            try {
                int commandLine = document.getLineOfOffset(command.offset);
                String text = document.get(document.getLineOffset(commandLine), command.offset - document.getLineOffset(commandLine));
                String indentText = TemplatesViewUtils.determineOffsetIndentExclusive((String)text);
                String tabOrSpace = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE);
                String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.fConfiguration != null ? this.fConfiguration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
                String replaceString = String.valueOf(lineSeparator) + tabOrSpace + indentText + lineSeparator + indentText + "}";
                document.replace(command.offset, 1, replaceString);
                command.caretOffset = command.offset + indentText.length() + tabOrSpace.length() + lineSeparator.length();
                command.text = "";
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private void autoInsertAndEncloseBrackets(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = TextUtils.getChar((IDocument)document, (int)command.offset);
        char beforeCh = TextUtils.getChar((IDocument)document, (int)(command.offset - 1));
        char afterCh = TextUtils.getChar((IDocument)document, (int)(command.offset + 1));
        this.initAutoInsert(beforeCh, ch, command);
        if (!(command.length == 0 && this.autoInsertPair(ch, document, command) || command.length > 0 && this.autoEncloseWithBrackets(document, command))) {
            if (DVTDocumentCommon.isTextNewLine((IDocument)document, (String)command.text)) {
                this.autoAddNewLine(ch, beforeCh, afterCh, document, command);
            } else {
                this.smartResetCountOpen(command.offset);
            }
        }
    }

    protected int getPreviousLineForIndent(IDocument document, int currentLine) {
        int prevLine = currentLine;
        try {
            while (--prevLine >= 0) {
                int startPrev = document.getLineOffset(prevLine);
                int endIndentPrev = this.findEndOfWhiteSpace(document, startPrev, startPrev + document.getLineLength(prevLine));
                if (TextUtils.isFollowedByWhitespaces((IDocument)document, (int)startPrev) || !this.isCodePartition(document, endIndentPrev)) continue;
                break;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return prevLine > 0 ? prevLine : currentLine;
    }

    protected void smartIndentAfterTab(IDocument document, DocumentCommand command) {
        if (document == null) {
            return;
        }
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int offset = command.offset;
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int end = this.findEndOfWhiteSpace(document, offset, start + document.getLineLength(line));
            String after = document.get(offset, document.getLineLength(line) - offset + start).toLowerCase().trim();
            String nextToken = this.startsWithDelimiter(after, ALL_END_KEYWORDS);
            StringBuilder buffer = new StringBuilder();
            if (!nextToken.isEmpty()) {
                int indLine = 0;
                indLine = this.findMatchingOpenDelimiter(document, line, nextToken);
                if (indLine == -1) {
                    indLine = line;
                }
                buffer.append(this.indentForDelimiter(document, indLine, line, nextToken));
            } else {
                boolean positiveIndentation;
                int prevLine = this.getPreviousLineForIndent(document, line);
                int startPrev = document.getLineOffset(prevLine);
                int endPrev = startPrev + document.getLineLength(prevLine);
                int indLine = this.isPositiveIndentation(document, prevLine);
                boolean bl = positiveIndentation = indLine == prevLine;
                if (positiveIndentation && (this.getDelimiterCount(document, startPrev, endPrev, ALL_INDENT_KEYWORDS).getIndentationCount() > 0 || DVTDocumentCommon.isNextCharacter((IDocument)document, (int)startPrev, (char)'{') != -1 || DVTDocumentCommon.isNextCharacter((IDocument)document, (int)startPrev, (char)'(') != -1) && prevLine != line) {
                    buffer.append(TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE));
                }
                String indent = DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)-1);
                if (this.fUseSpacesNotTabs) {
                    indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.TAB_SIZE);
                }
                buffer.append(indent);
                if (TextUtils.emptyTabLineIndent((IDocument)document, (int)offset, (String)indent, (String)document.get(start, Math.max(offset - start, 0)), (int)this.TAB_SIZE)) {
                    return;
                }
            }
            command.text = buffer.toString();
            command.length = end - start;
            command.offset = start;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected boolean whitespacesBeforeDelimiter(IDocument document, DocumentCommand command, String delimiter) throws BadLocationException {
        if (document == null || command == null || delimiter == null) {
            return false;
        }
        int offset = command.offset;
        int line = document.getLineOfOffset(offset);
        int start = document.getLineOffset(line);
        int end = Math.min(start + document.getLineLength(line), offset);
        String strLine = this.getLineTextwithCommand(document, command);
        if (strLine == null) {
            return false;
        }
        int index = this.hasDelimiter(new String[]{delimiter}, strLine);
        if (index < 0) {
            return false;
        }
        return this.findEndOfWhiteSpace(document, start, end) == start + index;
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset) {
        if (document == null) {
            return;
        }
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            String[] openKeywords;
            int indLine;
            int line = document.getLineOfOffset(offset);
            StringBuilder buffer = new StringBuilder(command.text);
            int start = document.getLineOffset(line);
            boolean hasAmbiguousDelimiter = false;
            if (commandModified) {
                hasAmbiguousDelimiter = this.hasDelimiter(AMBIGUOUS_KEYWORDS, command.text) > -1;
            }
            boolean positiveIndentation = (indLine = this.isPositiveIndentation(document, line)) == line;
            String indent = "";
            if (positiveIndentation && (this.getDelimiterCount(document, start, offset, openKeywords = ALL_INDENT_KEYWORDS).getIndentationCount() > 0 || hasAmbiguousDelimiter)) {
                buffer.append(TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE));
            }
            indent = !commandModified ? DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)(positiveIndentation ? offset : -1)) : TemplatesViewUtils.determineOffsetIndentExclusive((String)command.text);
            if (this.fUseSpacesNotTabs) {
                indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.TAB_SIZE);
            }
            buffer.append(indent);
            command.text = buffer.toString();
            IRegion lineInfo = document.getLineInformation(line);
            if (lineInfo == null) {
                return;
            }
            if (TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset) && !TextUtils.isFollowedByWhitespaces((IDocument)document, (int)offset)) {
                return;
            }
            command.length += Math.max(0, DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)offset, (int)(lineInfo.getOffset() + lineInfo.getLength())) - offset);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected boolean smartIndentAfterEnd(IDocument document, DocumentCommand command, String delimiter) {
        if (document == null || command.offset == -1 || document.getLength() == 0 || delimiter == null) {
            return false;
        }
        try {
            int offset = command.offset;
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, offset);
            StringBuilder buffer = new StringBuilder();
            int indLine = this.findMatchingOpenDelimiter(document, line, delimiter);
            if (indLine == -1) {
                indLine = line;
            }
            buffer.append(this.indentForDelimiter(document, indLine, line, delimiter));
            String rest = document.get(whiteend, offset - whiteend);
            if (this.fUseSpacesNotTabs) {
                rest = TextUtils.replaceTabsWithSpaces((String)rest, (int)this.TAB_SIZE);
            }
            buffer.append(rest);
            buffer.append(command.text);
            command.length = Math.max(0, offset - start);
            command.offset = start;
            command.text = buffer.toString();
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

