/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.edit.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;

public class VhdlCodeAutoEditStrategyCommon
extends DefaultIndentLineAutoEditStrategy {
    protected int TAB_SIZE = 4;
    protected boolean fUseSpacesNotTabs;
    protected VhdlSourceViewerConfiguration fConfiguration;
    protected ISourceViewer fSourceViewer;
    private static int PAREN_OFFSET = 0;
    private static int BRACK_OFFSET = 1;
    private static int CURLY_OFFSET = 2;
    private static int QUOTE_OFFSET = 3;
    private static int NR_AUTOINSERT_CHARACTERS = 4;
    private int[] fLastInsertedOffsets = new int[NR_AUTOINSERT_CHARACTERS];
    private int[] fFirstInsertedOffsets = new int[NR_AUTOINSERT_CHARACTERS];
    private int[] countOpen = new int[NR_AUTOINSERT_CHARACTERS];
    private char fPreviousChar;
    private char fPrePreviousChar;
    private Map<String, List<Long>> fCharTimestampMap = new HashMap<String, List<Long>>();
    private static final String[] OPEN_KEYWORDS = new String[]{"process", "if", "entity", "architecture", "package", "block", "component", "configuration", "for", "loop", "function", "procedure", "context", "protected", "record", "case", "units", "procedural"};
    protected static final String[] ALL_INDENT_KEYWORDS = new String[]{"else", "elsif", "when", "begin", "process", "if", "package", "block", "component", "configuration", "for", "entity", "architecture", "loop", "function", "procedure", "port", "context", "map", "protected", "record", "case", "units", "procedural"};
    private static final String[] ALL_KEYWORDS = new String[]{"end", "else", "elsif", "when", "begin", "process", "if", "package", "block", "component", "configuration", "is", "for", "entity", "architecture", "loop", "function", "procedure", "port", "context", "map", "protected", "record", "case", "units", "procedural"};
    protected static final String[] AMBIGUOUS_KEYWORDS = new String[]{"else", "elsif", "when", "begin"};
    protected static final String[] END_KEYWORD = new String[]{"end"};
    protected static final String[] ALL_END_KEYWORDS = new String[]{"end", "else", "elsif", "when", "begin"};
    private static final Map<String, String[]> MATCHING_DELIMITER = new HashMap<String, String[]>();
    private static final List<String> OPEN_DELIMITER_SETS;
    private static final List<String> INDENTED_AMBIGUOUS_DELIMITERS;
    private static final int TIME_THRESHOLD = 250;
    static final Pattern PACKAGE_INSTANTIATION_PATTERN;

    static {
        MATCHING_DELIMITER.put("else", new String[]{"if"});
        MATCHING_DELIMITER.put("elsif", new String[]{"if"});
        MATCHING_DELIMITER.put("when", new String[]{"case"});
        MATCHING_DELIMITER.put("begin", OPEN_KEYWORDS);
        OPEN_DELIMITER_SETS = new ArrayList<String>();
        OPEN_DELIMITER_SETS.add("forloop");
        OPEN_DELIMITER_SETS.add("whileloop");
        OPEN_DELIMITER_SETS.add("whenelse");
        OPEN_DELIMITER_SETS.add("portmap");
        OPEN_DELIMITER_SETS.add("genericmap");
        OPEN_DELIMITER_SETS.add("entityport");
        OPEN_DELIMITER_SETS.add("forentity");
        INDENTED_AMBIGUOUS_DELIMITERS = new ArrayList<String>();
        INDENTED_AMBIGUOUS_DELIMITERS.add("when");
        PACKAGE_INSTANTIATION_PATTERN = Pattern.compile("package(\\s+)(\\S+)(\\s+)is(\\s+)new(\\b)");
    }

    public VhdlCodeAutoEditStrategyCommon(ISourceViewer sourceViewer, VhdlSourceViewerConfiguration configuration) {
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.resetInsertedOffsets();
        this.resetCountOpen();
    }

    protected int hasDelimiter(String[] delimiters, String buffer) {
        if (delimiters == null || buffer == null) {
            return -1;
        }
        int index = -1;
        int i = 0;
        while (i < delimiters.length) {
            index = this.getDelimiterIndex(buffer, delimiters[i]);
            if (index > -1) {
                return index;
            }
            ++i;
        }
        return -1;
    }

    private void commandShiftCaret(DocumentCommand command) {
        command.shiftsCaret = false;
        command.caretOffset = command.offset + 1;
    }

    protected boolean getPreferenceForAutoInsert(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.paran_case");
            }
            case '[': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.brack_case");
            }
            case '{': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.curly_case");
            }
            case '\"': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.quote_case");
            }
        }
        return true;
    }

    protected boolean getPreferenceForAutoEnclose(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.paran_case");
            }
            case '[': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.brack_case");
            }
            case '{': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.curly_case");
            }
            case '\"': {
                return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.quote_case");
            }
        }
        return true;
    }

    protected boolean isLiteralPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__vhdl_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__vhdl_literal");
    }

    private void resetInsertedOffsets() {
        int i = 0;
        while (i < NR_AUTOINSERT_CHARACTERS) {
            this.fLastInsertedOffsets[i] = -1;
            this.fFirstInsertedOffsets[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    private void resetCountOpen() {
        int i = 0;
        while (i < NR_AUTOINSERT_CHARACTERS) {
            this.countOpen[i] = 0;
            ++i;
        }
    }

    protected void smartResetCountOpen(int offset) {
        int i = 0;
        while (i < NR_AUTOINSERT_CHARACTERS) {
            if (offset < this.fFirstInsertedOffsets[i] || offset > this.fLastInsertedOffsets[i]) {
                this.countOpen[i] = 0;
            }
            ++i;
        }
    }

    private int getBracketType(char bracket) {
        switch (bracket) {
            case '(': 
            case ')': {
                return PAREN_OFFSET;
            }
            case '[': 
            case ']': {
                return BRACK_OFFSET;
            }
            case '{': 
            case '}': {
                return CURLY_OFFSET;
            }
            case '\"': {
                return QUOTE_OFFSET;
            }
        }
        return -1;
    }

    private boolean conditionCloseAutoInsertBracket(char bracket, char afterChar, DocumentCommand command) {
        if (command == null || command.text == null) {
            return false;
        }
        int type = this.getBracketType(bracket);
        if (type == -1) {
            return false;
        }
        return command.text.equals(Character.toString(bracket)) && this.fLastInsertedOffsets[type] == command.offset + 1 && afterChar == bracket && this.countOpen[type] > 0;
    }

    private boolean conditionOpenAutoInsertBracket(char bracket, IDocument d, DocumentCommand command) {
        if (command == null || command.text == null || d == null) {
            return false;
        }
        boolean isFollowedByWhitespace = DVTDocumentCommon.isNotFollowedByIdentifier((IDocument)d, (int)command.offset);
        return command.text.equals(Character.toString(bracket)) && isFollowedByWhitespace && !this.isLiteralPartition(d, command.offset);
    }

    protected int countEscapeNumber(IDocument d, DocumentCommand command, int index) {
        int count = 0;
        int i = index - 1;
        while (i >= 0) {
            if (TextUtils.getChar((IDocument)d, (int)(command.offset + i)) != '\\') break;
            ++count;
            --i;
        }
        return count;
    }

    protected void initAutoInsert(char beforeChar, char afterChar, DocumentCommand command) {
        if (beforeChar == '(' && afterChar == ')') {
            this.fLastInsertedOffsets[VhdlCodeAutoEditStrategyCommon.PAREN_OFFSET] = command.offset;
        }
        if (beforeChar == '[' && afterChar == ']') {
            this.fLastInsertedOffsets[VhdlCodeAutoEditStrategyCommon.BRACK_OFFSET] = command.offset;
        }
        if (beforeChar == '{' && afterChar == '}') {
            this.fLastInsertedOffsets[VhdlCodeAutoEditStrategyCommon.CURLY_OFFSET] = command.offset;
        }
        if (beforeChar == '\"' && afterChar == '\"') {
            this.fLastInsertedOffsets[VhdlCodeAutoEditStrategyCommon.QUOTE_OFFSET] = command.offset;
        }
        int i = 0;
        while (i < NR_AUTOINSERT_CHARACTERS) {
            if (this.countOpen[i] > 0) {
                int n = i;
                this.fLastInsertedOffsets[n] = this.fLastInsertedOffsets[n] + command.text.length();
            }
            ++i;
        }
    }

    protected boolean autoInsertPair(char ch, IDocument document, DocumentCommand command) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(command.text);
        if (!isEnabledAutoInsert) {
            return false;
        }
        boolean result = true;
        if (this.conditionCloseAutoInsertBracket(')', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            int n = PAREN_OFFSET;
            this.countOpen[n] = this.countOpen[n] - 1;
        } else if (this.conditionOpenAutoInsertBracket('(', document, command)) {
            this.commandShiftCaret(command);
            command.text = "()";
            int n = PAREN_OFFSET;
            this.countOpen[n] = this.countOpen[n] + 1;
            this.fFirstInsertedOffsets[VhdlCodeAutoEditStrategyCommon.PAREN_OFFSET] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket(']', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            int n = BRACK_OFFSET;
            this.countOpen[n] = this.countOpen[n] - 1;
        } else if (this.conditionOpenAutoInsertBracket('[', document, command)) {
            this.commandShiftCaret(command);
            command.text = "[]";
            int n = BRACK_OFFSET;
            this.countOpen[n] = this.countOpen[n] + 1;
            this.fFirstInsertedOffsets[VhdlCodeAutoEditStrategyCommon.BRACK_OFFSET] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket('}', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            int n = CURLY_OFFSET;
            this.countOpen[n] = this.countOpen[n] - 1;
        } else if (this.conditionOpenAutoInsertBracket('{', document, command)) {
            this.commandShiftCaret(command);
            command.text = "{}";
            int n = CURLY_OFFSET;
            this.countOpen[n] = this.countOpen[n] + 1;
            this.fFirstInsertedOffsets[VhdlCodeAutoEditStrategyCommon.CURLY_OFFSET] = command.offset;
        } else if (this.conditionCloseAutoInsertBracket('\"', ch, command)) {
            this.commandShiftCaret(command);
            command.text = "";
            int n = QUOTE_OFFSET;
            this.countOpen[n] = this.countOpen[n] - 1;
        } else if (this.conditionOpenAutoInsertBracket('\"', document, command)) {
            this.commandShiftCaret(command);
            command.text = "\"\"";
            int n = QUOTE_OFFSET;
            this.countOpen[n] = this.countOpen[n] + 1;
            this.fFirstInsertedOffsets[VhdlCodeAutoEditStrategyCommon.QUOTE_OFFSET] = command.offset;
        } else {
            result = false;
        }
        return result;
    }

    public void transformText(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = '\u0000';
        if (command.text.length() == 1) {
            ch = command.text.charAt(0);
        }
        long currentTimestamp = System.currentTimeMillis();
        boolean useWhitespace = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_whitespace");
        switch (ch) {
            case '.': {
                if (!VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_dot_dot_to_assign")) break;
                if (this.fPreviousChar == '.' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) < 250L) {
                    --command.offset;
                    command.text = useWhitespace ? " => " : "=>";
                    command.length = 1;
                    this.fCharTimestampMap.put(".", Arrays.asList(0L));
                    break;
                }
                this.fCharTimestampMap.put(".", Arrays.asList(currentTimestamp));
                break;
            }
            case ',': {
                if (!VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_comma_comma_to_assign")) break;
                if (this.fPreviousChar == ',' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) < 250L) {
                    --command.offset;
                    command.text = useWhitespace ? " <= " : "<=";
                    command.length = 1;
                    this.fCharTimestampMap.put(",", Arrays.asList(0L));
                    break;
                }
                this.fCharTimestampMap.put(",", Arrays.asList(currentTimestamp));
                break;
            }
            case ';': {
                if (!VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_semicolon_to_assign")) break;
                if (this.fPreviousChar == ';' && this.fPrePreviousChar == ';' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) + (this.fCharTimestampMap.get(String.valueOf(ch)).get(0) - this.fCharTimestampMap.get(String.valueOf(ch)).get(1)) < 500L) {
                    command.offset -= 2;
                    command.text = useWhitespace ? " := " : ":=";
                    command.length = 2;
                    this.fCharTimestampMap.put(";", Arrays.asList(0L, 0L));
                    break;
                }
                if (this.fPreviousChar == ';') {
                    Long previousTimestamp = this.fCharTimestampMap.get(String.valueOf(ch)).get(0);
                    this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp, previousTimestamp));
                    break;
                }
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp));
                break;
            }
        }
        this.fPrePreviousChar = this.fPreviousChar;
        this.fPreviousChar = ch;
    }

    protected boolean endsWithNewLine(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containedInArray(List<String> delimiters, String[] matching) {
        if (delimiters == null || matching == null) {
            return false;
        }
        int i = 0;
        while (i < matching.length) {
            if (delimiters.contains(matching[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean typeOfDelimiter(String[] type, String delimiter) {
        if (type == null || delimiter == null) {
            return false;
        }
        int i = 0;
        while (i < type.length) {
            if (type[i].toLowerCase().equals(delimiter.toLowerCase().trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int findMatchingOpenDelimiter(IDocument document, int line, String delimiter) throws Exception {
        if (document == null || delimiter == null) {
            return -1;
        }
        int count = -1;
        int add = 0;
        String[] openKeywords = OPEN_KEYWORDS;
        DelimitersInfo di = new DelimitersInfo(0, null);
        while (count < 0) {
            if (--line < 0) {
                return -1;
            }
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            di = this.getDelimiterCount(document, start, end, openKeywords);
            add = di.getIndentationCount();
            count += add;
        }
        if (this.typeOfDelimiter(AMBIGUOUS_KEYWORDS, delimiter)) {
            if (this.containedInArray(di.getUnpairedOpenDelimiters(), MATCHING_DELIMITER.get(delimiter))) {
                return line;
            }
            return -1;
        }
        return line;
    }

    private boolean ignoreOpenDelimiter(IDocument document, List<String> openDelimitersFound, String delimiter, String buffer, int begin) {
        boolean ignoreDelimitersFromSet = this.caseIgnoreDelimitersFromSet(openDelimitersFound, delimiter);
        boolean ignoreInstantiationsAndAspects = this.caseIgnoreInstantionsAndAspects(document, buffer, begin);
        return ignoreDelimitersFromSet || ignoreInstantiationsAndAspects;
    }

    private boolean caseIgnoreDelimitersFromSet(List<String> openDelimitersFound, String delimiter) {
        int index = -1;
        String openSet = null;
        if (openDelimitersFound == null || delimiter == null) {
            return true;
        }
        if (openDelimitersFound.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < OPEN_DELIMITER_SETS.size()) {
            openSet = OPEN_DELIMITER_SETS.get(i);
            if (openSet.indexOf(delimiter) > -1) {
                int j = 0;
                while (j < openDelimitersFound.size()) {
                    index = openSet.indexOf(openDelimitersFound.get(j));
                    if (index > -1 && !openSet.startsWith(delimiter, index)) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean caseIgnoreInstantionsAndAspects(IDocument document, String buffer, int begin) {
        if (buffer == null || document == null) {
            return false;
        }
        String entityKeyword = "entity";
        String configurationKeyword = "configuration";
        String componentKeyword = "component";
        String useKeyword = "use";
        String packageKeyword = "package";
        boolean isEntityKeyword = buffer.endsWith(entityKeyword);
        boolean isConfigurationKeyword = buffer.endsWith(configurationKeyword);
        boolean isComponentKeyword = buffer.endsWith(componentKeyword);
        boolean isPackageKeyword = buffer.endsWith(packageKeyword);
        if (isEntityKeyword || isConfigurationKeyword || isComponentKeyword) {
            String keyword = isEntityKeyword ? entityKeyword : (isConfigurationKeyword ? configurationKeyword : componentKeyword);
            int backingOffset = begin - keyword.length() - 1;
            try {
                StringBuilder trail = new StringBuilder();
                while (backingOffset >= 0) {
                    if (!this.isCodePartition(document, backingOffset)) {
                        --backingOffset;
                        continue;
                    }
                    char c = document.getChar(backingOffset);
                    --backingOffset;
                    if (Character.isWhitespace(c)) continue;
                    trail.insert(0, c);
                    if (trail.length() == 1 && trail.charAt(0) == ':') {
                        return backingOffset > 0 ? Character.isWhitespace(document.getChar(backingOffset)) : true;
                    }
                    if (trail.toString().equals(useKeyword) && (isEntityKeyword || isConfigurationKeyword)) {
                        return backingOffset > 0 ? Character.isWhitespace(document.getChar(backingOffset)) : true;
                    }
                    if (trail.length() <= 3) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        if (isPackageKeyword) {
            int start = begin - buffer.length() - 1;
            int end = Math.min(document.getLength(), start + 100);
            try {
                String text = document.get(start, end - begin);
                Matcher matcher = PACKAGE_INSTANTIATION_PATTERN.matcher(text);
                if (matcher.find()) {
                    return true;
                }
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        return false;
    }

    private int parenthesesCount(String text) {
        int paranCount = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '(') {
                ++paranCount;
            }
            if (text.charAt(i) == ')') {
                --paranCount;
            }
            ++i;
        }
        return paranCount;
    }

    private boolean fakeCaseForEndDelimiterIndent(IDocument document, List<String> openDelimitersFound, StringBuilder buffer) {
        if (document == null || openDelimitersFound == null || buffer == null) {
            return true;
        }
        if ((openDelimitersFound.contains("function") || openDelimitersFound.contains("procedure") || openDelimitersFound.contains("generic") || openDelimitersFound.contains("port")) && this.parenthesesCount(buffer.toString()) > 0) {
            return true;
        }
        return openDelimitersFound.contains("for") && (buffer.indexOf("use") > -1 || (buffer.indexOf("generic") > -1 || buffer.indexOf("port") > -1) && buffer.indexOf("map") > -1);
    }

    /*
     * Unable to fully structure code
     */
    protected DelimitersInfo getDelimiterCount(IDocument document, int start, int end, String[] openKeywords) throws Exception {
        if (document == null || start == end) {
            return new DelimitersInfo(0, null);
        }
        begin = start;
        pairDelimiters = 0;
        prevOpen = false;
        prevClose = false;
        index = -1;
        token = null;
        openDelimitersFound = new ArrayList<String>();
        closeKeywords = VhdlCodeAutoEditStrategyCommon.END_KEYWORD;
        buffer = new StringBuilder();
        while (begin < end && begin > -1) {
            block15: {
                block13: {
                    block14: {
                        curr = '\u0000';
                        if (begin < document.getLength()) {
                            curr = document.getChar(begin);
                        }
                        if (!this.isCodePartition(document, ++begin)) continue;
                        if (curr == '\n' || curr == '\r') break;
                        buffer.append(curr);
                        if (curr == ';') {
                            if (this.fakeCaseForEndDelimiterIndent(document, openDelimitersFound, buffer)) {
                                buffer.deleteCharAt(buffer.length() - 1);
                                continue;
                            }
                            if (prevOpen || prevClose) {
                                --pairDelimiters;
                                if (prevOpen && prevClose) {
                                    --pairDelimiters;
                                }
                                prevClose = false;
                                prevOpen = false;
                                if (openDelimitersFound.size() > 0) {
                                    openDelimitersFound.remove(openDelimitersFound.size() - 1);
                                }
                            }
                            buffer.deleteCharAt(buffer.length() - 1);
                        }
                        index = -1;
                        index = this.hasDelimiter(openKeywords, buffer.toString());
                        if (index <= -1) break block13;
                        v0 = begin < end ? !Character.isJavaIdentifierPart(document.getChar(begin)) : (afterCh = true);
                        if (!afterCh) ** GOTO lbl51
                        token = buffer.substring(index, buffer.length()).toLowerCase();
                        if (this.ignoreOpenDelimiter(document, openDelimitersFound, token, buffer.toString(), begin)) break block14;
                        ++pairDelimiters;
                        prevOpen = true;
                        openDelimitersFound.add(buffer.substring(index, buffer.length()).toLowerCase());
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            buffer.append(document.getChar(begin));
                            ++begin;
lbl51:
                            // 2 sources

                            ** while (begin < end && Character.isJavaIdentifierPart((char)document.getChar((int)begin)))
                        }
                    }
                    buffer = buffer.replace(index, buffer.length(), "");
                }
                index = -1;
                index = this.hasDelimiter(closeKeywords, buffer.toString());
                if (index <= -1) continue;
                v1 = begin < end ? !Character.isJavaIdentifierPart(document.getChar(begin)) : (afterCh = true);
                if (!afterCh) ** GOTO lbl65
                prevClose = true;
                break block15;
lbl-1000:
                // 1 sources

                {
                    buffer.append(document.getChar(begin));
                    ++begin;
lbl65:
                    // 2 sources

                    ** while (begin < end && Character.isJavaIdentifierPart((char)document.getChar((int)begin)))
                }
            }
            buffer = buffer.replace(index, buffer.length(), "");
        }
        return new DelimitersInfo(pairDelimiters, openDelimitersFound);
    }

    protected String getLineTextwithCommand(IDocument document, DocumentCommand c) throws BadLocationException {
        if (document == null || c == null) {
            return null;
        }
        int offset = c.offset;
        int line = document.getLineOfOffset(offset);
        int start = document.getLineOffset(line);
        int end = Math.min(start + document.getLineLength(line), offset);
        return (String.valueOf(document.get(start, end - start)) + c.text).toLowerCase();
    }

    private int getDelimiterIndex(String strLine, String delimiter) {
        int index;
        if (delimiter == null || strLine == null) {
            return -1;
        }
        int delimiterLength = delimiter.length();
        if (delimiterLength > strLine.length()) {
            return -1;
        }
        StringBuilder bufferLine = new StringBuilder(strLine.toLowerCase());
        while ((index = bufferLine.indexOf(delimiter)) != -1) {
            boolean afterCh;
            boolean beforeCh;
            boolean bl = index > 0 ? !Character.isJavaIdentifierPart(bufferLine.charAt(index - 1)) : (beforeCh = true);
            boolean bl2 = index + delimiterLength < bufferLine.length() ? !Character.isJavaIdentifierPart(bufferLine.charAt(index + delimiterLength)) : (afterCh = true);
            if (beforeCh && afterCh) {
                return index;
            }
            bufferLine.replace(index, index + delimiterLength, this.makeDummyDelimiter(delimiterLength));
        }
        return -1;
    }

    private String makeDummyDelimiter(int length) {
        if (length < 0) {
            return "";
        }
        StringBuilder dummy = new StringBuilder();
        int i = 0;
        while (i < length) {
            dummy.append(" ");
            ++i;
        }
        return dummy.toString();
    }

    protected String indentForDelimiter(IDocument document, int indLine, int line, String delimiter) {
        String indent = DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)-1);
        if (this.fUseSpacesNotTabs) {
            indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.TAB_SIZE);
        }
        if (delimiter != null && indLine != line && INDENTED_AMBIGUOUS_DELIMITERS.contains(delimiter)) {
            return String.valueOf(TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.TAB_SIZE)) + indent;
        }
        return indent;
    }

    protected boolean isCodePartition(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        if (d == null || offset < 0 || offset >= d.getLength()) {
            return false;
        }
        String currentContentType = ((IDocumentExtension3)d).getContentType("__vhdl_partitioning", offset, false);
        return currentContentType.equals("__dftl_partition_content_type");
    }

    protected String getEndDelimiter(IDocument document, DocumentCommand command) throws BadLocationException {
        if (document == null || command == null) {
            return null;
        }
        String strLine = this.getLineTextwithCommand(document, command);
        if (strLine == null) {
            return null;
        }
        StringBuilder lineBuilder = new StringBuilder(strLine);
        int nrDelimiters = 0;
        int i = 0;
        String endDelimiter = "end";
        while (i < ALL_END_KEYWORDS.length) {
            String delimiter = ALL_END_KEYWORDS[i];
            int index = this.getDelimiterIndex(lineBuilder.toString(), delimiter);
            if (delimiter != null && index > -1) {
                if (++nrDelimiters > 1) {
                    return null;
                }
                int delimiterLength = delimiter.length();
                lineBuilder.replace(index, index + delimiterLength, this.makeDummyDelimiter(delimiterLength));
                i = 0;
                endDelimiter = delimiter;
                continue;
            }
            ++i;
        }
        if (nrDelimiters == 0) {
            return null;
        }
        return endDelimiter;
    }

    protected String startsWithDelimiter(String after, String[] delimiters) {
        if (after == null || delimiters == null) {
            return "";
        }
        int i = 0;
        String delimiter = "";
        i = 0;
        while (i < delimiters.length) {
            delimiter = delimiters[i];
            if (after.startsWith(delimiter)) {
                char nextChar;
                if (after.length() == delimiter.length()) {
                    return delimiter;
                }
                char c = nextChar = after.length() > delimiter.length() ? (char)after.charAt(delimiter.length()) : (char)'\uffff';
                if (nextChar != '\uffff' && !Character.isJavaIdentifierPart(nextChar)) {
                    return delimiter;
                }
            }
            ++i;
        }
        return "";
    }

    protected int isPositiveIndentation(IDocument document, int startLine) {
        if (document == null) {
            return startLine;
        }
        int line = this.casePortMapException(document, startLine);
        if (startLine != line) {
            return line;
        }
        return startLine;
    }

    private int casePortMapException(IDocument document, int startLine) {
        if (document == null || startLine == -1) {
            return startLine;
        }
        try {
            int line = startLine;
            int indLine = startLine;
            int lineOffset = document.getLineOffset(line);
            int lineLength = document.getLineLength(line);
            boolean semiCondition = false;
            boolean paranCondition = false;
            boolean mapKeywordCondition = false;
            int mapKeywordConditionCount = 0;
            int preorderCondition = -1;
            boolean instantiatedCondition = false;
            int paranCount = 0;
            String lineText = "";
            DVTStringBuilder buffer = new DVTStringBuilder();
            while (line >= 0) {
                lineOffset = document.getLineOffset(line);
                lineLength = document.getLineLength(line);
                lineText = document.get(lineOffset, lineLength).trim();
                buffer = new DVTStringBuilder();
                int end = lineText.length() - 1;
                while (end >= 0) {
                    if (!this.isCodePartition(document, lineOffset + end)) {
                        --end;
                        continue;
                    }
                    char curr = lineText.charAt(end);
                    --end;
                    buffer.prepend(curr);
                    if (preorderCondition > 0 && !semiCondition) {
                        return startLine;
                    }
                    if (preorderCondition > 0 && semiCondition && !paranCondition) {
                        return startLine;
                    }
                    if (curr == ' ' || curr == '\t' || curr == '\r' || curr == '\n') continue;
                    if (curr == ';' && !semiCondition) {
                        if (paranCondition || mapKeywordCondition) {
                            return startLine;
                        }
                        semiCondition = true;
                        preorderCondition = 0;
                        continue;
                    }
                    if (curr == ')') {
                        if (!(paranCondition || semiCondition && !mapKeywordCondition)) {
                            return startLine;
                        }
                        if (preorderCondition == -1) {
                            return startLine;
                        }
                        paranCondition = true;
                        --paranCount;
                        continue;
                    }
                    if (curr == '(') {
                        ++paranCount;
                        continue;
                    }
                    preorderCondition = 1;
                    String delimiter = this.startsWithDelimiter(buffer.toString(), ALL_KEYWORDS);
                    if (!delimiter.isEmpty()) {
                        if (delimiter.equals("map") || delimiter.equals("port")) {
                            if (!(mapKeywordCondition || semiCondition && paranCondition)) {
                                return startLine;
                            }
                            mapKeywordCondition = true;
                            if (mapKeywordConditionCount >= 2) {
                                return indLine;
                            }
                            ++mapKeywordConditionCount;
                            indLine = line;
                        } else if (delimiter.equals("entity") || delimiter.equals("component") || delimiter.equals("configuration")) {
                            if (!(instantiatedCondition || semiCondition && paranCondition && mapKeywordCondition)) {
                                return startLine;
                            }
                            instantiatedCondition = true;
                            indLine = line;
                        } else if (semiCondition && paranCondition && mapKeywordCondition) {
                            instantiatedCondition = true;
                        } else if (!(semiCondition && paranCondition && mapKeywordCondition)) {
                            return startLine;
                        }
                    }
                    if (!semiCondition || !paranCondition || !mapKeywordCondition || !instantiatedCondition) continue;
                    if (paranCount == 0) {
                        return indLine;
                    }
                    return startLine;
                }
                --line;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return startLine;
    }

    static class DelimitersInfo {
        private int indentationCount;
        private List<String> unpairedOpenDelimiters;

        public DelimitersInfo(int pairDelimiters, List<String> unpairedOpenDelimiters) {
            this.indentationCount = pairDelimiters;
            this.unpairedOpenDelimiters = unpairedOpenDelimiters;
        }

        public List<String> getUnpairedOpenDelimiters() {
            return this.unpairedOpenDelimiters;
        }

        public int getIndentationCount() {
            return this.indentationCount;
        }
    }
}

