/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;

public class VhdlCommentAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private VhdlEditor fEditor;

    public VhdlCommentAutoEditStrategy(VhdlEditor editor) {
        this.fEditor = editor;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!VhdlPlugin.getDefault().getPreferenceStore().getBoolean("typing.comments_case")) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        this.autoInsertInComments(d, c);
    }

    private void autoInsertInComments(IDocument d, DocumentCommand command) {
        if (d == null || command == null) {
            return;
        }
        if (!DVTDocumentCommon.isTextNewLine((IDocument)d, (String)command.text)) {
            return;
        }
        try {
            String currentContentType = ((IDocumentExtension3)d).getContentType("__vhdl_partitioning", command.offset, false);
            if ("__vhdl_ml_comment".equals(currentContentType)) {
                int offset = command.offset;
                String indent = this.computeIndent(d, command);
                int line = d.getLineOfOffset(offset);
                int start = d.getLineOffset(line);
                int sOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)start, (char)'/');
                int stOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)start, (char)'*');
                if (sOffset == -1 && stOffset != -1) {
                    if (stOffset < offset) {
                        command.text = String.valueOf(command.text) + indent + "* ";
                    } else {
                        super.customizeDocumentCommand(d, command);
                    }
                    return;
                }
                int asOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)(sOffset + 1), (char)'*');
                if (sOffset != -1 && asOffset != -1) {
                    if (this.validToCloseComment(d, offset)) {
                        int newLineTextLength = command.text.length();
                        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor);
                        command.text = String.valueOf(command.text) + indent + " * " + lineDelimiter + indent + " */";
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + newLineTextLength + indent.length() + " * ".length();
                    } else {
                        command.text = String.valueOf(command.text) + indent + " * ";
                    }
                } else {
                    super.customizeDocumentCommand(d, command);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            super.customizeDocumentCommand(d, command);
        }
    }

    private String computeIndent(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return "";
        }
        String result = "";
        try {
            int line = document.getLineOfOffset(command.offset);
            result = DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)line, (int)command.offset);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return result;
    }

    public boolean validToCloseComment(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        if (d == null || offset < 0 || offset > d.getLength()) {
            throw new BadLocationException();
        }
        ITypedRegion region = ((IDocumentExtension3)d).getPartition("__vhdl_partitioning", offset, false);
        if (!"__vhdl_ml_comment".equals(region.getType())) {
            throw new BadPartitioningException();
        }
        int regionEnd = region.getOffset() + region.getLength();
        while (regionEnd < d.getLength()) {
            region = ((IDocumentExtension3)d).getPartition("__vhdl_partitioning", regionEnd + 1, false);
            if (!"__vhdl_ml_comment".equals(region.getType())) break;
            regionEnd = region.getOffset() + region.getLength();
        }
        String mlCommentRegion = d.get(offset, Math.max(regionEnd - offset, 0));
        int sindex = mlCommentRegion.indexOf("/*");
        int eindex = mlCommentRegion.indexOf("*/");
        if (sindex == -1) {
            return eindex == -1;
        }
        if (eindex == -1) {
            return true;
        }
        return eindex > sindex;
    }
}

