/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.formatter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFScopeScanner;

public class VhdlCFIndentScanner
extends VhdlCFScopeScanner
implements ICFIndentScannerImpl {
    private CFIndentScanner fCFIndentScanner;
    private Set<String> fPrevKeywords4Param;
    private Set<String> fPrevPrevKeywords4Param;

    public VhdlCFIndentScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFIndentScanner = (CFIndentScanner)cfTokenScanner;
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isBeginIndentation()) {
            return;
        }
        if (!this.isInPreproc()) {
            this.fCFIndentScanner.indent(token);
        }
    }

    public CFToken getTokenForLineBreakBeforeParenOpen(CFToken token) {
        return token;
    }

    public boolean allowLineBreak(CFToken token) {
        char c;
        if (token == null) {
            return false;
        }
        return token.getTokenType() != 4 || ';' != (c = token.getValue().charAt(0)) && ',' != c;
    }

    public boolean forceLineBreak(CFToken token) {
        return false;
    }

    public boolean tryElsePrefs(CFToken token) {
        return false;
    }

    public boolean allowElseOnSameLine(CFToken token) {
        return false;
    }

    @Override
    protected void updateOnSemi(CFToken token) {
        this.fCFIndentScanner.hookOnSeparator4ParameterPrefs(token);
        super.updateOnSemi(token);
    }

    public boolean allowParamPrefs() {
        if (this.fPrevKeywords4Param == null || this.fPrevPrevKeywords4Param == null) {
            this.fPrevKeywords4Param = new HashSet<String>();
            this.fPrevKeywords4Param.addAll(Arrays.asList("port", "generic", "map"));
            this.fPrevPrevKeywords4Param = new HashSet<String>();
            this.fPrevPrevKeywords4Param.addAll(Arrays.asList("function", "procedure"));
        }
        if (this.fPrevToken != null && this.fPrevKeywords4Param.contains(this.fPrevToken.getValue())) {
            return true;
        }
        if (this.fPrevPrevToken != null && this.fPrevPrevKeywords4Param.contains(this.fPrevPrevToken.getValue())) {
            return true;
        }
        return this.fPrevPrevPrevToken != null && "type".equals(this.fPrevPrevPrevToken.getValue()) && this.fPrevToken != null && "is".equals(this.fPrevToken.getValue());
    }

    public boolean tryAddWhitespaceBefore(CFToken token) {
        return this.fCFIndentScanner.tryAddWhitespaceBefore(token);
    }

    public boolean tryAddWhitespaceAfter(CFToken token) {
        return this.fCFIndentScanner.tryAddWhitespaceAfter(token);
    }

    public void updateOnLineBreakBeforeOperator(CFToken token) {
    }
}

