/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFPreprocScanner;

public class VhdlCFScopeScanner
extends VhdlCFPreprocScanner {
    private CFScopeScanner fCFScopeScanner;
    protected int fWrapThreshold;
    protected CFPreferences fFormatPreferences;
    protected CFToken fNextKeywordToken;
    protected CFToken fPrevToken;
    protected CFToken fPrevPrevToken;
    protected CFToken fPrevPrevPrevToken;
    protected CFToken fPrevKeywordToken;
    protected static final String PORT_OR_GENERIC_MAP_ASPECT = "PORT_MAP_ASPECT";
    protected static final String PROCEDURE = "procedure";
    protected static final String FUNCTION = "function";
    protected static final String ENTITY_DECL = "ENTITY DECLARATIVE PART";
    protected static final String ENTITY_IMPL = "ENTITY STATEMENT PART";
    protected static final String ENTITY_INSTANCE = "ENTITY INSTANCE";
    protected static final String ARCHITECTURE_DECL = "ARCHITECTURE DECLARATIVE PART";
    protected static final String ARCHITECTURE_IMPL = "ARCHITECTURE STATEMENT PART";
    protected static final String BLOCK_DECL = "BLOCK DECLARATIVE PART";
    protected static final String BLOCK_IMPL = "BLOCK STATEMENT PART";
    protected static final String GENERATE_DECL = "GENERATE DECLARATIVE PART";
    protected static final String GENERATE_IMPL = "GENERATE STATEMENT PART";
    protected static final String COMPONENT_INSTANCE = "COMPONENT INSTANCE";
    protected static final String FOR_CONFIG_SPEC = "FOR CONFIG SPEC";
    protected static final String FOR_COMPONENT_CONFIG = "FOR COMPONENT CONFIG";
    protected static final String WHEN_CASE_ALTERNATIVE = "WHEN CASE ALTERNATIVE";
    protected static final String TYPE_IS_PROTECTED = "TYPE IS PROTECTED";
    protected static final String TYPE_IS_RECORD = "TYPE IS RECORD";
    protected static final String TYPE_IS_UNITS = "TYPE IS UNITS";
    protected static final String FUNCTION_IS = "FUNCTION IS";
    protected static final String PROCEDURE_IS = "PROCEDURE IS";
    protected static final String PACKAGE_IS_NEW = "PACKAGE IS NEW";
    protected static final String SKIP_KEYWORD_UNTIL_SEMI = "SKIP_KEYWORD_UNTIL_SEMI";

    public VhdlCFScopeScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFScopeScanner = (CFScopeScanner)cfTokenScanner;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fFormatPreferences = strategy.getFormatPreferences();
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        this.fWrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (token == null) {
            return;
        }
        switch (token.getTokenType()) {
            case 2: {
                if (this.fStrategy.getKeywordType(token.getValue()) == 0) break;
                this.updateOnKeyword(token);
                this.fPrevKeywordToken = token;
                break;
            }
            case 4: {
                String tokenValue = token.getValue();
                if (tokenValue.length() != 1) break;
                char tokenChar = tokenValue.charAt(0);
                switch (tokenChar) {
                    case '[': {
                        this.fCFScopeScanner.updateOnBracketOpen(token);
                        break;
                    }
                    case ']': {
                        this.fCFScopeScanner.updateOnBracketClose(token);
                        break;
                    }
                    case '(': {
                        this.fCFScopeScanner.updateOnParenOpen(token);
                        break;
                    }
                    case ')': {
                        this.updateOnParenClose(token);
                        break;
                    }
                    case '{': {
                        this.updateOnCurlyOpen(token);
                        break;
                    }
                    case '}': {
                        this.updateOnCurlyClose(token);
                        break;
                    }
                    case ',': {
                        this.fCFScopeScanner.updateOnComma(token);
                        break;
                    }
                    case ';': {
                        this.updateOnSemi(token);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        if (token.getTokenType() != 3 && token.getTokenType() != 30 && token.getTokenType() != 40) {
            this.fPrevPrevPrevToken = this.fPrevPrevToken;
            this.fPrevPrevToken = this.fPrevToken;
            this.fPrevToken = token;
        }
    }

    private void updateOnKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        String keywordValue = token.getValue();
        if (this.fPrevToken != null && this.fStrategy.isSkipIndent(this.fPrevToken.getValue(), keywordValue)) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && SKIP_KEYWORD_UNTIL_SEMI.equals(peekScope.getScopeName())) {
            return;
        }
        int keywordType = this.fStrategy.getKeywordType(keywordValue);
        switch (keywordType) {
            case 4: {
                this.updateOnThenKeyword(token);
                break;
            }
            case 1: {
                this.updateOnOPENKeyword(token);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                if ("entity".equals(keywordValue)) {
                    this.updateOnEntityKeyword(token);
                    break;
                }
                if ("architecture".equals(keywordValue)) {
                    this.updateOnArchitectureKeyword(token);
                    break;
                }
                if ("component".equals(keywordValue)) {
                    this.updateOnComponentKeyword(token);
                    break;
                }
                if ("configuration".equals(keywordValue)) {
                    this.updateOnConfigurationKeyword(token);
                    break;
                }
                if ("block".equals(keywordValue)) {
                    this.updateOnBlockKeyword(token);
                    break;
                }
                if ("begin".equals(keywordValue)) {
                    this.updateOnBeginKeyword(token);
                    break;
                }
                if ("for".equals(keywordValue)) {
                    this.updateOnForKeyword(token);
                    break;
                }
                if ("else".equals(keywordValue)) {
                    this.updateOnElseKeyword(token);
                    break;
                }
                if ("elsif".equals(keywordValue)) {
                    this.updateOnElseIfKeyword(token);
                    break;
                }
                if ("generate".equals(keywordValue)) {
                    this.updateOnGenerateKeyword(token);
                    break;
                }
                if ("type".equals(keywordValue)) {
                    this.updateOnTypeKeyword(token);
                    break;
                }
                if ("protected".equals(keywordValue)) {
                    this.updateOnProtectedKeyword(token);
                    break;
                }
                if ("record".equals(keywordValue)) {
                    this.updateOnRecordKeyword(token);
                    break;
                }
                if ("units".equals(keywordValue)) {
                    this.updateOnUnitsKeyword(token);
                    break;
                }
                if ("is".equals(keywordValue)) {
                    this.updateOnIsKeyword(token);
                    break;
                }
                if ("loop".equals(keywordValue)) {
                    this.updateOnLoopKeyword(token);
                    break;
                }
                if ("when".equals(keywordValue)) {
                    this.updateOnWhenKeyword(token);
                    break;
                }
                if ("end".equals(keywordValue)) {
                    this.updateOnEndKeyword(token);
                    break;
                }
                if ("new".equals(keywordValue)) {
                    this.updateOnNewKeyword(token);
                    break;
                }
                if ("attribute".equals(keywordValue) || "wait".equals(keywordValue)) {
                    this.push_SKIP_UNTIL_SEMI_Scope(token);
                    break;
                }
                if (!"port".equals(keywordValue) && !"generic".equals(keywordValue) || this.fNextKeywordToken == null || !"map".equals(this.fNextKeywordToken.getValue())) break;
                this.updateOnPortOrGenericMapKeyword(token);
            }
        }
    }

    private void updateOnPortOrGenericMapKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        String peekScopeName = peekScope.getScopeName();
        if (PORT_OR_GENERIC_MAP_ASPECT.equals(peekScopeName)) {
            return;
        }
        if (BLOCK_DECL.equals(peekScopeName)) {
            return;
        }
        if (PROCEDURE.equals(peekScopeName)) {
            return;
        }
        if (PACKAGE_IS_NEW.equals(peekScopeName)) {
            return;
        }
        if (FUNCTION.equals(peekScopeName)) {
            return;
        }
        if (FOR_COMPONENT_CONFIG.equals(peekScopeName) || FOR_CONFIG_SPEC.equals(peekScopeName)) {
            return;
        }
        if (ENTITY_DECL.equals(peekScopeName)) {
            return;
        }
        if ("component".equals(peekScopeName)) {
            return;
        }
        this.fCFScopeScanner.pushScope(token, PORT_OR_GENERIC_MAP_ASPECT, CFScope.BLOCK_SCOPE, CFScope.INDENT_CURRENT_LINE);
    }

    private void updateOnOPENKeyword(CFToken token) {
        this.pushOPENScope(token, null);
    }

    private void updateOnEndKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && WHEN_CASE_ALTERNATIVE.equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        if ((peekScope = this.fCFScopeScanner.getPeekScope()) != null && "then".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
    }

    private void updateOnThenKeyword(CFToken token) {
        this.fCFScopeScanner.pushScope(token, "then", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
    }

    private void updateOnEntityKeyword(CFToken token) {
        if (this.fCFScopeScanner.hasScope(FOR_CONFIG_SPEC)) {
            return;
        }
        if (this.fCFScopeScanner.hasScope(FOR_COMPONENT_CONFIG)) {
            return;
        }
        if (this.fCFScopeScanner.hasScope(ARCHITECTURE_IMPL)) {
            this.fCFScopeScanner.pushScope(token, ENTITY_INSTANCE, CFScope.BLOCK_SCOPE, CFScope.NO_INDENT);
            return;
        }
        this.pushOPENScope(token, ENTITY_DECL);
    }

    private void updateOnArchitectureKeyword(CFToken token) {
        this.pushOPENScope(token, ARCHITECTURE_DECL);
    }

    private void updateOnBlockKeyword(CFToken token) {
        this.pushOPENScope(token, BLOCK_DECL);
    }

    private void updateOnGenerateKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && ("if".equals(peekScope.getScopeName()) || "for".equals(peekScope.getScopeName()) || "else".equals(peekScope.getScopeName()) || "elsif".equals(peekScope.getScopeName()))) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        this.pushOPENScope(token, GENERATE_DECL);
    }

    private void updateOnComponentKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            this.pushOPENScope(token, null);
            return;
        }
        String scopeName = peekScope.getScopeName();
        if (scopeName == null) {
            this.pushOPENScope(token, null);
            return;
        }
        if (scopeName.equals(ARCHITECTURE_IMPL) || scopeName.equals(BLOCK_IMPL) || scopeName.equals(GENERATE_IMPL)) {
            this.fCFScopeScanner.pushScope(token, COMPONENT_INSTANCE, CFScope.BLOCK_SCOPE, CFScope.NO_INDENT);
            return;
        }
        this.pushOPENScope(token, null);
    }

    private void updateOnConfigurationKeyword(CFToken token) {
        if (this.fCFScopeScanner.hasScope(FOR_COMPONENT_CONFIG)) {
            return;
        }
        this.pushOPENScope(token, null);
    }

    private void updateOnForKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && ARCHITECTURE_DECL.equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, FOR_CONFIG_SPEC, CFScope.BLOCK_SCOPE, CFScope.INDENT);
        } else if (peekScope != null && BLOCK_DECL.equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, FOR_CONFIG_SPEC, CFScope.BLOCK_SCOPE, CFScope.INDENT);
        } else if (peekScope != null && ("configuration".equals(peekScope.getScopeName()) || FOR_COMPONENT_CONFIG.equals(peekScope.getScopeName()))) {
            this.fCFScopeScanner.pushScope(token, FOR_COMPONENT_CONFIG, CFScope.BLOCK_SCOPE, CFScope.INDENT);
        } else {
            this.pushOPENScope(token, null);
        }
    }

    private void updateOnElseKeyword(CFToken token) {
        String scopeName;
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if ("then".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        if ("if".equals(scopeName = (peekScope = this.fCFScopeScanner.getPeekScope()).getScopeName()) || "elsif".equals(scopeName) || GENERATE_DECL.equals(scopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, "else", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnElseIfKeyword(CFToken token) {
        String scopeName;
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if ("then".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        if ("if".equals(scopeName = (peekScope = this.fCFScopeScanner.getPeekScope()).getScopeName()) || "elsif".equals(scopeName) || GENERATE_DECL.equals(scopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, "elsif", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnLoopKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && ("for".equals(peekScope.getScopeName()) || "while".equals(peekScope.getScopeName()))) {
            return;
        }
        this.pushOPENScope(token, null);
    }

    private void updateOnWhenKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && !"case".equals(peekScope.getScopeName()) && !WHEN_CASE_ALTERNATIVE.equals(peekScope.getScopeName())) {
            return;
        }
        if (peekScope != null && WHEN_CASE_ALTERNATIVE.equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        this.pushOPENScope(token, WHEN_CASE_ALTERNATIVE);
    }

    private void updateOnTypeKeyword(CFToken token) {
        this.fCFScopeScanner.pushScope(token, "type", CFScope.BLOCK_SCOPE, CFScope.NO_INDENT);
    }

    private void updateOnProtectedKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if ("type".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.pushOPENScope(token, TYPE_IS_PROTECTED);
        }
    }

    private void updateOnRecordKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if ("type".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.pushOPENScope(token, TYPE_IS_RECORD);
        }
    }

    private void updateOnUnitsKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if ("type".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.pushOPENScope(token, TYPE_IS_UNITS);
        }
    }

    private void updateOnIsKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if (FUNCTION.equals(peekScope.getScopeName())) {
            peekScope.setScopeName(FUNCTION_IS);
        } else if (PROCEDURE.equals(peekScope.getScopeName())) {
            peekScope.setScopeName(PROCEDURE_IS);
        }
    }

    private void updateOnNewKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if (FUNCTION_IS.equals(peekScope.getScopeName())) {
            peekScope.setScopeName(FUNCTION);
        } else if (PROCEDURE_IS.equals(peekScope.getScopeName())) {
            peekScope.setScopeName(PROCEDURE);
        } else if ("package".equals(peekScope.getScopeName())) {
            peekScope.setScopeName(PACKAGE_IS_NEW);
        }
    }

    private void updateOnBeginKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        String peekScopeName = peekScope.getScopeName();
        if (peekScopeName == null) {
            return;
        }
        if (ENTITY_DECL.equals(peekScopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, ENTITY_IMPL, CFScope.BLOCK_SCOPE, peekScope.addsIndent() ? CFScope.INDENT : CFScope.NO_INDENT);
        } else if (ARCHITECTURE_DECL.equals(peekScopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, ARCHITECTURE_IMPL, CFScope.BLOCK_SCOPE, peekScope.addsIndent() ? CFScope.INDENT : CFScope.NO_INDENT);
        } else if (BLOCK_DECL.equals(peekScopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, BLOCK_IMPL, CFScope.BLOCK_SCOPE, peekScope.addsIndent() ? CFScope.INDENT : CFScope.NO_INDENT);
        } else if (GENERATE_DECL.equals(peekScopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, GENERATE_IMPL, CFScope.BLOCK_SCOPE, peekScope.addsIndent() ? CFScope.INDENT : CFScope.NO_INDENT);
        }
        if ("process".equals(peekScopeName) || FUNCTION_IS.equals(peekScopeName) || PROCEDURE_IS.equals(peekScopeName) || TYPE_IS_PROTECTED.equals(peekScopeName)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            this.fCFScopeScanner.pushScope(token, peekScope.getScopeName(), CFScope.BLOCK_SCOPE, peekScope.addsIndent() ? CFScope.INDENT : CFScope.NO_INDENT);
        }
    }

    protected void updateOnSemi(CFToken token) {
        this.popTo(token, FOR_CONFIG_SPEC);
        this.popTo(token, ENTITY_INSTANCE);
        this.popTo(token, COMPONENT_INSTANCE);
        this.popTo(token, FUNCTION);
        this.popTo(token, PROCEDURE);
        this.popTo(token, "type");
        this.popTo(token, PACKAGE_IS_NEW);
        this.popTo(token, PORT_OR_GENERIC_MAP_ASPECT);
        this.popTo(token, SKIP_KEYWORD_UNTIL_SEMI);
    }

    protected void updateOnParenClose(CFToken token) {
        String peekScopeName;
        this.popTo(token, "type");
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && (PACKAGE_IS_NEW.equals(peekScopeName = peekScope.getScopeName()) || FUNCTION.equals(peekScopeName) || PROCEDURE.equals(peekScopeName))) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        this.fCFScopeScanner.updateOnParenClose(token);
    }

    public void updateOnCurlyOpen(CFToken token) {
        this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
    }

    public void updateOnCurlyClose(CFToken token) {
        this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
    }

    private void pushOPENScope(CFToken token, String scopeName) {
        if (token == null) {
            return;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null) {
            return;
        }
        boolean isNoIndentKeywordPref = this.fStrategy.isNoIndentKeywordPref(tokenValue);
        this.fCFScopeScanner.pushScope(token, scopeName != null ? scopeName : tokenValue, CFScope.BLOCK_SCOPE, isNoIndentKeywordPref ? CFScope.NO_INDENT : CFScope.INDENT);
    }

    private void push_SKIP_UNTIL_SEMI_Scope(CFToken token) {
        this.fCFScopeScanner.pushScope(token, SKIP_KEYWORD_UNTIL_SEMI, CFScope.BLOCK_SCOPE, CFScope.NO_INDENT);
    }

    private void popTo(CFToken token, String scopeName) {
        if (scopeName == null) {
            return;
        }
        if (this.fCFScopeScanner.hasScope(scopeName)) {
            while (this.fCFScopeScanner.hasScopes()) {
                CFScope peekScope = this.fCFScopeScanner.getPeekScope();
                if ("(".equals(peekScope.getScopeName()) || "[".equals(peekScope.getScopeName()) || "{".equals(peekScope.getScopeName())) break;
                this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
                if (scopeName.equals(peekScope.getScopeName())) break;
            }
        }
    }

    public void setNextKeywordTokenInChunk(CFToken token) {
        this.fNextKeywordToken = token;
    }
}

