/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.formatter;

import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.vhdldt.ui.editor.VhdlSourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCodeFormattingKeywordsSet;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlFormattingPreferences;

public class VhdlCodeFormattingStrategy
extends DVTBaseCodeFormattingStrategy {
    public VhdlCodeFormattingStrategy(VhdlSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super((DVTSourceViewerConfiguration)configuration, formatPreferences);
    }

    protected void refreshFormattingPreferences() {
        super.refreshFormattingPreferences();
        if (!(this.fFormatPreferences instanceof VhdlFormattingPreferences)) {
            return;
        }
        VhdlFormattingPreferences formattPreferences = (VhdlFormattingPreferences)this.fFormatPreferences;
        formattPreferences.refreshKeywordsPref();
        formattPreferences.refreshDataTypesPref();
        formattPreferences.refreshAttributesPref();
    }

    public boolean isWordChar(char c, char prevChar, char nextChar, StringBuilder currWord) {
        char prevPrevChar = '\u0000';
        if (currWord != null && currWord.length() > 2) {
            prevPrevChar = currWord.charAt(currWord.length() - 2);
        }
        return Character.isJavaIdentifierPart(c) || '\'' == c || c == '.' || c == '+' && (prevChar == 'E' || prevChar == 'e') && Character.isDigit(prevPrevChar) || c == '-' && (prevChar == 'E' || prevChar == 'e') && Character.isDigit(prevPrevChar);
    }

    public void capitalize(CFModel model, CFToken token) {
        if (token == null) {
            return;
        }
        if (!(this.fFormatPreferences instanceof VhdlFormattingPreferences)) {
            return;
        }
        String tokenValue = token.getValue();
        if (token.getTokenType() == 2 && tokenValue != null) {
            tokenValue = tokenValue.toLowerCase();
            String newTokenValue = this.capitalizeKeyword(tokenValue);
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk == null) {
                return;
            }
            if (newTokenValue != null) {
                chunk.addAction(new CFAction(token.getStartOffsetInChunk(), tokenValue.length(), newTokenValue, "capitalize"));
            }
        }
    }

    private String applyKeywordsPref(String tokenValue) {
        if (this.fFormatPreferences.isCapitalizationKeyworsUpper()) {
            return tokenValue.toUpperCase();
        }
        if (this.fFormatPreferences.isCapitalizationKeyworsLower()) {
            return tokenValue;
        }
        return null;
    }

    private String applyDataTypesPref(String tokenValue) {
        if (this.fFormatPreferences.isCapitalizationDataTypesUpper()) {
            return tokenValue.toUpperCase();
        }
        if (this.fFormatPreferences.isCapitalizationDataTypesLower()) {
            return tokenValue;
        }
        return null;
    }

    private String applyAttributesPref(String tokenValue, String attribute) {
        if (this.fFormatPreferences.isCapitalizationAttributesUpper()) {
            return String.valueOf(tokenValue) + attribute.toUpperCase();
        }
        if (this.fFormatPreferences.isCapitalizationAttributesLower()) {
            return String.valueOf(tokenValue) + attribute.toLowerCase();
        }
        return null;
    }

    private String capitalizeKeyword(String tokenValue) {
        Set<String> keywordsPref = ((VhdlFormattingPreferences)this.fFormatPreferences).getKeywordsPref();
        if (keywordsPref != null && keywordsPref.contains(tokenValue)) {
            return this.applyKeywordsPref(tokenValue);
        }
        Set<String> dataTypesPref = ((VhdlFormattingPreferences)this.fFormatPreferences).getDataTypesPref();
        if (dataTypesPref != null && dataTypesPref.contains(tokenValue)) {
            return this.applyDataTypesPref(tokenValue);
        }
        int lastTickIndex = tokenValue.lastIndexOf(39);
        if (lastTickIndex != -1 && lastTickIndex + 1 < tokenValue.length()) {
            String attribute = tokenValue.substring(lastTickIndex + 1, tokenValue.length());
            Set<String> attributesPref = ((VhdlFormattingPreferences)this.fFormatPreferences).getAttributesPref();
            if (attributesPref != null && attributesPref.contains(attribute)) {
                return this.applyAttributesPref(tokenValue.substring(0, lastTickIndex + 1), attribute);
            }
        }
        return null;
    }

    protected boolean isClosingToken(String tokenValue) {
        return false;
    }

    public boolean allowWhitespaceBeforeToken(CFToken token) {
        return true;
    }

    public boolean allowWhitespaceAfterToken(CFToken token) {
        return true;
    }

    protected Set<Character> getBoundaryVAlignChars() {
        return VhdlCodeFormattingKeywordsSet.BOUNDARY_ALIGN_CHARS;
    }

    public Set<String> getOpenKeywords() {
        return VhdlCodeFormattingKeywordsSet.OPEN_KEYWORDS;
    }

    public Set<String> getSimpleKeywords() {
        return VhdlCodeFormattingKeywordsSet.SIMPLE_KEYWORDS;
    }

    public Set<String> getSpecialKeywords() {
        return VhdlCodeFormattingKeywordsSet.SPECIAL_KEYWORDS;
    }

    public String getBeginKeyword() {
        return "then";
    }

    public Map<String[], String[]> getSkipIndentKeywordPairs() {
        return VhdlCodeFormattingKeywordsSet.SKIP_INDENT_KEYWORD_PAIRS;
    }
}

