/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFNoIndentDefinition;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExBaseDefinition;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionConstantDeclarations;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionPortDeclarations;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionRecordDeclarations;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionSignalConstantVariableDeclarations;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionSignalDeclarations;
import ro.amiq.vhdldt.ui.editor.formatter.VhdlCFVRegExDefinitionVariableDeclarations;
import ro.amiq.vhdldt.ui.preferences.PrefConst;

public class VhdlFormattingPreferences
extends CFPreferences {
    private Set<String> keywordsPref = new HashSet<String>();
    private Set<String> dataTypesPref = new HashSet<String>();
    private Set<String> attributesPref = new HashSet<String>();
    private static VhdlFormattingPreferences INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VhdlFormattingPreferences getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VhdlFormattingPreferences();
            }
        }
        return INSTANCE;
    }

    protected VhdlFormattingPreferences() {
    }

    public Set<String> getKeywordsPref() {
        return this.keywordsPref;
    }

    public Set<String> getDataTypesPref() {
        return this.dataTypesPref;
    }

    public Set<String> getAttributesPref() {
        return this.attributesPref;
    }

    public void refreshKeywordsPref() {
        String[] prefs;
        this.keywordsPref.clear();
        String[] stringArray = prefs = PrefConst.getVHDLLowercaseKeywords();
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            String pref = stringArray[n2];
            if (pref != null) {
                this.keywordsPref.add(pref);
            }
            ++n2;
        }
    }

    public void refreshDataTypesPref() {
        String[] prefs;
        this.dataTypesPref.clear();
        String[] stringArray = prefs = PrefConst.getVHDLLowercaseTypes();
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            String pref = stringArray[n2];
            if (pref != null) {
                this.dataTypesPref.add(pref);
            }
            ++n2;
        }
    }

    public void refreshAttributesPref() {
        String[] prefs;
        this.attributesPref.clear();
        String[] stringArray = prefs = PrefConst.getVHDLLowercaseAttributes();
        int n = prefs.length;
        int n2 = 0;
        while (n2 < n) {
            String pref = stringArray[n2];
            if (pref != null && pref.length() > 1) {
                this.attributesPref.add(pref.substring(1, pref.length()));
            }
            ++n2;
        }
    }

    protected VhdlPlugin getDefaultPlugin() {
        return VhdlPlugin.getDefault();
    }

    protected IPreferenceStore getPluginCombinedPreferenceStore() {
        return VhdlPlugin.getDefault().getCombinedPreferenceStore();
    }

    public String getPreviewFileName() {
        return "FormattingPreviewCode.vhd";
    }

    public String getPreviewFileNameExtension() {
        return ".vhd";
    }

    protected void initAllNoIndentKeywordsPref() {
        super.initAllNoIndentKeywordsPref();
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList("architecture", "process", "generate", "package", "block", "component", "configuration", "for", "entity", "loop", "function", "procedure", "protected", "record", "case"));
        Collections.sort(all);
        for (String name : all) {
            this.fAllNoIndentKeywordsPref.put(name, new CFNoIndentDefinition(name));
        }
    }

    protected void initAllVRegExPref() {
        super.initAllVRegExPref();
        VhdlCFVRegExBaseDefinition def = new VhdlCFVRegExDefinitionSignalConstantVariableDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VhdlCFVRegExDefinitionPortDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VhdlCFVRegExDefinitionSignalDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VhdlCFVRegExDefinitionConstantDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VhdlCFVRegExDefinitionVariableDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VhdlCFVRegExDefinitionRecordDeclarations();
        this.fAllVRegExPref.put(def.getName(), def);
    }

    public String getBeginKeywordText() {
        return "then";
    }

    public boolean hasBeginPrefNewLineAndIndent() {
        return false;
    }

    public boolean hasElseOptions() {
        return false;
    }

    public boolean hasCapitalizationOptions() {
        return true;
    }

    public boolean hasAddWhitespaceOptions() {
        return true;
    }

    public boolean hasRemoveNLOptions() {
        return false;
    }

    public boolean hasParametersOptions() {
        return true;
    }

    public boolean hasPreprocessingOptions() {
        return false;
    }

    public boolean hasIndentMLCommentsOptions() {
        return true;
    }

    public boolean hasIndentSkipAssignsOptions() {
        return false;
    }

    public boolean hasIndentSkipMLMacroDefsOptions() {
        return false;
    }

    public boolean hasIndentAssumeImplicitSemiMacrosOptions() {
        return false;
    }

    public boolean hasImplicitSemiOptions() {
        return false;
    }

    public boolean hasScopeMacrosOptions() {
        return false;
    }

    public boolean hasVIndependentIfdefs() {
        return false;
    }

    public boolean hasVParenOptions() {
        return true;
    }

    public boolean hasVCurlyOptions() {
        return false;
    }

    public boolean hasFixWhitespaceAfterCodeMarkerInExpansion() {
        return false;
    }

    public boolean hasAddNewLineAfterBeginAndBeforeEnd() {
        return false;
    }

    public boolean hasAddNewLineAfterEnd() {
        return false;
    }

    public boolean hasVRegExCompactWSOptions() {
        return false;
    }
}

