/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.highlight;

import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.ui.editor.highlight.VhdlHlUtils;

public class HighlightHidVisitor
implements IHidVisitor<IHidObject> {
    private IDocument fDocument;
    private Map<Integer, Position> fPositions;
    private ParserPath fParserPath;
    private ParserPath fCurrentParserPath;
    private int fStartOffset;
    private int fEndOffset;

    public HighlightHidVisitor(IDocument document, Map<Integer, Position> positions, ParserPath parserPath, int startOffset, int endOffset) {
        this.fDocument = document;
        this.fPositions = positions;
        this.fParserPath = parserPath;
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
    }

    public boolean visit(IHidObject hidObject) {
        if (!this.fCurrentParserPath.equals((Object)this.fParserPath)) {
            return true;
        }
        if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
            return true;
        }
        RfHid rfHid = (RfHid)hidObject;
        if (rfHid.getOccurrence().getOffset() < this.fStartOffset && !TestHelper.isTestMode()) {
            return true;
        }
        if (rfHid.getOccurrence().getOffset() > this.fEndOffset && !TestHelper.isTestMode()) {
            return true;
        }
        HighlightKind highlightKind = VhdlHlUtils.getHighlightKind(rfHid.getElement());
        if (highlightKind == null) {
            highlightKind = rfHid.hasQualifier(HidQualifierCache.TYPE_QUALIFIER) ? HighlightKind.TYPE : (rfHid.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER) ? HighlightKind.ATTRIBUTE : HighlightKind.DEFAULT);
        }
        if (highlightKind == null) {
            return true;
        }
        HidOccurrence occurrence = rfHid.getOccurrence();
        if (occurrence == null) {
            return true;
        }
        int offset = occurrence.getOffset();
        if (offset < 0 || offset >= this.fDocument.getLength()) {
            return true;
        }
        try {
            DVTHlUtils.addPosition((IDocument)this.fDocument, (int)offset, (HighlightKind)highlightKind, this.fPositions);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fCurrentParserPath = parserPath;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }
}

