/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.highlight;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfLibrary;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public class VhdlHlUtils
extends DVTHlUtils {
    public static HighlightKind getHighlightKind(IRfNamedElement element) {
        if (element instanceof RfEnum) {
            return HighlightKind.VHDL_ENUM_ITEMS;
        }
        if (element instanceof RfType || element instanceof RfEntity || element instanceof RfComponent || element instanceof RfPackage && !(element instanceof ImportInfo.ErrorPackage) || element instanceof RfPackageBody || element instanceof RfTypeBody || element instanceof RfLibrary) {
            return HighlightKind.TYPE;
        }
        if (element instanceof IRfMethodElement || element instanceof RfFunctionsHolder) {
            return HighlightKind.METHOD;
        }
        if (element instanceof IRfPortElement) {
            if (((IRfPortElement)element).isOutput()) {
                return HighlightKind.OUT_PORT;
            }
            return HighlightKind.PORT;
        }
        if (element instanceof RfVariable) {
            RfVariable variableElement = (RfVariable)element;
            if (variableElement.isConstant() && !variableElement.isArgument()) {
                return HighlightKind.CONSTANT;
            }
            if (variableElement.isArgument()) {
                return HighlightKind.ARGUMENT;
            }
            if (variableElement.isVariable() || variableElement.isSharedVariable()) {
                return HighlightKind.VARIABLE;
            }
            if (variableElement.isSignal()) {
                return HighlightKind.SIGNAL;
            }
            if (variableElement.isAttribute()) {
                return HighlightKind.ATTRIBUTE;
            }
            if (variableElement instanceof RfAlias) {
                return VhdlHlUtils.getHighlightKind(((RfAlias)variableElement).getTranslatedType());
            }
            if (variableElement.getEnclosingScope() instanceof RfType && ((RfType)variableElement.getEnclosingScope()).isRecord()) {
                return HighlightKind.RECORD_ELEMENT;
            }
        }
        return null;
    }

    public static void colorDataType(DataType dataType, IDocument document, HighlightKind highlightKind, Map<Integer, Position> positionOffsets) {
        if (dataType == null || highlightKind == null || document == null) {
            return;
        }
        List<DataTypeChunk> typeNames = dataType.getTypeName();
        for (DataTypeChunk typeName : typeNames) {
            int offset = typeName.offset;
            if (offset < 0 || offset >= document.getLength()) {
                return;
            }
            VhdlHlUtils.addPosition((IDocument)document, (int)offset, (HighlightKind)highlightKind, positionOffsets);
        }
    }
}

