/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.highlight;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfAssociatedType;
import ro.amiq.vhdldt.model.reflection.ImportInfo;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.ui.editor.highlight.HighlightHidVisitor;
import ro.amiq.vhdldt.ui.editor.highlight.VhdlHlUtils;

public class VhdlSemanticHighlighter
extends DVTSemanticHighlighter<RfDefElement> {
    private IHidVisitor<?> fHighlightHidVisitor;

    public VhdlSemanticHighlighter(IDocument document) {
        super(document);
    }

    public void process(IRfFileDef file, SemanticHighlightJob job, int startOffset, int endOffset) {
        this.fHighlightHidVisitor = new HighlightHidVisitor(this.getDocument(), this.getPositions(), file != null ? file.getParserPath() : null, startOffset, endOffset);
        super.process(file, job, startOffset, endOffset);
    }

    protected IStatus doHighlightRecursive(RfDefElement root, Set<RfDefElement> visited, SemanticHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        if (root == null) {
            return Status.OK_STATUS;
        }
        int startOffset = root.getStartOffset();
        int endOffset = root.getEndOffset();
        if (startOffset != -1 && endOffset != -1 && (startOffset > this.getEndOffset() || endOffset < this.getStartOffset())) {
            return Status.OK_STATUS;
        }
        return super.doHighlightRecursive((IRfBaseElement)root, visited, job);
    }

    protected void doHighlight(RfDefElement defElement) throws BadLocationException, BadPositionCategoryException {
        List<ImportInfo> explicitUses;
        List<ImportInfo> wildcardUses;
        int elementOffset;
        if (defElement == null) {
            return;
        }
        if (this.fHighlightHidVisitor == null) {
            return;
        }
        RfNamedElement element = defElement.getNamedElement();
        if (element == null) {
            return;
        }
        RfHidHolder hidHolder = element.getHidHolder();
        if (hidHolder != null) {
            hidHolder.visitHidObject(null, this.fHighlightHidVisitor);
        }
        if ((elementOffset = element.getStartOffset()) < this.getStartOffset() || elementOffset > this.getEndOffset()) {
            return;
        }
        HighlightKind elementHighlightKind = VhdlHlUtils.getHighlightKind(element);
        if (elementHighlightKind != null) {
            VhdlHlUtils.addPosition((IDocument)this.getDocument(), (int)elementOffset, (HighlightKind)elementHighlightKind, (Map)this.getPositions());
        }
        HighlightKind dataTypeHighlightKind = null;
        DataType dataType = null;
        if (element instanceof RfAlias) {
            dataType = ((RfAlias)element).getAliasedDataType();
            dataTypeHighlightKind = VhdlHlUtils.getHighlightKind(((RfAlias)element).getTranslatedType());
        } else if (element instanceof IRfAssociatedType) {
            dataType = ((IRfAssociatedType)((Object)element)).getDataType();
            dataTypeHighlightKind = HighlightKind.TYPE;
        }
        VhdlHlUtils.colorDataType(dataType, this.getDocument(), dataTypeHighlightKind, this.getPositions());
        List<ImportInfo> libraries = element.getLibraryClause();
        if (libraries != null && !libraries.isEmpty()) {
            for (ImportInfo library : libraries) {
                VhdlHlUtils.addPosition((IDocument)this.getDocument(), (int)library.getOffset(), (HighlightKind)HighlightKind.TYPE, (Map)this.getPositions());
            }
        }
        if ((wildcardUses = element.getWildcardUse()) != null && !wildcardUses.isEmpty()) {
            for (ImportInfo use : wildcardUses) {
                List<DataTypeChunk> dataTypeChunks = use.getUseClauseList();
                for (DataTypeChunk dataTypeChunk : dataTypeChunks) {
                    VhdlHlUtils.addPosition((IDocument)this.getDocument(), (int)dataTypeChunk.offset, (HighlightKind)HighlightKind.TYPE, (Map)this.getPositions());
                }
            }
        }
        if ((explicitUses = element.getExplicitUse()) != null && !explicitUses.isEmpty()) {
            for (ImportInfo use : explicitUses) {
                VhdlHlUtils.addPosition((IDocument)this.getDocument(), (int)use.getOffset(), (HighlightKind)VhdlHlUtils.getHighlightKind(use.getElement()), (Map)this.getPositions());
                List<DataTypeChunk> dataTypeChunks = use.getUseClauseList();
                for (DataTypeChunk dataTypeChunk : dataTypeChunks) {
                    VhdlHlUtils.addPosition((IDocument)this.getDocument(), (int)dataTypeChunk.offset, (HighlightKind)HighlightKind.TYPE, (Map)this.getPositions());
                }
            }
        }
    }

    protected Collection<RfDefElement> getChildren(RfDefElement root) {
        if (root == null) {
            return null;
        }
        return root.getChildren();
    }

    public void clean() {
        this.fHighlightHidVisitor = null;
        super.clean();
    }
}

