/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.hover;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.vhdldt.ui.editor.VhdlCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlCommentScanner;
import ro.amiq.vhdldt.ui.editor.VhdlPslCodeScanner;
import ro.amiq.vhdldt.ui.editor.VhdlStyle;
import ro.amiq.vhdldt.ui.editor.hover.VhdlHoverNonRuleBasedReconciler;
import ro.amiq.vhdldt.ui.editor.hover.VhdlHoverSourceViewerReconciler;

public class VhdlHoverSourceViewerConfiguration
extends SourceViewerConfiguration {
    private VhdlCodeScanner fCodeScanner;
    private VhdlCodeScanner fPslCodeScanner;
    private VhdlCommentScanner fCommentScanner;
    private VhdlStyle fColorManager;

    public VhdlHoverSourceViewerConfiguration(VhdlStyle colorManager) {
        this.fColorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__vhdl_psl_code", "__vhdl_literal", "__vhdl_sl_comment", "__vhdl_ml_comment"};
    }

    protected VhdlCodeScanner getCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new VhdlCodeScanner(this.fColorManager, 0);
            this.fCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected VhdlCodeScanner getPslCodeScanner() {
        if (this.fPslCodeScanner == null) {
            this.fPslCodeScanner = new VhdlPslCodeScanner(this.fColorManager, 0);
            this.fPslCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fPslCodeScanner;
    }

    protected VhdlCommentScanner getCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new VhdlCommentScanner(this.fColorManager, false, 0, false, null);
            this.fCommentScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        VhdlHoverSourceViewerReconciler dr1 = new VhdlHoverSourceViewerReconciler((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
        VhdlHoverSourceViewerReconciler dr2 = new VhdlHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr2, "__vhdl_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr2, "__vhdl_sl_comment");
        VhdlHoverSourceViewerReconciler dr3 = new VhdlHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr3, "__vhdl_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr3, "__vhdl_ml_comment");
        VhdlHoverSourceViewerReconciler dr4 = new VhdlHoverSourceViewerReconciler((ITokenScanner)this.getPslCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr4, "__vhdl_psl_code");
        reconciler.setRepairer((IPresentationRepairer)dr4, "__vhdl_psl_code");
        VhdlHoverNonRuleBasedReconciler ndr1 = new VhdlHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr1, "__vhdl_literal");
        reconciler.setRepairer((IPresentationRepairer)ndr1, "__vhdl_literal");
        return reconciler;
    }
}

