/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.hover;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;

public abstract class VhdlTextHoverParticipantCommon
implements ITextHoverParticipant {
    protected ITextEditor fTextEditor;

    public void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        if (region == null || textViewer == null) {
            return;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        int offset = region.getOffset();
        try {
            if (!DVTPlugin.getDefault().collect().c(project, "F7668646C")) {
                return;
            }
            int line = document.getLineOfOffset(offset);
            int col = offset - DVTDocumentUtils.documentLineOffset((Object)document, (int)line);
            tooltipContent.set(DVTTooltipContent.TooltipContent.LINE, Integer.valueOf(line + 1));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COLUMN, Integer.valueOf(col + 1));
            tooltipContent.set(DVTTooltipContent.TooltipContent.FILE, this.getTooltipContentFilePath(textViewer));
            String contextType = ((IDocumentExtension3)document).getContentType("__vhdl_partitioning", offset, false);
            if (contextType.equals("__dftl_partition_content_type")) {
                offset = Math.min(offset + 1, document.getLength() - 1);
                List<RfWNamedElementAndScope> elementScopes = RfUtils.getRfElements(this.getFile(), document, offset);
                if (elementScopes == null || elementScopes.isEmpty()) {
                    return;
                }
                RfWNamedElementAndScope elementScope = elementScopes.get(0);
                RfUtils.getTooltipFormattedText(elementScope, this.getEditor(), tooltipContent);
                BitFieldModel model = BitFieldUtils.getModelForEditor((DVTEditor)((DVTEditor)this.getEditor()), (IRfNamedElementAndScope)elementScope, (int)offset);
                if (Wavedrom.getInstance().isVSCode()) {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_REGISTER, model);
                } else {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_DIAGRAM, Wavedrom.getInstance().generateBitfieldSVG(model));
                }
            } else if (contextType.equals("__vhdl_sl_comment") || contextType.equals("__vhdl_ml_comment")) {
                try {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM, this.getWaveform(document, offset, contextType));
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            } else {
                IAnnotationModel annotationModel = this.getAnnotationModel();
                if (annotationModel != null) {
                    Iterator iter = annotationModel.getAnnotationIterator();
                    while (iter.hasNext()) {
                        Annotation annotation = (Annotation)iter.next();
                        Position position = annotationModel.getPosition(annotation);
                        if (!annotation.getType().equals("org.eclipse.ui.workbench.texteditor.spelling") || offset < position.getOffset() || offset > position.getOffset() + position.getLength()) continue;
                        tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, annotation.getText());
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract String getTooltipContentFilePath(ITextViewer var1);

    protected abstract IFile getFile();

    protected abstract String getWaveform(IDocument var1, int var2, String var3);

    protected abstract IAnnotationModel getAnnotationModel();

    protected abstract IProject getProject();
}

