/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hyperlink.DVTCommentHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkTimeoutException;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfAlias;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vhdldt.utils.VHDLLinkResolver;

public class CommentHyperlinkDetector
extends DVTCommentHyperlinkDetector {
    public CommentHyperlinkDetector(VhdlEditor editor) {
        super((DVTEditor)editor, (IRfSingleLangProject)editor.getRfProject());
    }

    public CommentHyperlinkDetector(IRfSingleLangProject project) {
        super(project);
    }

    protected List<IHyperlink> solveHyperlinkForAllCandidates(Collection<IRfNamedElement> candidates, String[] types, IRegion region, IDocument document, long timeoutTime) throws HyperlinkTimeoutException {
        ArrayList<IHyperlink> actionHyperlinks = new ArrayList<IHyperlink>();
        for (IRfNamedElement candidate : candidates) {
            this.recursiveSolveHyperlink(candidate, types, 0, actionHyperlinks, region, timeoutTime);
        }
        return actionHyperlinks;
    }

    protected void recursiveSolveHyperlink(IRfNamedElement currentElement, String[] types, int index, List<IHyperlink> actionHyperlinks, IRegion region, long timeoutTime) throws HyperlinkTimeoutException {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new HyperlinkTimeoutException();
        }
        if (!(currentElement instanceof RfNamedElement) || types == null) {
            return;
        }
        RfNamedElement element = (RfNamedElement)currentElement;
        if (element instanceof RfAlias) {
            ((RfAlias)element).getDeclarations();
        }
        if (index >= types.length) {
            RfNamedElementActionHyperlink hyperlink = RfUtils.createOpenAction(element.getDeclaration(), element.getRfProject().getProject(), region, this.getFullName(element));
            if (hyperlink != null && !actionHyperlinks.contains(hyperlink)) {
                actionHyperlinks.add((IHyperlink)hyperlink);
            }
            return;
        }
        List<RfNamedElement> members = VHDLLinkResolver.getCandidatesInScope(element);
        if (members == null) {
            return;
        }
        String name = VHDLLinkResolver.extractName(types[index]);
        String[] args = VHDLLinkResolver.extractArgs(types[index]);
        for (RfNamedElement member : members) {
            if (!types[index].equalsIgnoreCase(member.getName()) && !VHDLLinkResolver.isElementWithGenericParams(member, types[index], args, name)) continue;
            this.recursiveSolveHyperlink(member, types, index + 1, actionHyperlinks, region, timeoutTime);
        }
    }

    protected boolean isInCommentPartition(IDocument document, int offset) {
        String typedRegion = RfUtils.getTypedRegion(document, offset).getType();
        return "__vhdl_sl_comment".equals(typedRegion) || "__vhdl_ml_comment".equals(typedRegion);
    }

    protected Collection<IRfNamedElement> getInitialCandidates(IDocument document, int startOffset) throws BadLocationException {
        IRfScope scope = RfUtils.getRfScope((ITextEditor)this.getEditor(), document, startOffset);
        if (scope == null) {
            return null;
        }
        Collection<IRfNamedElement> result = VHDLLinkResolver.getInitialCandidatesInScope(scope);
        IRfScope elementScope = this.getRfScopeOfElementForCommentOffset((ITextEditor)this.getEditor(), document, startOffset);
        if (elementScope != null && !elementScope.equals(scope) && elementScope instanceof RfDefElement) {
            result.add(((RfDefElement)elementScope).getNamedElement());
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRfScope getRfScopeOfElementForCommentOffset(ITextEditor textEditor, IDocument document, int offset) throws BadLocationException {
        line = document.getLineOfOffset(offset);
        while (this.isInCommentPartition(document, offset)) {
            line = document.getLineOfOffset(offset);
            offset = document.getLineOffset(line + 1);
        }
        try {
            block11: {
                if (offset < 0) {
                    return null;
                }
                scanner = new DVTCharacterScanner(100, document, offset, true);
                ch = (char)scanner.read();
                if (ch == '\uffff') {
                    return null;
                }
                do {
                    if (Character.isWhitespace(ch)) continue;
                    project = this.getProject();
                    if (!(project instanceof RfProject)) {
                        return null;
                    }
                    break block11;
                } while ((ch = (char)scanner.read()) != '\uffff');
                return null;
            }
            skipMaxEmptyLinesAbove = (Integer)BuildConfigManager.getDVTConfig((IProject)project.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ABOVE_MAX_EMPTY_LINES);
            newLine = document.getLineOfOffset(scanner.getOffset());
            if (newLine - line > skipMaxEmptyLinesAbove + 1) {
                return null;
            }
            if (this.isInCommentPartition(document, scanner.getOffset())) {
                return null;
            }
            while (Character.isJavaIdentifierPart(ch)) {
                ch = (char)scanner.read();
                if (ch != '\uffff') continue;
                return null;
            }
            if (true) ** GOTO lbl39
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return RfUtils.getRfScope(textEditor, document, offset);
        do {
            if ((ch = (char)scanner.read()) != '\uffff') continue;
            return null;
lbl39:
            // 2 sources

        } while (Character.isWhitespace(ch));
        offset = scanner.getOffset();
        return RfUtils.getRfScope(textEditor, document, offset);
    }

    protected List<IRfNamedElement> getPackageCandidates(DVTCommentHyperlinkDetector.ParseCommentResult parsedComment) {
        IRfSingleLangProject project = this.getProject();
        if (!(project instanceof RfProject)) {
            return null;
        }
        return VHDLLinkResolver.getPackageCandidatesFromProject(parsedComment.getPackageName(), (RfProject)project);
    }

    private boolean isType(RfNamedElement element) {
        return element instanceof IRfVhdlTypeElement || element instanceof IRfDesignElement || element instanceof IRfPackageElement || element instanceof IRfBlockElement;
    }

    private String getFullName(RfNamedElement element) {
        RfNamedElement scope = element.getEnclosingScope();
        DVTStringBuilder fullName = new DVTStringBuilder().append(element.getName());
        if (element instanceof RfFunction) {
            RfFunction function = (RfFunction)element;
            fullName.append("(").append(function.hasArguments() ? function.getArgs(true, true, false) : "").append(")");
            String associatedTypeName = function.getAssociatedTypeName();
            if (associatedTypeName != null && !associatedTypeName.isEmpty()) {
                fullName.append(" : ").append(associatedTypeName);
            }
        } else if (element instanceof RfAlias) {
            RfAlias alias = (RfAlias)element;
            fullName.append(" of ").append(DataType.getFullTypeName(alias.getAliasedDataType(), false));
        }
        while (scope != null && this.isType(scope)) {
            fullName.prepend(scope instanceof RfPackage ? "::" : ".");
            fullName.prepend(scope.getName());
            scope = scope.getEnclosingScope();
        }
        fullName.prepend("Open " + element.getKindName() + " ");
        return fullName.toString();
    }
}

