/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkWrapper;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.hyperlink.MultipleHyperlinksDialog;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.views.layers.QuickLayersViewHandler;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vhdldt.model.reflection.IRfScope;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfEnum;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfFunctionsHolder;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vhdldt.model.reflection.util.VHDLRfGUIReferencesUtils;
import ro.amiq.vhdldt.ui.editor.VhdlEditor;
import ro.amiq.vhdldt.ui.editor.VhdlWordFinder;
import ro.amiq.vhdldt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vhdldt.ui.editor.actions.ShowInstancesInDesignHierarchyViewAction;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfHyperlinkDetectorCommon;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfHyperlinkUtils;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vhdldt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vhdldt.ui.search.SearchQueryProvider;

public class RfHyperlinkDetector
extends RfHyperlinkDetectorCommon {
    public RfHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    public IDVTHyperlink[] detectHyperlinksInternal(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || !(this.fTextEditor instanceof VhdlEditor)) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (!(this.fTextEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fTextEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        final IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        int offset = Math.min(region.getOffset() + 1, document.getLength() - 1);
        ArrayList<IDVTHyperlink> hyperlinks = new ArrayList<IDVTHyperlink>();
        boolean isHyperlinkRunTimeInfoEnabled = BuildConfigManager.isDebugHyperlinkRunTimeInfo((IProject)project);
        long start = System.currentTimeMillis();
        List<RfWNamedElementAndScope> elementsAndScope = RfUtils.getRfElements(this.fTextEditor, document, offset);
        if (isHyperlinkRunTimeInfoEnabled) {
            DVTHyperlinkUtils.getInstance().reportHyperlinkElementFromCursorBenchmark(System.currentTimeMillis() - start);
        }
        if (elementsAndScope == null || elementsAndScope.isEmpty()) {
            return null;
        }
        start = System.currentTimeMillis();
        try {
            boolean hasMultipleMethodHyperlinks;
            ArrayList<IDVTHyperlink> otherDeclarationHyperlinks;
            IDVTHyperlink openDeclaration;
            IRegion hyperlinkRegion;
            IRfScope scope;
            boolean isFunction;
            RfNamedElementActionHyperlink hyperlinkAction;
            IRfNamedElement element;
            RfFunctionsHolder originalFunctionHolder;
            RfWNamedElementAndScope elementAndScope;
            block55: {
                block51: {
                    elementAndScope = elementsAndScope.get(0);
                    originalFunctionHolder = null;
                    element = elementAndScope.getIRfNamedElement();
                    if (element instanceof RfFunctionsHolder) {
                        originalFunctionHolder = (RfFunctionsHolder)element;
                        element = ((RfFunctionsHolder)element).getLastDefinedFunction();
                    }
                    if ((hyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, (isFunction = element instanceof RfFunction) ? ((RfFunction)element).getPrototype() : element, scope = elementAndScope.getScope(), hyperlinkRegion = VhdlWordFinder.getDefault().getWordAtOffset(document, offset))) == null) {
                        return null;
                    }
                    openDeclaration = this.createHyperlink(hyperlinkAction, DVTHyperlinkMessages.openDeclaration);
                    otherDeclarationHyperlinks = new ArrayList<IDVTHyperlink>();
                    hasMultipleMethodHyperlinks = false;
                    if (elementsAndScope.size() <= 1) break block51;
                    int i = 0;
                    while (i < elementsAndScope.size()) {
                        block54: {
                            Iterator functions;
                            IRfScope otherDeclScope;
                            block53: {
                                IRfNamedElement otherDeclElement;
                                block52: {
                                    otherDeclElement = elementsAndScope.get(i).getIRfNamedElement();
                                    otherDeclScope = elementsAndScope.get(i).getScope();
                                    functions = new ArrayList<RfFunction>();
                                    if (!(otherDeclElement instanceof RfFunctionsHolder)) break block52;
                                    functions.addAll(((RfFunctionsHolder)otherDeclElement).getLocalMembers(RfFunction.class));
                                    break block53;
                                }
                                if (!(otherDeclElement instanceof RfFunction)) break block54;
                                functions.add((RfFunction)otherDeclElement);
                            }
                            hasMultipleMethodHyperlinks = true;
                            Iterator iterator = functions.iterator();
                            while (iterator.hasNext()) {
                                RfFunction func = (RfFunction)iterator.next();
                                this.addMultipleFunctionHyperlinks(otherDeclarationHyperlinks, func, otherDeclScope, hyperlinkRegion, project, document, offset);
                            }
                        }
                        ++i;
                    }
                    break block55;
                }
                if (originalFunctionHolder != null) {
                    List<RfFunction> functions = originalFunctionHolder.getLocalMembers(RfFunction.class);
                    if (functions.size() > 1) {
                        hasMultipleMethodHyperlinks = true;
                    }
                    for (RfFunction func : functions) {
                        this.addMultipleFunctionHyperlinks(otherDeclarationHyperlinks, func, elementAndScope.getScope(), hyperlinkRegion, project, document, offset);
                    }
                }
            }
            boolean showFirstOpenDeclaration = DVTUtilsCommon.INSTANCE.showHyperlinkAction(element.getDeclaration(), element.getName(), offset, file.getLocation());
            List<RfNamedElementActionHyperlink> entityAndArchitectureActions = RfUtils.getEntityAndArchitectureHyperlinks(project, elementAndScope, hyperlinkAction.getHyperlinkRegion(), RfUtils.getCurrentBCArchitecture(project, (DVTEditor)this.fTextEditor));
            if (canShowMultipleHyperlinks && !entityAndArchitectureActions.isEmpty()) {
                boolean isComponentInInstance;
                for (RfNamedElementActionHyperlink action : entityAndArchitectureActions) {
                    if (action == null) continue;
                    String prefix = action.hasShowMore() ? "+ " : "";
                    IRfNamedElement actionElement = action.getRfNamedElement();
                    if (actionElement instanceof RfArchitecture) {
                        hyperlinks.add(this.createHyperlink(action, String.valueOf(prefix) + DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openArchitectureDeclaration, (Object[])new Object[]{actionElement.getName()})));
                        continue;
                    }
                    if (actionElement instanceof RfEntity) {
                        hyperlinks.add(this.createHyperlink(action, String.valueOf(prefix) + DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openEntityDeclaration, (Object[])new Object[]{actionElement.getName()})));
                        continue;
                    }
                    if (actionElement instanceof RfComponent) {
                        hyperlinks.add(this.createHyperlink(action, DVTHyperlinkMessages.openComponentDeclaration));
                        continue;
                    }
                    if (actionElement instanceof RfConfiguration) {
                        hyperlinks.add(this.createHyperlink(action, DVTHyperlinkMessages.openConfigurationDeclaration));
                        continue;
                    }
                    Object[] args = new Object[]{RfUtils.getCrossLanguageHyperlinkLabelPart(actionElement), actionElement.getName()};
                    hyperlinks.add(this.createHyperlink(action, DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openCrossLanguageInstanceTypeDeclaration, (Object[])args)));
                }
                boolean bl = isComponentInInstance = RfUtils.isComponent(element) && scope != null && scope.getNamedElement() instanceof RfInstance;
                if (showFirstOpenDeclaration && !isComponentInInstance) {
                    hyperlinks.add(0, openDeclaration);
                } else {
                    hyperlinks.add(openDeclaration);
                }
            } else if (canShowMultipleHyperlinks) {
                if (hasMultipleMethodHyperlinks) {
                    for (IDVTHyperlink otherDeclHyperlink : otherDeclarationHyperlinks) {
                        hyperlinks.add(otherDeclHyperlink);
                    }
                    hyperlinks.add(this.createShowOverloadHyperlink(hyperlinkAction));
                } else {
                    boolean isInConfigRuleScope;
                    RfNamedElementActionHyperlink associatedTypeAction;
                    RfFunction implementation;
                    RfNamedElementActionHyperlink implementationHyperlinkAction;
                    hyperlinks.add(openDeclaration);
                    if (isFunction && (implementationHyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, implementation = ((RfFunction)element).getImplementation(), scope, hyperlinkRegion)) != null) {
                        hyperlinks.add(this.createHyperlink(implementationHyperlinkAction, DVTHyperlinkMessages.openImplementation));
                    }
                    RfNamedElementActionHyperlink rfNamedElementActionHyperlink = associatedTypeAction = (isInConfigRuleScope = RfUtils.isInConfigRuleScope(scope)) ? null : RfUtils.getAssociatedTypeHyperlink(project, element, hyperlinkAction.getHyperlinkRegion());
                    if (associatedTypeAction != null) {
                        String labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(element);
                        String hyperlinkLabel = labelType.isEmpty() ? DVTHyperlinkMessages.openEmptyTypeDeclaration : DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openTypeDeclaration, (Object[])new Object[]{labelType});
                        hyperlinks.add(this.createHyperlink(associatedTypeAction, hyperlinkLabel));
                    }
                }
            } else {
                hyperlinks.add(openDeclaration);
            }
            final IRfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
            this.createOpenInstanceHyperlink(this.fTextEditor, hyperlinkRegion, namedElement, hyperlinks);
            this.createShowInstancesHyperlink(hyperlinkAction, hyperlinks, namedElement);
            this.createShowInstancesInDHHyperlink(hyperlinkAction, hyperlinks, namedElement);
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            IDVTHyperlink jtaHyperlink = RfHyperlinkUtils.getJumpToAssignmentHyperlink(hyperlinkAction, offset, file, this.fTextEditor, rfProject, namedElement);
            if (jtaHyperlink != null) {
                hyperlinks.add(jtaHyperlink);
            }
            if (hyperlinkAction.getRfNamedElement() instanceof RfEnum) {
                hyperlinks.add(this.createJumpToStateMachineHyperlink(document, (RfNamedElement)hyperlinkAction.getRfNamedElement(), file, hyperlinkAction, region.getOffset()));
            }
            if (originalFunctionHolder == null || !originalFunctionHolder.hasMultipleFunctions()) {
                hyperlinks.add(this.createUsagesHyperlink(element, hyperlinkAction.getScope(), project, hyperlinkRegion));
            }
            this.createShowReadersHyperlink(hyperlinkAction, hyperlinks);
            this.createShowWritersHyperlink(hyperlinkAction, hyperlinks);
            if (!(namedElement instanceof RfInstance) && !RfUtils.isComponent(namedElement)) {
                IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
                return iDVTHyperlinkArray;
            }
            if (RfUtils.isComponent(namedElement)) {
                IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
                return iDVTHyperlinkArray;
            }
            if (scope != null && scope.getEnclosingScope(RfConfiguration.class) != null) {
                IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
                return iDVTHyperlinkArray;
            }
            List instances = Collections.emptyList();
            instances = namedElement instanceof RfInstance ? DVTHyperlinkUtils.getInstance().getInstancesFor((IRfInstanceElement)((RfInstance)namedElement), true, project, 2) : DVTHyperlinkUtils.getInstance().getInstancesFor(namedElement, true, project, 2);
            if (instances.size() <= 1) {
                IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
                return iDVTHyperlinkArray;
            }
            hyperlinks.add(new IDVTHyperlink(){
                private List<ELInstance> allInstances;

                public void updateGuiPart() {
                    new MultipleHyperlinksDialog(this.getMultipleOpenHyperlinks(this.allInstances)).open();
                }

                public boolean updateNonGuiPart() {
                    this.allInstances = Collections.emptyList();
                    this.allInstances = namedElement instanceof RfInstance ? DVTHyperlinkUtils.getInstance().getInstancesFor((IRfInstanceElement)namedElement, true, project, Integer.MAX_VALUE) : DVTHyperlinkUtils.getInstance().getInstancesFor(namedElement, true, project, Integer.MAX_VALUE);
                    if (this.allInstances.isEmpty()) {
                        return false;
                    }
                    List<HyperlinkWrapper> links = this.getMultipleOpenHyperlinks(this.allInstances);
                    return !links.isEmpty();
                }

                public String getTypeLabel() {
                    return "+ Show more...";
                }

                public String getHyperlinkText() {
                    return "+ Show more...";
                }

                public IRegion getHyperlinkRegion() {
                    return hyperlinkAction.getHyperlinkRegion();
                }

                private List<HyperlinkWrapper> getMultipleOpenHyperlinks(List<ELInstance> allInstances) {
                    ArrayList<HyperlinkWrapper> multipleOpenHyperlinkList = new ArrayList<HyperlinkWrapper>(7);
                    for (ELInstance instance : allInstances) {
                        IRfInstanceElement description = instance.getDescription();
                        if (!(description instanceof RfInstance) || !ELUtils.hasValidBinding((ELInstance)instance)) continue;
                        IRfNamedElement entity = instance.getBinding(true);
                        RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(entity, project, hyperlinkRegion);
                        createOpenAction.setScope(scope);
                        createOpenAction.setElementPath(instance.getHierarchyPath());
                        IDVTHyperlink newLink = RfHyperlinkDetector.this.createHyperlink(createOpenAction, "Open Entity Declaration");
                        multipleOpenHyperlinkList.add(new HyperlinkWrapper(newLink, (IActionHyperlink)createOpenAction));
                        IRfNamedElement architecture = instance.getBinding(false);
                        if (architecture == null) continue;
                        createOpenAction = RfUtils.createOpenAction(architecture, project, hyperlinkRegion);
                        createOpenAction.setScope(scope);
                        createOpenAction.setElementPath(instance.getHierarchyPath());
                        newLink = RfHyperlinkDetector.this.createHyperlink(createOpenAction, "Open Architecture Declaration");
                        multipleOpenHyperlinkList.add(new HyperlinkWrapper(newLink, (IActionHyperlink)createOpenAction));
                    }
                    return multipleOpenHyperlinkList;
                }
            });
            IDVTHyperlink[] iDVTHyperlinkArray = hyperlinks.toArray(new IDVTHyperlink[hyperlinks.size()]);
            return iDVTHyperlinkArray;
        }
        finally {
            if (isHyperlinkRunTimeInfoEnabled) {
                DVTHyperlinkUtils.getInstance().reportHyperlinkProposalsBenchmark(System.currentTimeMillis() - start);
            }
        }
    }

    protected void openShowInstances(IRfNamedElement namedElement) {
        ShowInstancesAction.showInstances(namedElement);
    }

    private void createShowInstancesHyperlink(RfNamedElementActionHyperlink hyperlink, List<IDVTHyperlink> hyperlinks, IRfNamedElement namedElement) {
        boolean canHaveInstances = RfSearchUtils.isInstantiable((IRfNamedElement)namedElement);
        if (!canHaveInstances) {
            return;
        }
        hyperlinks.add(this.createInstancesHyperlink(hyperlink, namedElement));
    }

    private void createShowInstancesInDHHyperlink(RfNamedElementActionHyperlink hyperlink, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        if (namedElement == null) {
            return;
        }
        boolean canHaveInstances = RfSearchUtils.isInstantiable((IRfNamedElement)namedElement);
        if (!canHaveInstances) {
            return;
        }
        IRfSingleLangProject project = namedElement.getRfProject();
        if (project == null || project.getELManager() == null) {
            return;
        }
        links.add(this.createShowInstancesInDHHyperlink(hyperlink, namedElement));
    }

    private IDVTHyperlink createInstancesHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement namedElement) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showInstances;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                ShowInstancesAction.showInstances(namedElement);
            }
        };
    }

    private IDVTHyperlink createShowInstancesInDHHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                String message = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.showInstancesInDH, (Object[])new Object[]{element.getName()});
                return message;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                ShowInstancesInDesignHierarchyViewAction.showInstancesInDHFor(element);
            }
        };
    }

    protected void openShowInstancesInDH(IRfNamedElement element) {
        ShowInstancesInDesignHierarchyViewAction.showInstancesInDHFor(element);
    }

    private void addMultipleFunctionHyperlinks(List<IDVTHyperlink> hyperlinks, RfFunction element, IRfScope scope, IRegion hyperlinkRegion, IProject project, IDocument document, int offset) {
        IRegion otherDeclHyperlinkRegion = VhdlWordFinder.getDefault().getWordAtOffset(document, offset);
        RfNamedElementActionHyperlink otherDeclHyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, element.getPrototype(), scope, otherDeclHyperlinkRegion);
        if (otherDeclHyperlinkAction == null) {
            return;
        }
        hyperlinks.add(this.createHyperlink(otherDeclHyperlinkAction, String.valueOf(DVTHyperlinkMessages.openDeclaration) + " '" + element.getSignature() + "'"));
        RfFunction implementation = element.getImplementation();
        RfNamedElementActionHyperlink implementationHyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, implementation, scope, hyperlinkRegion);
        if (implementationHyperlinkAction != null) {
            hyperlinks.add(this.createHyperlink(implementationHyperlinkAction, String.valueOf(DVTHyperlinkMessages.openImplementation) + " '" + implementation.getSignature() + "'"));
        }
    }

    private IDVTHyperlink createShowOverloadHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showOverload;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    new QuickLayersViewHandler().execute(null);
                }
                catch (ExecutionException executionException) {}
            }
        };
    }

    protected void openShowReadersUsages(IActionHyperlink hyperlinkAction) {
        if (!(hyperlinkAction instanceof RfNamedElementActionHyperlink)) {
            return;
        }
        RfNamedElementActionHyperlink hyperlink = (RfNamedElementActionHyperlink)hyperlinkAction;
        IRegion region = hyperlink.getHyperlinkRegion();
        if (region == null) {
            return;
        }
        VHDLRfGUIReferencesUtils.showReadersUsages(hyperlink.getRfNamedElement(), hyperlink.getProject(), this.fTextEditor, region.getOffset(), null);
    }

    protected void openShowWritersUsages(IActionHyperlink hyperlinkAction) {
        if (!(hyperlinkAction instanceof RfNamedElementActionHyperlink)) {
            return;
        }
        RfNamedElementActionHyperlink hyperlink = (RfNamedElementActionHyperlink)hyperlinkAction;
        IRegion region = hyperlink.getHyperlinkRegion();
        if (region == null) {
            return;
        }
        VHDLRfGUIReferencesUtils.showWritersUsages(hyperlink.getRfNamedElement(), hyperlink.getProject(), this.fTextEditor, region.getOffset(), null);
    }

    private IDVTHyperlink createUsagesHyperlink(final IRfNamedElement namedElement, final IRfScopeElement scope, final IProject project, final IRegion hyperlinkRegion) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkRegion;
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showUsages;
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public void updateGuiPart() {
                try {
                    RfProject rfProject = RfManager.getInstance().getRfProject(project);
                    String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
                    FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false);
                    ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, true, false, true, searchScope, RfHyperlinkDetector.this.fTextEditor instanceof DVTEditor ? (DVTEditor)RfHyperlinkDetector.this.fTextEditor : null, hyperlinkRegion.getOffset(), scope);
                    ISearchQuery query = new SearchQueryProvider(1, 8, false, true, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
                    if (query != null) {
                        NewSearchUI.runQueryInBackground((ISearchQuery)query);
                    }
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
    }

    protected IActionHyperlink createOpenAction(IRfInstanceElement targetNamedElement, IProject project, IRegion region) {
        return RfUtils.createOpenAction((IRfNamedElement)targetNamedElement, project, region);
    }

    protected void setDataForBreadcrumb(IActionHyperlink hyperlink, String label) {
    }

    protected LanguageKind getSourceLanguageKind() {
        return LanguageKind.VHDL;
    }

    public DVTWordFinder getWordFinder() {
        return VhdlWordFinder.getDefault();
    }

    public List<String> getDefaultHyperlinks() {
        return DVTHyperlinkMessages.getVHDLDefaultHyperlinks();
    }
}

