/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.hyperlink;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vhdldt.utils.VhdlFileUtils;

public abstract class RfHyperlinkDetectorCommon
extends DVTHyperlinkDetector {
    public IDVTHyperlink createJumpToStateMachineHyperlink(final IDocument document, final RfNamedElement namedElement, final IFile file, final RfNamedElementActionHyperlink hyperlinkAction, final int offset) {
        return new IDVTHyperlink(){

            Region getMatchRegion(int start) {
                try {
                    Pattern pattern = Pattern.compile("(?i)WHEN\\s*(" + namedElement.getName() + ")\\b");
                    int step = 100;
                    int sight = 2 * step;
                    int docLen = document.getLength();
                    String chunkAll = document.get();
                    int iChunk = start;
                    while (iChunk < docLen) {
                        String chunk = chunkAll.substring(iChunk, Math.min(iChunk + sight, docLen));
                        if (chunk.indexOf(namedElement.getName()) >= 0) {
                            Matcher matcher = pattern.matcher(chunk);
                            int matchOffset = -1;
                            while (matcher.find()) {
                                matchOffset = matcher.start(1);
                                if (!"__dftl_partition_content_type".equals(RfUtils.getTypedRegion(document, iChunk + matchOffset).getType())) continue;
                                return new Region(iChunk + matchOffset, namedElement.getName().length());
                            }
                        }
                        iChunk += step;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return null;
            }

            public void updateGuiPart() {
                Region region = this.getMatchRegion(offset + 1);
                if (region != null) {
                    VhdlFileUtils.getInstance().openEditor(file, (IRegion)region);
                    return;
                }
                region = this.getMatchRegion(0);
                if (region != null) {
                    VhdlFileUtils.getInstance().openEditor(file, (IRegion)region);
                    return;
                }
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.jumpToStateMachine;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.jumpToStateMachine;
            }

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }
        };
    }
}

