/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.lazy.outline;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfKind;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.ui.editor.lazy.outline.VhdlLazyOutlineProviderCommon;

public class VhdlLazyOutlineProvider
extends VhdlLazyOutlineProviderCommon {
    public static final Map<String, String> VHDL_OUTLINE_FIELDS = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Show aliases", "outline.show_aliases");
            this.put("Show architectures", "outline.show_architectures");
            this.put("Show blocks", "outline.show_blocks");
            this.put("Show components", "outline.show_components");
            this.put("Show configurations", "outline.show_configurations");
            this.put("Show entities", "outline.show_entities");
            this.put("Show functions", "outline.show_functions");
            this.put("Show instances", "outline.show_instances");
            this.put("Show packages", "outline.show_packages");
            this.put("Show package bodies", "outline.show_package_bodies");
            this.put("Show package instances", "outline.show_package_instances");
            this.put("Show ports", "outline.show_ports");
            this.put("Show processes", "outline.show_processes");
            this.put("Show properties & sequences", "outline.show_sequences");
            this.put("Show signals", "outline.show_signals");
            this.put("Show subprogram instances", "outline.show_subprogram_instances");
            this.put("Show types & subtypes", "outline.show_types");
            this.put("Show type bodies", "outline.show_type_bodies");
            this.put("Show variables", "outline.show_variables");
            this.put("Show vunits", "outline.show_vunits");
        }
    };

    public VhdlLazyOutlineProvider(DVTEditor editor) {
        super(editor);
    }

    public IRfFileDef getFileDef() {
        if (this.editor == null) {
            return null;
        }
        IFile currentFile = this.editor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)currentFile);
    }

    public boolean isUnnamedBlock(IRfDefElement def) {
        return false;
    }

    public int getCategory(IRfDefElement def) {
        IRfNamedElement namedElem = def.getNamedElement();
        RfKind kind = RfKind.of(namedElem);
        return kind.ordinal();
    }

    public boolean isLexicallySorted() {
        return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
    }

    public boolean isCategoricallySorted() {
        return VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
    }
}

