/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.lazy.outline;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfImplicitDef;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;

public enum VhdlOutlineUtil {
    INSTANCE;

    private static final ElementType.ElementTypeName[] parentElements;
    private static final Set<ElementType.ElementTypeName> PARENT_ELEMENTS_SET;
    private OutlineTreeViewProvider labelProvider = new OutlineTreeViewProvider();

    static {
        parentElements = new ElementType.ElementTypeName[]{ElementType.ElementTypeName.ARCHITECTURE, ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeName.COMPONENT, ElementType.ElementTypeName.CONFIGURATION, ElementType.ElementTypeName.ENTITY, ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeName.PACKAGE_BODY, ElementType.ElementTypeName.TYPE_BODY, ElementType.ElementTypeName.VUNIT};
        PARENT_ELEMENTS_SET = EnumSet.copyOf(Arrays.asList(parentElements));
    }

    public boolean isOutlineElement(IRfDefElement element) {
        if (!(element instanceof RfDefElement)) {
            return false;
        }
        if (element instanceof RfImplicitDef) {
            return false;
        }
        RfProject rfProject = ((RfDefElement)element).getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        return elementType != null;
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement element) {
        RfTreeElementWrapper wrapper = new RfTreeElementWrapper(element);
        DVTGUIFilterMatcher.GUIFilterResult result = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.OUTLINE, (IRfDefElement)element, () -> this.labelProvider.getText((Object)wrapper));
        return result;
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        if (def == null) {
            return false;
        }
        IRfSingleLangProject rfProject = def.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(def, null, null);
        if (elementType == null) {
            return false;
        }
        return PARENT_ELEMENTS_SET.contains(elementType.getElementTypeName());
    }
}

