/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.outline;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfPackage;
import ro.amiq.vhdldt.model.reflection.RfPackageBody;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfPropertySequence;
import ro.amiq.vhdldt.model.reflection.RfVUnit;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vhdldt.ui.editor.outline.CategorySortingAction;

public class ViewCategorySortingAction
extends CategorySortingAction {
    private VhdlCategorySorter fSorter;
    private TreeViewer fTreeViewer;

    public ViewCategorySortingAction(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
        this.fSorter = new VhdlCategorySorter();
        boolean disabled = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
        this.setEnabled(!disabled);
        if (!disabled) {
            boolean checked = VhdlPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
            this.valueChanged(checked);
        }
    }

    @Override
    protected void valueChanged(boolean on) {
        super.valueChanged(on);
        this.fTreeViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
    }

    private static class VhdlCategorySorter
    extends ViewerSorter {
        private VhdlCategorySorter() {
        }

        public int category(Object obj) {
            if (obj instanceof RfTreeElementWrapper) {
                Object elem = ((RfTreeElementWrapper)((Object)obj)).getRfElement();
                if (elem instanceof RfDefElement) {
                    elem = ((RfDefElement)elem).getNamedElement();
                }
                if (elem instanceof RfEntity) {
                    return 0;
                }
                if (elem instanceof RfArchitecture) {
                    return 1;
                }
                if (elem instanceof RfPackage) {
                    return 2;
                }
                if (elem instanceof RfPackageBody) {
                    return 3;
                }
                if (elem instanceof RfPort) {
                    RfPort port = (RfPort)elem;
                    if (port.isInput()) {
                        return 0;
                    }
                    if (port.isInout()) {
                        return 1;
                    }
                    if (port.isBuffer()) {
                        return 2;
                    }
                    if (port.isLinkage()) {
                        return 3;
                    }
                    if (port.isOutput()) {
                        return 4;
                    }
                    return 5;
                }
                if (elem instanceof RfVariable) {
                    return 6;
                }
                if (elem instanceof RfFunction) {
                    if (((RfFunction)elem).isTask()) {
                        return 7;
                    }
                    return 8;
                }
                if (elem instanceof RfBlock) {
                    return 9;
                }
                if (elem instanceof RfProcess) {
                    return 10;
                }
                if (elem instanceof RfComponent) {
                    return 11;
                }
                if (elem instanceof RfInstance) {
                    return 12;
                }
                if (elem instanceof RfPropertySequence) {
                    return 13;
                }
                if (elem instanceof RfVUnit) {
                    return 14;
                }
            }
            return 100;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int line2;
            int cat2;
            if (!(((RfTreeElementWrapper)((Object)e1)).getRfElement() instanceof RfDefElement) || !(((RfTreeElementWrapper)((Object)e2)).getRfElement() instanceof RfDefElement)) {
                return 0;
            }
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            int line1 = ((RfDefElement)((RfTreeElementWrapper)((Object)e1)).getRfElement()).getStartLine();
            if (line1 == (line2 = ((RfDefElement)((RfTreeElementWrapper)((Object)e2)).getRfElement()).getStartLine())) {
                return 0;
            }
            if (line1 > line2) {
                return 1;
            }
            return -1;
        }
    }
}

