/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.pathmanager;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vhdldt.model.reflection.RfArchitecture;
import ro.amiq.vhdldt.model.reflection.RfBlock;
import ro.amiq.vhdldt.model.reflection.RfComponent;
import ro.amiq.vhdldt.model.reflection.RfConfiguration;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfDefElementWithLabel;
import ro.amiq.vhdldt.model.reflection.RfEntity;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;

public abstract class VhdlDesignPathProviderCommon
implements IDesignPathProvider {
    public boolean validDesignScope(Object element) {
        if (element instanceof RfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        } else if (element instanceof RfDefElementWithLabel) {
            element = ((RfDefElementWithLabel)element).getNamedElement();
        }
        return element instanceof RfArchitecture || element instanceof RfComponent || element instanceof RfEntity || element instanceof RfConfiguration || element instanceof RfBlock && (((RfBlock)element).isGenerate() || IRfNamedElement.ElementKind.VHDL_BLOCK.equals((Object)((RfBlock)element).getKind()));
    }

    public Set<IRfNamedElement> getNamedElementsSet(IRfDefElement defElement) {
        HashSet<IRfNamedElement> result = new HashSet<IRfNamedElement>();
        if (defElement == null) {
            return result;
        }
        if (defElement instanceof RfDefElement) {
            result.addAll(Arrays.asList(((RfDefElement)defElement).getNamedElements()));
        } else {
            result.add(defElement.getNamedElement());
        }
        return result;
    }

    public boolean isInstanceDef(IRfDefElement defElem) {
        if (defElem == null) {
            return false;
        }
        return defElem.getNamedElement() instanceof RfInstance;
    }

    public boolean isPort(IRfFieldElement field) {
        return !field.isParameter() && !field.isTypeParameter() && field instanceof RfVariable;
    }

    public IRfNamedElement computeHyperlinkNamedElement(IRfNamedElement hyperlinkNamedElem, IRfDesignElement leafDesign, boolean inhibited) {
        List ports;
        IRfDesignElement hyperlinkDesign = DesignUtils.getDesign((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)hyperlinkNamedElem, (boolean)true));
        if (this.useCurrentPath((IRfNamedElement)hyperlinkDesign)) {
            return null;
        }
        if (inhibited) {
            return hyperlinkDesign;
        }
        if (hyperlinkDesign instanceof RfPort && (ports = leafDesign.getPortsWithPrefix("", 2)) != null && ports.contains(hyperlinkDesign)) {
            return null;
        }
        if (hyperlinkDesign instanceof RfVariable && ((RfVariable)hyperlinkDesign).isParameter()) {
            if (!(leafDesign instanceof RfNamedElement)) {
                return null;
            }
            List<RfVariable> variablesWithPrefix = ((RfNamedElement)leafDesign).getVariablesWithPrefix("", 2, true);
            if (variablesWithPrefix != null && variablesWithPrefix.contains(hyperlinkDesign)) {
                return null;
            }
        }
        return hyperlinkDesign;
    }

    private boolean useCurrentPath(IRfNamedElement hyperlinkNamedElement) {
        if (hyperlinkNamedElement instanceof IRfDesignElement) {
            return false;
        }
        if (hyperlinkNamedElement instanceof RfPort) {
            return false;
        }
        return !(hyperlinkNamedElement instanceof RfVariable) || !((RfVariable)hyperlinkNamedElement).isParameter();
    }

    public IDVTFileInstance getFileInstance(IFile file, boolean acceptAny) {
        List fileInstances;
        block11: {
            IRfFileDef fileDef;
            IProject project;
            block10: {
                Object wrapper;
                block9: {
                    block8: {
                        block7: {
                            try {
                                if (file != null) break block7;
                                return null;
                            }
                            catch (CoreException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        wrapper = file.getSessionProperty(IDVTConstants.FILE_INSTANCE_QN);
                        if (wrapper instanceof IDVTElementWrapper) break block8;
                        return null;
                    }
                    wrapper = ((IDVTElementWrapper)wrapper).getRfElement();
                    project = file.getProject();
                    if (project != null) break block9;
                    return null;
                }
                IRfFileDef iRfFileDef = fileDef = wrapper instanceof IRfFileDef ? (IRfFileDef)wrapper : this.getFileDef(project, file);
                if (fileDef != null) break block10;
                return null;
            }
            fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, fileDef.getParserPath());
            if (fileInstances != null && !fileInstances.isEmpty()) break block11;
            return null;
        }
        return (IDVTFileInstance)fileInstances.get(0);
    }

    public IRfFileDef getFileDef(IProject project, IFile file) {
        if (project == null || file == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)file);
    }
}

