/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickassist;

import java.util.HashSet;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.ui.editor.quickassist.VhdlAbstractQuickAssistProcessor;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;

public abstract class AbstractQuickAssistExtractProcessorCommon
extends VhdlAbstractQuickAssistProcessor {
    protected RfDefElement fStartScope;
    protected RfDefElement fEndScope;
    protected RfDefElement fClosestContainer;
    protected String fSelectedText;
    protected int fStartOffset;
    protected int fEndOffset;

    protected AbstractQuickAssistExtractProcessorCommon(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        RfDefElement parentScope;
        if (!super.init()) {
            return false;
        }
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        this.fSelectedText = textSelection.getText();
        this.fStartOffset = textSelection.getOffset();
        this.fEndOffset = textSelection.getOffset() + textSelection.getLength();
        this.fStartScope = (RfDefElement)RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fStartOffset);
        this.fEndScope = (RfDefElement)RfUtils.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fEndOffset);
        if (this.fStartScope != this.fEndScope) {
            return false;
        }
        HashSet<Class<RfTypeBody>> classes = new HashSet<Class<RfTypeBody>>();
        classes.add(RfFunction.class);
        classes.add(RfProcess.class);
        classes.add(RfTypeBody.class);
        this.fClosestContainer = parentScope = VhdlQuickFixUtil.getInstance().getEnclosingDefAtOffset(this.fStartOffset, this.fEditor, classes);
        return this.fClosestContainer != null;
    }

    public boolean validate() {
        block13: {
            block12: {
                String endOffsetContentType;
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    if (!this.fSelectedText.trim().isEmpty()) break block8;
                                    return false;
                                }
                                catch (Exception e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return false;
                                }
                            }
                            if (this.fStartOffset <= 0 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fStartOffset - 1, 1).charAt(0))) break block9;
                            return false;
                        }
                        if (this.fEndOffset >= this.fDocument.getLength() - 1 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fEndOffset, 1).charAt(0))) break block10;
                        return false;
                    }
                    String startOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__vhdl_partitioning", this.fStartOffset, false);
                    endOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__vhdl_partitioning", this.fEndOffset, false);
                    if (startOffsetContentType.equals("__dftl_partition_content_type") || this.fStartOffset <= 0 || ((IDocumentExtension3)this.fDocument).getContentType("__vhdl_partitioning", this.fStartOffset - 1, false).equals("__dftl_partition_content_type")) break block11;
                    return false;
                }
                if (endOffsetContentType.equals("__dftl_partition_content_type") || this.fEndOffset >= this.fDocument.getLength() - 1 || ((IDocumentExtension3)this.fDocument).getContentType("__vhdl_partitioning", this.fEndOffset - 1, false).equals("__dftl_partition_content_type") || ((IDocumentExtension3)this.fDocument).getContentType("__vhdl_partitioning", this.fEndOffset + 1, false).equals("__dftl_partition_content_type")) break block12;
                return false;
            }
            if (DVTDocumentUtils.hasNestedParentheses((IDocument)this.fDocument, (int)this.fStartOffset, (int)this.fEndOffset, (String)"__vhdl_partitioning")) break block13;
            return false;
        }
        return !DVTQuickAssistUtil.selectionContainsOnlyLastPartOfHid((IRfDefElement)this.fClosestContainer, (int)this.fStartOffset, (int)this.fEndOffset);
    }

    protected abstract ISelection getSelection();
}

