/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.editor.quickassist.AbstractQuickAssistExtractProcessor;
import ro.amiq.vhdldt.ui.editor.quickassist.VhdlSelectionTypeVisitor;
import ro.amiq.vhdldt.ui.editor.quickfix.QuickAssistExtractVariableProposal;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.TypeName;

public class VhdlQuickAssistExtractVariableProcessor
extends AbstractQuickAssistExtractProcessor {
    private List<IRegion> multipleOccurrences;
    private TypeName variableTypeName;
    private int minAnchorOffset = 1;

    public VhdlQuickAssistExtractVariableProcessor(ITextViewer viewer) {
        super(viewer);
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        try {
            if (!this.validateSelectedText(this.fDocument, this.fStartOffset, this.fEndOffset, "__vhdl_partitioning")) {
                return false;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
        VhdlSelectionTypeVisitor visitor = new VhdlSelectionTypeVisitor(this.fStartOffset, this.fEndOffset, this.fClosestContainer.getRfProject(), this.fDocument, true);
        this.fClosestContainer.getNamedElement().visitHidObject(null, visitor);
        this.variableTypeName = visitor.getElementTypeName();
        if (this.variableTypeName == null) {
            return false;
        }
        List<RfVariable> referencedVariables = visitor.getReferencedVariables();
        for (RfVariable variable : referencedVariables) {
            if (variable.getDeclaration() == null || variable.getDeclaration().getEndOffset() <= this.minAnchorOffset) continue;
            this.minAnchorOffset = variable.getDeclaration().getEndOffset();
        }
        return true;
    }

    private boolean validateSelectedText(IDocument document, int startOffset, int endOffset, String partitioningType) throws BadLocationException, BadPartitioningException {
        Character firstChar = null;
        Character endChar = null;
        int currentOffset = startOffset;
        while (currentOffset < endOffset) {
            char currentChar = document.getChar(currentOffset);
            if (!Character.isWhitespace(currentChar)) {
                String currentOffsetContentType;
                endChar = Character.valueOf(currentChar);
                if (firstChar == null) {
                    firstChar = Character.valueOf(currentChar);
                }
                if ((currentOffsetContentType = ((IDocumentExtension3)document).getContentType(partitioningType, currentOffset, false)).equals("__dftl_partition_content_type") && currentChar == ';') {
                    return false;
                }
            }
            ++currentOffset;
        }
        if (firstChar != null && !Character.isJavaIdentifierPart(firstChar.charValue()) && '(' != firstChar.charValue() && '\n' != firstChar.charValue() && '\r' != firstChar.charValue() && '\'' != firstChar.charValue() && '\"' != firstChar.charValue()) {
            return false;
        }
        return endChar == null || Character.isJavaIdentifierPart(endChar.charValue()) || ')' == endChar.charValue() || '\n' == endChar.charValue() || '\r' == endChar.charValue() || '\'' == endChar.charValue() || '\"' == endChar.charValue();
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        try {
            this.multipleOccurrences = new ArrayList<IRegion>();
            RfDefElement enclosingContainerDeclaration = this.fClosestContainer;
            if (this.fClosestContainer.getNamedElement() instanceof RfFunction && ((RfFunction)this.fClosestContainer.getNamedElement()).isPrototype()) {
                enclosingContainerDeclaration = ((RfFunction)this.fClosestContainer.getNamedElement()).getImplementation().getDefElement();
            }
            String scopeBody = this.fDocument.get(enclosingContainerDeclaration.getStartOffset(), enclosingContainerDeclaration.getEndOffset() - enclosingContainerDeclaration.getStartOffset());
            List textOccurrences = DVTQuickAssistUtil.getMultipleOccurrences((String)this.fSelectedText, (int)enclosingContainerDeclaration.getStartOffset(), (String)scopeBody, (String)"__vhdl_partitioning", (IDocument)this.fDocument);
            for (IRegion region : textOccurrences) {
                if (region.getOffset() == this.fStartOffset && region.getLength() == this.fEndOffset - this.fStartOffset) {
                    this.multipleOccurrences.add(region);
                    continue;
                }
                VhdlSelectionTypeVisitor visitor = new VhdlSelectionTypeVisitor(region.getOffset(), region.getOffset() + region.getLength(), this.fRfProject, this.fDocument, false);
                this.fClosestContainer.getNamedElement().visitHidObject(null, visitor);
                if (!this.variableTypeName.equals(visitor.getElementTypeName())) continue;
                this.multipleOccurrences.add(region);
            }
            if (this.multipleOccurrences.size() > 1) {
                result.add((DVTAbstractQuickAssistProposal)new QuickAssistExtractVariableProposal(this.variableTypeName, this.fClosestContainer, this.fStartOffset, this.fEndOffset, this.multipleOccurrences, "Extract to local variable", true, this.fFile, this.minAnchorOffset));
            }
            result.add((DVTAbstractQuickAssistProposal)new QuickAssistExtractVariableProposal(this.variableTypeName, this.fClosestContainer, this.fStartOffset, this.fEndOffset, this.multipleOccurrences, "Extract to local variable", false, this.fFile, this.minAnchorOffset));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }
}

