/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataAbstracts;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.model.reflection.ConfigInfo;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfListType;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfType;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vhdldt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.SEvaluator;
import ro.amiq.vhdldt.model.reflection.semantic.extension2.STransformer;
import ro.amiq.vhdldt.ui.editor.VhdlPairMatcherAccessor;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.TypeName;

public class VhdlSelectionTypeVisitor
implements IHidVisitor<IHidObject> {
    private static final IRfNamedElement NO_SUGGESTIONS = new DummyElement("NO_SUGGESTIONS");
    private int selectedTextStartOffset;
    private int selectedTextEndOffset;
    private RfProject rfProject;
    private boolean gatherReferencedVariables;
    private List<RfVariable> referencedVariables;
    private IDocument document;
    private String documentContent;
    private IHidHolder holder;
    private ParserPath parserPath;
    private IHidObject maxHidObject;
    private IHidObject newHidObject;
    private DVTPairMatcher matcher;
    private BiPredicate<IHidObject, IRfNamedElement> overallValidator = DEFAULT_VALIDATOR;
    private BiPredicate<IHidObject, IRfNamedElement> containsValidator = DEFAULT_CONTAINS_VALIDATOR;
    private static final BiPredicate<IHidObject, IRfNamedElement> DEFAULT_CONTAINS_VALIDATOR = new BiPredicate<IHidObject, IRfNamedElement>(){

        @Override
        public boolean test(IHidObject obj, IRfNamedElement elem) {
            switch (obj.getHidKind()) {
                case OPERATOR: {
                    IRfHidOperatorLayer op = (IRfHidOperatorLayer)obj;
                    if (op.isAssignment()) {
                        return false;
                    }
                    if (op.isWaitStatement()) {
                        return false;
                    }
                    if (!op.isWaitTimeoutClause()) break;
                    return false;
                }
                case HID: {
                    IRfNamedElement element = ((Hid)obj).getElement();
                    if (!(element instanceof RfVariable) || !((RfVariable)elem).isLoopParameter()) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    };
    private static final BiPredicate<IHidObject, IRfNamedElement> DEFAULT_VALIDATOR = new BiPredicate<IHidObject, IRfNamedElement>(){

        @Override
        public boolean test(IHidObject obj, IRfNamedElement elem) {
            switch (obj.getHidKind()) {
                case OPERATOR: {
                    if (!(obj instanceof RfHidOperator)) {
                        return false;
                    }
                    RfHidOperator op = (RfHidOperator)obj;
                    if (op.isRangeOrPartSelect()) {
                        return false;
                    }
                    if (op.isLiteralRange()) {
                        return false;
                    }
                    if (op.isAssignment()) {
                        return false;
                    }
                    if (op.isAssociation()) {
                        return false;
                    }
                    if (op.isArrow()) {
                        return false;
                    }
                    if (op.isBar()) {
                        return false;
                    }
                    if (!op.isEventControlOR()) break;
                    return false;
                }
                case ACCESS: {
                    obj = ((HidAccess)obj).getParentHid();
                    if (obj == null) {
                        return false;
                    }
                }
                case HID: {
                    Hid hid = (Hid)obj;
                    IRfNamedElement element = hid.getElement();
                    if (!(element instanceof IRfFieldElement) && !(element instanceof IRfMethodElement)) {
                        return false;
                    }
                    if (element instanceof RfType && !(element instanceof RfListType)) {
                        return false;
                    }
                    if (hid.hasQualifier(HidQualifierCache.LOOP_LABEL)) {
                        return false;
                    }
                    if (hid.hasQualifier(HidQualifierCache.PATTERN_KEY_QUALIFIER)) {
                        return false;
                    }
                    if (hid.hasQualifier(HidQualifierCache.FORMAL_PART_QUALIFIER)) {
                        return false;
                    }
                    if (!hid.hasQualifier(HidQualifierCache.EVENT_CONTROL_EXPR_QUALIFIER)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (elem instanceof RfFunction && ((RfFunction)elem).isTask()) {
                return false;
            }
            if ((elem = STransformer.INSTANCE.getBaseType(elem, false)) instanceof RfListType && ((RfListType)elem).isReducedListType()) {
                return false;
            }
            return elem instanceof RfNamedElement;
        }
    };

    public VhdlSelectionTypeVisitor(int startOffset, int endOffset, RfProject rfProject, IDocument document, boolean gatherReferencedVariables) {
        this.document = document;
        this.documentContent = document != null ? document.get() : null;
        this.selectedTextStartOffset = startOffset;
        this.selectedTextEndOffset = endOffset;
        this.rfProject = rfProject;
        this.gatherReferencedVariables = gatherReferencedVariables;
        this.referencedVariables = new ArrayList<RfVariable>();
        this.matcher = DVTPairMatcher.makePairMatcher((LanguageKind)LanguageKind.VHDL, (char[])new char[]{')', '('}, (DVTPairMatcherAccessor)new VhdlPairMatcherAccessor());
    }

    public void setContainsValidator(BiPredicate<IHidObject, IRfNamedElement> validator) {
        this.containsValidator = validator;
    }

    public void setOverallValidator(BiPredicate<IHidObject, IRfNamedElement> validator) {
        this.overallValidator = validator;
    }

    public List<RfVariable> getReferencedVariables() {
        return this.referencedVariables;
    }

    public void setHolder(IHidHolder holder) {
        this.holder = holder;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public boolean visit(IHidObject obj) {
        HidOperatorOccurrence hidOccurrence;
        this.newHidObject = obj;
        Object object = this.newHidObject instanceof HidOperator ? ((HidOperator)this.newHidObject).getOccurrence() : (hidOccurrence = this.newHidObject instanceof Hid ? ((Hid)this.newHidObject).getOccurrence() : null);
        if (hidOccurrence == null) {
            return true;
        }
        int occurrenceOffset = hidOccurrence.getOffset();
        if (DVTDocumentUtils.regionContains((IRegion)new Region(this.selectedTextStartOffset, this.selectedTextEndOffset - this.selectedTextStartOffset), (int)occurrenceOffset)) {
            IRfNamedElement resolvedElement = HidUtils.getResolvedElement((IHidObject)this.newHidObject);
            if (resolvedElement == null || resolvedElement == SDataAbstracts.UNDEFINED_ELEMENT) {
                ConfigInfo cInfo = new ConfigInfo(false, this.rfProject, this.rfProject != null ? this.rfProject.getEnclosingLibrary() : null, true, null);
                SEvaluator.INSTANCE.calculateHidObject(cInfo, (RfNamedElement)((HidHolder)this.holder).getScope(), this.parserPath, false, this.newHidObject, null);
            }
            if (!this.containsValidator.test(this.newHidObject, resolvedElement)) {
                this.maxHidObject = null;
                return false;
            }
            if (this.gatherReferencedVariables && HidUtils.isHid((IHidObject)obj) && resolvedElement instanceof RfVariable) {
                this.referencedVariables.add((RfVariable)resolvedElement);
            }
            int openNew = this.getOpenBoundary(this.newHidObject);
            int closeNew = this.getCloseBoundary(this.newHidObject);
            if (this.maxHidObject != null) {
                int openOld = this.getOpenBoundary(this.maxHidObject);
                int closeOld = this.getCloseBoundary(this.maxHidObject);
                if (closeNew - openNew <= closeOld - openOld || openNew >= openOld && closeNew <= closeOld) {
                    return true;
                }
            }
            if (openNew < this.selectedTextStartOffset || closeNew > this.selectedTextEndOffset) {
                if (HidUtils.isOperator((IHidObject)this.newHidObject) && ((HidOperator)this.newHidObject).getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                    this.maxHidObject = null;
                    return false;
                }
                return true;
            }
            this.maxHidObject = this.newHidObject;
            return true;
        }
        return true;
    }

    private int getOffsetOfNext(int startOffset, char find) {
        if (this.documentContent == null || startOffset < 0 || startOffset >= this.documentContent.length()) {
            return startOffset;
        }
        return this.documentContent.indexOf(find, startOffset);
    }

    private int getCloseBoundary(IHidObject obj) {
        if (obj instanceof HidOperator) {
            return ((HidOperator)obj).getCloseBoundary();
        }
        if (obj instanceof RfHid) {
            RfHid hid = (RfHid)obj;
            HidOccurrence occurrence = hid.getOccurrence();
            int endOffset = occurrence.getOffset() + hid.getName().length();
            if (hid.isMethodCall(false)) {
                RfHidAccess firstAccess = (RfHidAccess)hid.getFirstAccess();
                if (firstAccess == null) {
                    return endOffset;
                }
                List<IHidObject> argumentValues = firstAccess.getArgumentValues();
                if (argumentValues == null) {
                    return endOffset;
                }
                int max = !argumentValues.isEmpty() ? endOffset + 2 : -1;
                for (IHidObject av : argumentValues) {
                    int offset = this.getCloseBoundary(av);
                    if (offset <= max) continue;
                    max = offset;
                }
                return max;
            }
            ListContainer accesses = hid.getAccesses();
            if (accesses == null || accesses.isEmpty()) {
                return endOffset;
            }
            for (HidAccess access : accesses) {
                if (access.getAccessKind() == 0) {
                    if (access.getHids() == null || access.getHids().isEmpty()) {
                        return endOffset;
                    }
                    int offsetOfDot = this.getOffsetOfNext(endOffset, '.');
                    if (offsetOfDot < 0 || offsetOfDot >= this.selectedTextEndOffset) {
                        return endOffset;
                    }
                    this.newHidObject = (IHidObject)access.getHids().get(0);
                    return this.getCloseBoundary(this.newHidObject);
                }
                if (!access.isSelect()) continue;
                List selects = access.getSelects();
                if (selects == null || selects.isEmpty()) {
                    return endOffset;
                }
                int i = 0;
                while (i < selects.size()) {
                    IRegion match;
                    int offsetOfParanthesis = this.getOffsetOfNext(endOffset, '(') + 1;
                    if (offsetOfParanthesis <= 0 || offsetOfParanthesis > this.selectedTextEndOffset || (match = this.matcher.match(this.document, offsetOfParanthesis)) == null || match.getOffset() + match.getLength() > this.selectedTextEndOffset) break;
                    endOffset = match.getOffset() + match.getLength();
                    ++i;
                }
                if (i > 0 && i < selects.size()) {
                    this.newHidObject = access.upwardsCopy(true);
                    ((RfHidAccess)this.newHidObject).updateSelects(selects.subList(0, i));
                    ((RfHidAccess)this.newHidObject).resolveType(new ConfigInfo(false, this.rfProject, this.rfProject != null ? this.rfProject.getEnclosingLibrary() : null, true, null), false, false, ((RfHidHolder)this.holder).getScope(), hid.getElement(), null, false, false, false, this.parserPath);
                } else if (i >= selects.size()) {
                    this.newHidObject = access;
                }
                return endOffset;
            }
        }
        return -1;
    }

    private int getOpenBoundary(IHidObject obj) {
        if (obj instanceof HidOperator) {
            return ((HidOperator)obj).getOpenBoundary();
        }
        if (obj instanceof Hid && ((Hid)obj).getOccurrence() != null) {
            Hid parentHid = ((Hid)obj).getParentHid();
            if (parentHid != null) {
                this.newHidObject = parentHid;
                return this.getOpenBoundary(this.newHidObject);
            }
            return ((Hid)obj).getOccurrence().getOffset();
        }
        return Integer.MAX_VALUE;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }

    public TypeName getElementTypeName() {
        IRfNamedElement elementType = this.getElementType();
        if (elementType == NO_SUGGESTIONS) {
            return null;
        }
        return elementType == null ? TypeName.DEFAULT_TYPE_NAME : new TypeName(elementType);
    }

    public IRfNamedElement getElementType() {
        if (this.maxHidObject == null) {
            return NO_SUGGESTIONS;
        }
        IRfNamedElement resolvedElement = null;
        switch (this.maxHidObject.getHidKind()) {
            case HID: {
                resolvedElement = ((Hid)this.maxHidObject).getElement();
                break;
            }
            case OPERATOR: {
                ISDataAbstract operatorResolvedType = ((HidOperator)this.maxHidObject).getOperatorResolvedType();
                ISDataType dataType = SDataUtils.getDataType((ISDataAbstract)operatorResolvedType);
                resolvedElement = dataType != null ? dataType.getType() : null;
                break;
            }
            case ACCESS: {
                resolvedElement = ((HidAccess)this.maxHidObject).getAssociatedType();
                break;
            }
        }
        if (!this.overallValidator.test(this.maxHidObject, resolvedElement)) {
            return NO_SUGGESTIONS;
        }
        return STransformer.INSTANCE.getBaseType(resolvedElement, false);
    }
}

