/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistExtractVariableProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vhdldt.core.VhdlPlugin;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfNamedElement;
import ro.amiq.vhdldt.model.reflection.RfProcess;
import ro.amiq.vhdldt.model.reflection.RfTypeBody;
import ro.amiq.vhdldt.model.reflection.util.RfUtils;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class QuickAssistExtractVariableProposalCommon
extends DVTAbstractQuickAssistExtractVariableProposal {
    private TypeName fTypeName;
    private String fVariableTypeName;
    private int[] fConstraintOffsets;
    private int[] fConstraintLengths;
    private int minAnchorOffset;
    private int maxAnchorOffset;
    private RfDefElement fEnclosingContainerDef;

    protected QuickAssistExtractVariableProposalCommon(TypeName typeName, RfDefElement enclosingContainerDef, int startOffset, int endOffset, List<IRegion> multipleOccurrences, String displayString, boolean multiple, IFile file, int minAnchorOffset) {
        this.displayString = String.valueOf(displayString) + (multiple ? " (replace all occurrences)" : "");
        this.multiple = multiple;
        this.file = file;
        this.minAnchorOffset = minAnchorOffset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.multipleOccurrences = multipleOccurrences;
        this.maxAnchorOffset = this.startOffset;
        if (multiple && multipleOccurrences != null) {
            for (IRegion occ : multipleOccurrences) {
                if (occ.getOffset() >= this.maxAnchorOffset) continue;
                this.maxAnchorOffset = occ.getOffset();
            }
        }
        this.fTypeName = typeName;
        this.fVariableTypeName = typeName.getTypeName();
        this.fEnclosingContainerDef = enclosingContainerDef;
        this.linkedProposalModel = new LinkedModeModel();
    }

    protected void addLinkedPositions(IDocument document) throws Exception {
        this.linkedPositionMaker = new DVTLinkedPositionProvider(this.editor, this.linkedProposalModel, this.getCategory(), this.hasPositions, this.textFileChange);
        this.linkedPositionMaker.addSingleLinkedPosition(this.varTypeOffset, this.varTypeLength, this.document);
        if (this.fConstraintLengths != null && this.fConstraintOffsets != null) {
            int i = 0;
            while (i < this.fConstraintLengths.length) {
                this.linkedPositionMaker.addSingleLinkedPosition(this.fConstraintOffsets[i], this.fConstraintLengths[i], document);
                ++i;
            }
        }
        if (!this.isSpecifiedVarName()) {
            Collection absoluteRegions = this.textFileChange.getAbsoluteRegions();
            this.linkedPositionMaker.addMultipleLinkedPosition(absoluteRegions, this.document, -1);
        }
        this.linkedPositionMaker.enterLinkedMode(this.document, null);
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        IRfDefElement declarationAnchor = this.computeDeclarationAnchor();
        String indent = DVTDocumentUtils.getIndent((int)declarationAnchor.getStartOffset(), (IDocument)this.document);
        this.textFileChange = new VhdlTextFileChange(this.file.getProjectRelativePath().toOSString(), this.file);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        StringBuilder declarationIndent = new StringBuilder();
        int declarationOffset = this.getFinalDeclarationOffset(declarationIndent, declarationAnchor, indent);
        if (declarationOffset < 0) {
            return CreateChangeStatus.ERROR;
        }
        String extracted = this.document.get(this.startOffset, this.endOffset - this.startOffset);
        if (extracted == null) {
            return CreateChangeStatus.ERROR;
        }
        String typeName = this.fVariableTypeName;
        String variableKeyword = VhdlQuickFixUtil.getInstance().getCorrectCase("VARIABLE ", false);
        String variableName = this.isSpecifiedVarName ? this.specifiedVarName : "var_name";
        StringBuilder sbDeclaration = new StringBuilder(declarationIndent);
        sbDeclaration.append(variableKeyword);
        sbDeclaration.append(variableName).append(" : ");
        sbDeclaration.append(typeName);
        this.varTypeOffset = declarationOffset + sbDeclaration.toString().lastIndexOf(typeName);
        this.varTypeLength = typeName.length();
        List<String> constraints = this.fTypeName.getConstraints();
        if (constraints != null && !constraints.isEmpty()) {
            sbDeclaration.append("(");
            int currentOffset = sbDeclaration.length();
            int size = constraints.size();
            this.fConstraintLengths = new int[size];
            this.fConstraintOffsets = new int[size];
            int i = 0;
            while (i < size) {
                String constr = constraints.get(i);
                this.fConstraintOffsets[i] = declarationOffset + currentOffset;
                this.fConstraintLengths[i] = constr.length();
                sbDeclaration.append(constr).append(i == size - 1 ? "" : ", ");
                currentOffset = sbDeclaration.length();
                ++i;
            }
            sbDeclaration.append(")");
        }
        if (declarationAnchor.getNamedElement() instanceof RfProcess) {
            sbDeclaration.append(";").append(NEWLINE).append(this.declareBeforeBegin ? indent : "");
        }
        int declarationChangeRelativeOffset = sbDeclaration.toString().indexOf(variableName);
        DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)declarationOffset, (int)sbDeclaration.length(), (String)sbDeclaration.toString(), (int)declarationChangeRelativeOffset, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.INSERT, (String)variableName);
        this.addInitialisation(indent, declarationOffset, extracted, (RfNamedElement)declarationAnchor.getNamedElement());
        if (!this.multiple) {
            int startOffset = this.startOffset;
            int length = this.endOffset - this.startOffset;
            DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)startOffset, (int)length, (String)variableName, (int)0, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.REPLACE, (String)variableName);
        } else {
            for (IRegion region : this.multipleOccurrences) {
                DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)region.getOffset(), (int)region.getLength(), (String)variableName, (int)0, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.REPLACE, (String)variableName);
            }
        }
        this.hasPositions = true;
        return CreateChangeStatus.OK;
    }

    private void addInitialisation(String indent, int declarationOffset, String extracted, RfNamedElement anchorElement) throws Exception {
        StringBuilder sbInitialization = new StringBuilder();
        if (anchorElement instanceof RfProcess) {
            IRegion lineInformationOfOffset = this.document.getLineInformationOfOffset(this.startOffset);
            declarationOffset = lineInformationOfOffset.getOffset();
            indent = DVTDocumentUtils.getIndent((int)declarationOffset, (IDocument)this.document);
            sbInitialization.append(indent).append(this.isSpecifiedVarName ? this.specifiedVarName : "var_name");
            sbInitialization.append(" := ").append(extracted).append(";").append(DVTQuickFixUtil.NEW_LINE);
        } else {
            sbInitialization.append(" := ").append(extracted).append(";").append(DVTQuickFixUtil.NEW_LINE).append(this.declareBeforeBegin ? indent : "");
        }
        int initializationOffset = declarationOffset;
        InsertEdit initialisation = new InsertEdit(initializationOffset, sbInitialization.toString());
        this.textFileChange.addEdit((TextEdit)initialisation);
    }

    /*
     * Unable to fully structure code
     */
    private int getFinalDeclarationOffset(StringBuilder declarationIndent, IRfDefElement declarationAnchor, String indent) throws Exception {
        block8: {
            block7: {
                useSpacesNotTabs = this.editor.isInsertSpaces(VhdlPlugin.getDefault().getCombinedPreferenceStore());
                tabOrSpace = TextUtils.getIndentTab((boolean)useSpacesNotTabs, (int)this.editor.getTabWidth());
                lineInformationOfOffset = this.document.getLineInformationOfOffset(declarationAnchor.getStartOffset());
                declarationOffset = declarationAnchor.getStartOffset();
                semicolonOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.document, ";", declarationAnchor.getStartOffset(), this.fEnclosingContainerDef.getEndOffset(), false);
                if (this.declareBeforeBegin) break block7;
                if (this.maxAnchorOffset >= declarationOffset && this.maxAnchorOffset <= semicolonOffset) {
                    declarationOffset = lineInformationOfOffset.getOffset();
                    beginKeywordLine = this.document.getLineOfOffset(declarationOffset);
                    beginKeywordLineOffset = this.document.getLineOffset(beginKeywordLine);
                    textBeforeBegin = this.document.get(beginKeywordLineOffset, declarationOffset - beginKeywordLineOffset);
                    noTextBeforeBeginKeyword = textBeforeBegin.trim().isEmpty();
                    declarationIndent.append(noTextBeforeBeginKeyword != false ? "" : String.valueOf(DVTQuickFixUtil.NEW_LINE) + tabOrSpace).append(indent);
                } else if (this.maxAnchorOffset > semicolonOffset) {
                    declarationOffset = semicolonOffset;
                    declarationIndent.append(DVTQuickFixUtil.NEW_LINE).append(indent);
                }
                break block8;
            }
            declarationOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.document, "begin", this.fEnclosingContainerDef.getStartOffset(), this.fEnclosingContainerDef.getEndOffset(), false);
            beginScope = RfUtils.getRfScope((ITextEditor)this.editor, this.document, declarationOffset);
            if (beginScope == null) {
                return -1;
            }
            closestContainer = VhdlQuickFixUtil.getInstance().getEnclosingScope(this.fEnclosingContainerDef, new Class[]{RfProcess.class, RfFunction.class, RfTypeBody.class});
            if (closestContainer != null) ** GOTO lbl35
            return -1;
lbl-1000:
            // 1 sources

            {
                declarationOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(this.document, "begin", declarationOffset, this.fEnclosingContainerDef.getEndOffset(), false);
                if (declarationOffset < 0 || declarationOffset >= this.fEnclosingContainerDef.getEndOffset()) {
                    declarationOffset = -1;
                    return -1;
                }
                beginScope = RfUtils.getRfScope((ITextEditor)this.editor, this.document, declarationOffset);
                if (beginScope == null) break;
lbl35:
                // 2 sources

                ** while (closestContainer.getDeclaration() != null && !closestContainer.getDeclaration().equals((Object)beginScope))
            }
lbl36:
            // 2 sources

            if (declarationOffset < 0) {
                return -1;
            }
            beginKeywordLine = this.document.getLineOfOffset(declarationOffset -= "begin".length());
            beginKeywordLineOffset = this.document.getLineOffset(beginKeywordLine);
            declarationIndent.append((noTextBeforeBeginKeyword = (textBeforeBegin = this.document.get(beginKeywordLineOffset, declarationOffset - beginKeywordLineOffset)).trim().isEmpty()) != false ? "" : String.valueOf(DVTQuickFixUtil.NEW_LINE) + tabOrSpace).append(indent);
        }
        return declarationOffset;
    }

    @NotNull
    private IRfDefElement computeDeclarationAnchor() {
        IRfDefElement declarationCandidate = VhdlQuickFixUtil.getInstance().computeDeclarationAnchor(this.fEnclosingContainerDef.getNamedElement(), this.minAnchorOffset, this.maxAnchorOffset);
        if (declarationCandidate == null) {
            this.declareBeforeBegin = true;
        }
        return declarationCandidate != null ? declarationCandidate : this.fEnclosingContainerDef;
    }
}

