/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAddQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;
import ro.amiq.vhdldt.ui.refactor.addgeneric.VhdlRefactorAddGenericAlgorithm;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;

public abstract class AddGenericQuickFixCommon
extends BaseAddQuickFix {
    protected static final String PARAMETER_DEFAULT_VALUE = "DEFAULT_VALUE";

    protected AddGenericQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, IRfDesignElement instanceDesignElem, IRfDesignElement triggerEntityScope) {
        super(marker, viewer);
        this.instance = instance;
        this.instanceEntity = instanceDesignElem;
        this.triggerArchitecture = triggerEntityScope;
        this.allBoxedWords = new LinkedHashSet();
        this.linkedProposalModel = new LinkedModeModel();
        this.linkedPositionRegions = new ArrayList();
        this.instanceEntityGenerics = new ArrayList();
    }

    @Override
    protected DVTTextFileChange createChange() throws Exception {
        this.textFileChange = new VhdlTextFileChange(this.targetFile.getProjectRelativePath().toOSString(), this.targetFile);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(this.wizardInput.getNewElementName(), this.wizardInput.getType());
        if (targetFileChanges == null) {
            return null;
        }
        for (TextChange textChg : targetFileChanges) {
            InsertEdit portListInsertEdit = new InsertEdit(textChg.offset, textChg.text);
            this.textFileChange.addEdit((TextEdit)portListInsertEdit);
        }
        return this.textFileChange;
    }

    private List<TextChange> computeTargetFileTextChanges(String genericName, String genericType) {
        ArrayList<TextChange> targetFileChanges = new ArrayList<TextChange>();
        VhdlRefactorAddGenericAlgorithm addGenericAlgorithm = new VhdlRefactorAddGenericAlgorithm(this.wizardInput, this.triggerEditor.getProject());
        Set<RefactorInputWrapper> wrappers = addGenericAlgorithm.computeChangeWrappers();
        if (wrappers == null) {
            return null;
        }
        Set<TextChange> textChgs = addGenericAlgorithm.computeChangesFromWrappers(wrappers, (IProgressMonitor)new NullProgressMonitor());
        for (TextChange textChg : textChgs) {
            IRfDefElement entityDeclaration;
            IFile currentFile = textChg.file;
            if (currentFile == null || !currentFile.equals((Object)this.targetFile) || (entityDeclaration = this.instanceEntity.getDeclaration()) == null || textChg.offset <= entityDeclaration.getStartOffset() || textChg.offset >= entityDeclaration.getEndOffset()) continue;
            targetFileChanges.add(textChg);
        }
        return targetFileChanges;
    }

    @Override
    public void computeElementInfo() {
        String genericName = this.elementName;
        String genericType = VhdlQuickFixUtil.getInstance().guessElementType(this.enclosingScope.getNamedElement(), this.elementName);
        this.allBoxedWords.add(genericType);
        this.allBoxedWords.add(PARAMETER_DEFAULT_VALUE);
        this.wizardInput = new VhdlRefactorAddWizardInput(this.instanceEntity, genericName, "", genericType, "", PARAMETER_DEFAULT_VALUE);
    }

    public String getDisplayString() {
        return "Add generic '" + this.elementName + "' to '" + this.instanceEntity.getName() + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_GENERIC);
    }

    @Override
    public String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    @Override
    protected void updateOpenWizard(boolean hasMultipleInstances) {
        this.openWizard = hasMultipleInstances;
    }
}

