/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.RefactorInputWrapper;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vhdldt.model.reflection.RfPort;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAddQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;
import ro.amiq.vhdldt.ui.refactor.addport.VhdlRefactorAddPortAlgorithm;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;

public abstract class AddPortQuickFixCommon
extends BaseAddQuickFix {
    protected Set<IHid> undeclaredPortConnections;
    protected Collection<? extends IRfPortElement> triggerEntityPorts;

    protected AddPortQuickFixCommon(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, Set<IHid> undeclaredPortConnections, IRfDesignElement instanceDesignElem, IRfDesignElement triggerEntityScope) {
        super(marker, viewer);
        this.instance = instance;
        this.undeclaredPortConnections = undeclaredPortConnections;
        this.instanceEntity = instanceDesignElem;
        this.triggerArchitecture = triggerEntityScope;
        this.allBoxedWords = new LinkedHashSet();
        this.linkedProposalModel = new LinkedModeModel();
        this.linkedPositionRegions = new ArrayList();
        this.instanceEntityGenerics = new ArrayList();
    }

    @Override
    protected DVTTextFileChange createChange() throws Exception {
        this.textFileChange = new VhdlTextFileChange(this.targetFile.getProjectRelativePath().toOSString(), this.targetFile);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        List<TextChange> targetFileChanges = this.computeTargetFileTextChanges(this.wizardInput.getNewElementName(), this.wizardInput.getDirection(), this.wizardInput.getType());
        if (targetFileChanges == null) {
            return null;
        }
        for (TextChange textChg : targetFileChanges) {
            InsertEdit portListInsertEdit = new InsertEdit(textChg.offset, textChg.text);
            this.textFileChange.addEdit((TextEdit)portListInsertEdit);
        }
        return this.textFileChange;
    }

    private List<TextChange> computeTargetFileTextChanges(String portName, String portDirection, String portType) {
        ArrayList<TextChange> targetFileChanges = new ArrayList<TextChange>();
        VhdlRefactorAddPortAlgorithm addPortAlgorithm = new VhdlRefactorAddPortAlgorithm(this.wizardInput, this.triggerEditor.getProject());
        Set<RefactorInputWrapper> wrappers = addPortAlgorithm.computeChangeWrappers();
        if (wrappers == null) {
            return null;
        }
        Set<TextChange> textChgs = addPortAlgorithm.computeChangesFromWrappers(wrappers, (IProgressMonitor)new NullProgressMonitor());
        for (TextChange textChg : textChgs) {
            IRfDefElement entityDeclarationDeclaration;
            IFile currentFile = textChg.file;
            if (currentFile == null || !currentFile.equals((Object)this.targetFile) || (entityDeclarationDeclaration = this.instanceEntity.getDeclaration()) == null || textChg.offset <= entityDeclarationDeclaration.getStartOffset() || textChg.offset >= entityDeclarationDeclaration.getEndOffset()) continue;
            targetFileChanges.add(textChg);
        }
        return targetFileChanges;
    }

    protected String computePortDirection() {
        String direction = "in";
        for (IHid portConnection : this.undeclaredPortConnections) {
            IRfNamedElement portNamedElement = portConnection.getElement();
            if (portNamedElement == null || !(portNamedElement instanceof IRfPortElement) || !this.triggerEntityPorts.contains(portNamedElement)) continue;
            direction = ((RfPort)portNamedElement).getDirection();
            if (direction != null && !direction.isEmpty()) break;
            direction = "in";
            break;
        }
        return direction;
    }

    @Override
    public void computeElementInfo() {
        String portName = this.elementName;
        String portDirection = "in";
        this.triggerEntityPorts = this.triggerArchitecture.getLocalPorts();
        if (this.triggerEntityPorts != null && !this.triggerEntityPorts.isEmpty()) {
            portDirection = this.computePortDirection();
        }
        String portType = VhdlQuickFixUtil.getInstance().guessElementType(this.enclosingScope.getNamedElement(), this.elementName);
        this.allBoxedWords.add(portDirection);
        this.allBoxedWords.add(portType);
        this.wizardInput = new VhdlRefactorAddWizardInput(this.instanceEntity, portName, portDirection, portType, "");
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INOUT_PORT);
    }

    public String getDisplayString() {
        return "Add port '" + this.elementName + "' to '" + this.instanceEntity.getName() + "'";
    }

    @Override
    public String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    @Override
    protected void updateOpenWizard(boolean hasMultipleInstances) {
        this.openWizard = hasMultipleInstances;
    }
}

