/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vhdldt.model.reflection.RfInstance;
import ro.amiq.vhdldt.model.reflection.RfManager;
import ro.amiq.vhdldt.model.reflection.RfProject;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorAddWizardInput;
import ro.amiq.vhdldt.ui.refactor.designelement.VhdlRefactorDesignElementUtils;

public abstract class BaseAddQuickFix
extends BaseAbstractQuickFix {
    protected List<IRfNamedElement> instanceEntityGenerics;
    protected boolean hasGeneric;
    protected IRfDesignElement instanceEntity;
    protected IRfInstanceElement instance;
    protected IRfDesignElement triggerArchitecture;
    protected Set<String> allBoxedWords;
    protected boolean shouldDisconnect;
    protected ITextFileBufferManager bufferManager;
    protected IPath targetFullPath;
    protected List<IRegion> linkedPositionRegions;
    protected IFile targetFile;
    protected boolean openWizard;
    protected VhdlRefactorAddWizardInput wizardInput;
    private IPath path;
    private LocationKind locationKind;

    protected BaseAddQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        IRfSingleLangProject rfProject = this.instance.getRfProject();
        if (rfProject == null) {
            return;
        }
        rfProject = RfManager.getInstance().getRfProject(rfProject.getProject());
        if (rfProject instanceof RfProject) {
            List<RfInstance> allInstancesOfDesignElement = VhdlRefactorDesignElementUtils.collectInstancesOfDesign((RfProject)rfProject, (IRfNamedElement)this.instanceEntity);
            this.updateOpenWizard(allInstancesOfDesignElement.size() > 1);
        }
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.computeElementInfo();
        if (!this.openWizard) {
            this.computeTargetElements();
            this.computeInstanceEntityGenericVariables();
            this.textFileChange = this.createChange();
            if (this.textFileChange == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    private void computeTargetElements() throws CoreException {
        IResource instanceDesignElementFileAdapter = this.instanceEntity.getFileAdapter();
        IResource instanceFileAdapter = this.instance.getFileAdapter();
        if (instanceDesignElementFileAdapter == null || instanceFileAdapter == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.targetFile = (IFile)instanceDesignElementFileAdapter;
        this.targetFullPath = instanceDesignElementFileAdapter.getLocation();
        if (instanceDesignElementFileAdapter.equals((Object)instanceFileAdapter)) {
            return;
        }
        this.bufferManager = FileBuffers.getTextFileBufferManager();
        this.shouldDisconnect = false;
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(this.targetFile);
        this.path = textFileBufferInfo.getPath();
        this.locationKind = textFileBufferInfo.getLocationKind();
        ITextFileBuffer textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        if (textFileBuffer == null) {
            this.shouldDisconnect = true;
            this.bufferManager.connect(this.targetFullPath, this.locationKind, null);
            textFileBuffer = this.bufferManager.getTextFileBuffer(this.path, this.locationKind);
        }
        if (textFileBuffer != null) {
            this.targetDocument = textFileBuffer.getDocument();
        }
        if (this.targetDocument == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.targetEditor = this.getAndOpenEditor(instanceDesignElementFileAdapter);
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (!this.openWizard) {
            Object[] affectedObjects = this.textFileChange.getAffectedObjects();
            IFile[] affectedFiles = new IFile[affectedObjects.length];
            int i = 0;
            while (i < affectedObjects.length) {
                Object affectedObject = affectedObjects[i];
                if (affectedObject instanceof IFile) {
                    affectedFiles[i] = (IFile)affectedObject;
                }
                ++i;
            }
            return affectedFiles;
        }
        return new IFile[0];
    }

    private void computeInstanceEntityGenericVariables() {
        List entityVariables = this.instanceEntity.getLocalParameters();
        if (entityVariables != null) {
            for (IRfNamedElement entityVariable : entityVariables) {
                if (entityVariable instanceof RfVariable && !((RfVariable)entityVariable).isParameter()) continue;
                this.instanceEntityGenerics.add(entityVariable);
            }
        }
        this.hasGeneric = this.instanceEntityGenerics != null && !this.instanceEntityGenerics.isEmpty();
    }

    protected void addLinkedPositions() throws BadLocationException, BadPositionCategoryException, CoreException {
        TextEdit[] allEdits = null;
        TextEdit rootEdit = this.textFileChange.getEdit();
        if (rootEdit instanceof MultiTextEdit) {
            allEdits = ((MultiTextEdit)rootEdit).getChildren();
        }
        if (allEdits != null) {
            TextEdit[] textEditArray = allEdits;
            int n = allEdits.length;
            int n2 = 0;
            while (n2 < n) {
                int editOffset;
                TextEdit edit = textEditArray[n2];
                String editText = "";
                if (edit instanceof InsertEdit) {
                    editText = ((InsertEdit)edit).getText();
                } else if (edit instanceof ReplaceEdit) {
                    editText = ((ReplaceEdit)edit).getText();
                }
                if (!editText.isEmpty() && (editOffset = edit.getOffset()) >= 0) {
                    for (String word : this.allBoxedWords) {
                        this.linkedPositionRegions.addAll(VhdlQuickFixUtil.computeLinkedRegionsForWord((String)editText, (String)word, (int)editOffset));
                    }
                }
                ++n2;
            }
            if (!this.linkedPositionRegions.isEmpty()) {
                this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
                for (IRegion linkedRegion : this.linkedPositionRegions) {
                    this.linkedPositionProvider.addSingleLinkedPosition(linkedRegion.getOffset(), linkedRegion.getLength(), this.targetDocument);
                }
                DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, this.triggerEditor.getCursor(), "__vhdl_partitioning");
                this.linkedPositionProvider.enterLinkedMode(this.targetDocument, config);
            }
        }
        if (this.shouldDisconnect) {
            this.bufferManager.disconnect(this.path, this.locationKind, null);
        }
    }

    public abstract void computeElementInfo();

    protected abstract DVTTextFileChange createChange() throws Exception;

    public abstract String getCategory();

    protected abstract void updateOpenWizard(boolean var1);
}

