/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class CaseChoiseAddQuickFix
extends BaseAbstractQuickFix {
    private int selectOffset;
    private String replacementString;
    private int insertOffset;

    public CaseChoiseAddQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Add case choice '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_BLOCK);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        char read;
        int startOffset = this.enclosingScope.getStartOffset();
        int endOffset = this.enclosingScope.getEndOffset();
        this.insertOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, "end", startOffset, endOffset, true, true);
        int previousWhenOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, "when", startOffset, this.insertOffset, false, false);
        String previousWhen = document.get(previousWhenOffset, 4);
        DVTCharacterScanner charScanner = new DVTCharacterScanner(100, document, previousWhenOffset - 1, false);
        while (Character.isWhitespace(read = (char)charScanner.read())) {
        }
        int previusWhenLineStartOffset = charScanner.getOffset() + 1;
        String indent = document.get(previusWhenLineStartOffset, previousWhenOffset - previusWhenLineStartOffset);
        this.replacementString = "\n" + indent + previousWhen + " " + this.elementName + " =>\n";
        this.selectOffset = this.insertOffset + this.replacementString.length();
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        ReplaceEdit replaceEdit = new ReplaceEdit(this.insertOffset, 0, this.replacementString);
        this.textFileChange.addEdit((TextEdit)replaceEdit);
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.enclosingScope.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        if (this.insertOffset < 0) {
            return;
        }
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.selectOffset, 0);
    }
}

