/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vhdldt.model.reflection.DataType;
import ro.amiq.vhdldt.model.reflection.RfDefElement;
import ro.amiq.vhdldt.model.reflection.RfFunction;
import ro.amiq.vhdldt.model.reflection.RfVariable;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.AbstractVariableQuickFix;
import ro.amiq.vhdldt.ui.editor.quickfix.util.VhdlQuickFixUtil;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public abstract class DeclareArgumentQuickFixCommon
extends AbstractVariableQuickFix {
    protected int insertOffset;
    private IRfDefElement declaration;

    protected DeclareArgumentQuickFixCommon(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
    }

    public String getDisplayString() {
        return "Declare argument '" + this.elementName + "'";
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        RfFunction function = ((RfDefElement)this.enclosingScope).getEnclosingScope(RfFunction.class);
        StringBuilder replacementString = new StringBuilder();
        this.insertOffset = -1;
        String typeName = VhdlQuickFixUtil.getInstance().getCorrectCase(VhdlQuickFixUtil.getInstance().guessElementType(function, this.elementName), true);
        boolean isIdentifier = DVTStringUtil.isIdentifier((String)typeName);
        String direction = VhdlQuickFixUtil.getInstance().getCorrectCase(VhdlQuickFixUtil.getInstance().guessVariableDirection(function, this.elementName), false);
        this.declaration = null;
        List<RfVariable> arguments = function.getArguments();
        HashMap<String, List<Region>> trackedRegions = new HashMap<String, List<Region>>();
        if (arguments != null && !arguments.isEmpty()) {
            RfVariable lastArgument = arguments.get(arguments.size() - 1);
            this.declaration = lastArgument.getDeclaration();
            replacementString.append("; " + this.elementName + " : ");
            trackedRegions.put("direction", Collections.singletonList(new Region(replacementString.length(), direction.length())));
            replacementString.append(String.valueOf(direction) + " ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(typeName);
        } else {
            Collection<? extends RfDefElement> declarations = function.getDeclarations();
            if (declarations != null) {
                for (IRfDefElement iRfDefElement : declarations) {
                    IResource declResource = (IResource)iRfDefElement.getDefFile().getAdapter(IResource.class);
                    if (declResource == null || !declResource.equals((Object)this.marker.getResource()) || this.offset <= iRfDefElement.getStartOffset() || this.offset >= iRfDefElement.getEndOffset()) continue;
                    this.declaration = iRfDefElement;
                    break;
                }
            }
            replacementString.append("(" + this.elementName + " : ");
            trackedRegions.put("direction", Collections.singletonList(new Region(replacementString.length(), direction.length())));
            replacementString.append(String.valueOf(direction) + " ");
            if (isIdentifier) {
                trackedRegions.put("typeName", Collections.singletonList(new Region(replacementString.length(), typeName.length())));
            }
            replacementString.append(String.valueOf(typeName) + ") ");
        }
        if (this.declaration == null) {
            return;
        }
        int startOffset = this.declaration.getStartOffset();
        int n = this.declaration.getEndOffset() + 1000;
        DataType assocDataType = function.getDataType();
        if (assocDataType != null && assocDataType.getTypeName() != null) {
            this.insertOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "return", startOffset, n, false);
            if (this.insertOffset < 0) {
                return;
            }
            this.insertOffset -= "return".length();
        } else {
            this.insertOffset = VhdlQuickFixUtil.getInstance().getForwardOffsetFor(document, "is", startOffset, n, false);
            if (this.insertOffset < 0) {
                return;
            }
            this.insertOffset -= "is".length();
        }
        int rparenOffset = VhdlQuickFixUtil.getInstance().getBackwardOffsetFor(document, ")", startOffset, this.insertOffset, true, true);
        if (rparenOffset > 0 && rparenOffset < this.insertOffset) {
            this.insertOffset = rparenOffset;
        }
        if (this.insertOffset < 0) {
            return;
        }
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, replacementString.toString());
        this.textFileChange.addEdit((TextEdit)insertEdit, trackedRegions);
    }

    protected void addLinkedPositions() throws BadLocationException, BadPositionCategoryException {
        Collection typeNameRegions;
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.triggerEditor, this.targetEditor, this.linkedProposalModel, this.getCategory(), true, true, this.textFileChange);
        Collection directionRegions = this.textFileChange.getAbsoluteRegionsByCategory("direction");
        if (directionRegions != null && !directionRegions.isEmpty()) {
            for (IRegion directionRegion : directionRegions) {
                this.linkedPositionProvider.addSingleLinkedPosition(directionRegion.getOffset(), directionRegion.getLength(), this.targetDocument);
            }
        }
        if ((typeNameRegions = this.textFileChange.getAbsoluteRegionsByCategory("typeName")) != null && !typeNameRegions.isEmpty()) {
            for (IRegion typeNameRegion : typeNameRegions) {
                this.linkedPositionProvider.addSingleLinkedPosition(typeNameRegion.getOffset(), typeNameRegion.getLength(), this.targetDocument);
            }
        }
        this.linkedPositionProvider.enterLinkedMode(this.targetDocument, null);
    }

    public String getCategory() {
        return "QuickFixCategory_" + ((Object)((Object)this)).toString();
    }

    public IFile[] getAffectedFiles() throws Exception {
        IResource elementResource = this.declaration.getFileAdapter();
        if (elementResource == null || !(elementResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)elementResource);
        return affectedFiles.toArray(new IFile[1]);
    }
}

