/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vhdldt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.vhdldt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.vhdldt.ui.refactor.VhdlTextFileChange;

public class DeclareEnumQuickFix
extends BaseAbstractQuickFix {
    private int insertOffset;
    private String insertText;

    public DeclareEnumQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public String getDisplayString() {
        return "Declare enum type value '" + this.elementName + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        this.insertOffset = this.marker.getAttribute("QUICKFIX_ENUM_INSERT_OFFSET", -1);
        this.insertText = ", " + this.elementName;
        this.textFileChange = new VhdlTextFileChange(this.targetResource.getProjectRelativePath().toOSString(), (IFile)this.targetResource);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        InsertEdit insertEdit = new InsertEdit(this.insertOffset, this.insertText);
        this.textFileChange.addEdit((TextEdit)insertEdit, (IRegion)new Region(this.insertText.length(), this.insertText.length()));
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        String parserPath = this.marker.getAttribute("QUICKFIX_INSERT_FILE", null);
        if (parserPath != null && this.marker.getResource() != null) {
            IProject project = this.marker.getResource().getProject();
            this.targetResource = this.getResource(project, parserPath);
            this.triggerEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
        }
    }

    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.targetEditor, document, this.getDisplayString(), (Change)this.textFileChange);
        this.targetEditor.selectAndReveal(this.insertOffset, this.insertText.length());
    }

    public IFile[] getAffectedFiles() throws Exception {
        if (this.targetResource == null || !(this.targetResource instanceof IFile)) {
            return null;
        }
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add((IFile)this.targetResource);
        return affectedFiles.toArray(new IFile[1]);
    }

    public String getFilePathToBeFocusedAfterApply() {
        return this.targetResource.getLocation().toOSString();
    }
}

